/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class VorbisDecoder
implements Codec {
    private static final String CODEC_NAME = "Vorbis decoder";
    private static final Format[] supportedInputFormats = new Format[]{new AudioFormat("audio/x-vorbis", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("audio/vorbis", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    private static final Format[] supportedOutputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    private VorbisStream vorbisStream = new VorbisStream();

    public Format[] getSupportedInputFormats() {
        return supportedInputFormats;
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return supportedOutputFormats;
        }
        AudioFormat[] res = new AudioFormat[]{new AudioFormat("LINEAR", ((AudioFormat)input).getSampleRate(), ((AudioFormat)input).getSampleSizeInBits(), ((AudioFormat)input).getChannels(), 1, 1, -1, -1.0, Format.byteArray)};
        return res;
    }

    public int process(Buffer in, Buffer out) {
        try {
            byte[] res = this.vorbisStream.processPacket((byte[])in.getData());
            if (res == null) {
                return 4;
            }
            byte[] buffer = (byte[])out.getData();
            if (buffer == null || res.length > buffer.length) {
                out.setData((Object)res);
            } else {
                System.arraycopy(res, 0, buffer, 0, res.length);
            }
            out.setOffset(0);
            long time = this.vorbisStream.getCurrentGranulePosition() * 1000000000L / (long)this.vorbisStream.getIdentificationHeader().getSampleRate();
            out.setTimeStamp(time);
            out.setLength(res.length);
            return 0;
        }
        catch (VorbisFormatException e) {
            return 1;
        }
        catch (IOException e) {
            return 1;
        }
    }

    public Format setInputFormat(Format format) {
        return format;
    }

    public Format setOutputFormat(Format format) {
        return format;
    }

    public void open() {
    }

    public void close() {
    }

    public void reset() {
    }

    public String getName() {
        return CODEC_NAME;
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return null;
    }
}

