/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.usermgmt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import rs.co.ast.aspen.api.service.ConsoleUser;
import rs.co.ast.aspen.gui.module.usermgmt.ConsoleUserService;
import rs.co.ast.aspen.gui.module.usermgmt.CreateConsoleUserAction;
import rs.co.ast.aspen.gui.module.usermgmt.CreateUserPrompt;
import rs.co.ast.aspen.gui.module.usermgmt.DeleteConsoleUserAction;
import rs.co.ast.aspen.gui.module.usermgmt.UserChildFactory;
import rs.co.ast.aspen.gui.module.usermgmt.UsersTableModel;

public class UsersPanel
extends JPanel {
    private final ConsoleUserService cus = (ConsoleUserService)Lookup.getDefault().lookup(ConsoleUserService.class);
    private final ExplorerManager explorerManager = new ExplorerManager();
    private DialogDescriptor dd;
    private CreateUserPrompt cup;
    private final TreeTableView treeTableView = new TreeTableView();
    private UsersTableModel usersTableModel = new UsersTableModel();
    private ConsoleUser selectedUser = null;
    private final Lookup.Result<ConsoleUser> lr = Utilities.actionsGlobalContext().lookupResult(ConsoleUser.class);
    private JButton bDelete;
    private JButton bNew;
    private JScrollPane jScrollPane1;

    public UsersPanel() {
        this.initComponents();
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                Collection instances = lr.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof ConsoleUser)) continue;
                    ConsoleUser u = (ConsoleUser)o;
                    UsersPanel.this.selectedUser = u;
                }
            }
        });
    }

    public void displayUsers() {
        AbstractNode node = new AbstractNode(Children.create((ChildFactory)new UserChildFactory(), (boolean)true));
        node.setDisplayName(NbBundle.getMessage(UsersPanel.class, (String)"users.title"));
        this.explorerManager.setRootContext((Node)node);
    }

    private void initComponents() {
        this.jScrollPane1 = this.treeTableView;
        this.bNew = new JButton();
        this.bDelete = new JButton();
        this.bNew.setIcon(new ImageIcon(this.getClass().getResource("/rs/co/ast/aspen/gui/module/usermgmt/user_add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bNew, (String)NbBundle.getMessage(UsersPanel.class, (String)"UsersPanel.bNew.text"));
        this.bNew.setToolTipText(NbBundle.getMessage(UsersPanel.class, (String)"UsersPanel.bNew.toolTipText"));
        this.bNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsersPanel.this.bNewActionPerformed(evt);
            }
        });
        this.bDelete.setIcon(new ImageIcon(this.getClass().getResource("/rs/co/ast/aspen/gui/module/usermgmt/user_delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bDelete, (String)NbBundle.getMessage(UsersPanel.class, (String)"UsersPanel.bDelete.text"));
        this.bDelete.setToolTipText(NbBundle.getMessage(UsersPanel.class, (String)"UsersPanel.bDelete.toolTipText"));
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsersPanel.this.bDeleteActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.bNew, -1, 70, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDelete, -1, 71, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 217, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bNew).addComponent(this.bDelete)).addContainerGap()));
    }

    private void bNewActionPerformed(ActionEvent evt) {
        CreateConsoleUserAction ccua = new CreateConsoleUserAction();
        ccua.actionPerformed(evt);
    }

    private void bDeleteActionPerformed(ActionEvent evt) {
        if (this.selectedUser != null) {
            DeleteConsoleUserAction dcua = new DeleteConsoleUserAction(this.selectedUser);
            dcua.actionPerformed(evt);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }
}

