/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.Map;

public class SkeletonInterBoneWire
extends Mesh {
    private static final int POINT_AMOUNT = 10;
    private int connectionsAmount;
    private Skeleton skeleton;
    private Map<Integer, Float> boneLengths;

    public SkeletonInterBoneWire(Skeleton skeleton, Map<Integer, Float> boneLengths) {
        this.skeleton = skeleton;
        for (Bone bone : skeleton.getRoots()) {
            this.countConnections(bone);
        }
        this.setMode(Mesh.Mode.Points);
        this.boneLengths = boneLengths;
        VertexBuffer pb = new VertexBuffer(VertexBuffer.Type.Position);
        FloatBuffer fpb = BufferUtils.createFloatBuffer(10 * this.connectionsAmount * 3);
        pb.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, fpb);
        this.setBuffer(pb);
        this.updateCounts();
    }

    public void updateGeometry() {
        VertexBuffer vb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer posBuf = this.getFloatBuffer(VertexBuffer.Type.Position);
        posBuf.clear();
        for (int i = 0; i < this.skeleton.getBoneCount(); ++i) {
            Bone bone = this.skeleton.getBone(i);
            Vector3f parentTail = bone.getModelSpacePosition().add(bone.getModelSpaceRotation().mult(Vector3f.UNIT_Y.mult(this.boneLengths.get(i).floatValue())));
            for (Bone child : bone.getChildren()) {
                Vector3f childHead = child.getModelSpacePosition();
                Vector3f v = childHead.subtract(parentTail);
                float pointDelta = v.length() / 10.0f;
                v.normalizeLocal().multLocal(pointDelta);
                Vector3f pointPosition = parentTail.clone();
                for (int j = 0; j < 10; ++j) {
                    posBuf.put(pointPosition.getX()).put(pointPosition.getY()).put(pointPosition.getZ());
                    pointPosition.addLocal(v);
                }
            }
        }
        posBuf.flip();
        vb.updateData(posBuf);
        this.updateBound();
    }

    private void countConnections(Bone bone) {
        for (Bone child : bone.getChildren()) {
            ++this.connectionsAmount;
            this.countConnections(child);
        }
    }
}

