/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.environment.generation.JobProgressListener;
import com.jme3.environment.util.EnvMapUtils;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.texture.TextureCubeMap;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import com.jme3.util.MipMapGenerator;
import com.jme3.util.NativeObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class EnvironmentCamera
extends BaseAppState {
    protected static Vector3f[] axisX = new Vector3f[6];
    protected static Vector3f[] axisY = new Vector3f[6];
    protected static Vector3f[] axisZ = new Vector3f[6];
    protected Image.Format imageFormat = Image.Format.RGB16F;
    public TextureCubeMap debugEnv;
    protected Image[] images;
    protected ViewPort[] viewports;
    protected FrameBuffer[] framebuffers;
    protected ByteBuffer[] buffers;
    protected Vector3f position = new Vector3f();
    protected ColorRGBA backGroundColor;
    protected int size = 256;
    private final List<SnapshotJob> jobs = new ArrayList<SnapshotJob>();

    public EnvironmentCamera() {
    }

    public EnvironmentCamera(int size) {
        this.size = size;
    }

    public EnvironmentCamera(int size, Vector3f position) {
        this.size = size;
        this.position.set(position);
    }

    public EnvironmentCamera(int size, Vector3f position, Image.Format imageFormat) {
        this.size = size;
        this.position.set(position);
        this.imageFormat = imageFormat;
    }

    public void snapshot(final Spatial scene, final JobProgressListener<TextureCubeMap> done) {
        this.getApplication().enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SnapshotJob job = new SnapshotJob(done, scene);
                EnvironmentCamera.this.jobs.add(job);
                return null;
            }
        });
    }

    @Override
    public void render(RenderManager renderManager) {
        TextureCubeMap map;
        if (this.jobs.isEmpty()) {
            return;
        }
        SnapshotJob job = this.jobs.get(0);
        for (int i = 0; i < 6; ++i) {
            this.viewports[i].clearScenes();
            this.viewports[i].attachScene(job.scene);
            renderManager.renderViewPort(this.viewports[i], 0.16f);
            this.buffers[i] = BufferUtils.createByteBuffer(this.size * this.size * this.imageFormat.getBitsPerPixel() / 8);
            renderManager.getRenderer().readFrameBufferWithFormat(this.framebuffers[i], this.buffers[i], this.imageFormat);
            this.images[i] = new Image(this.imageFormat, this.size, this.size, this.buffers[i], ColorSpace.Linear);
            MipMapGenerator.generateMipMaps(this.images[i]);
        }
        this.debugEnv = map = EnvMapUtils.makeCubeMap(this.images[0], this.images[1], this.images[2], this.images[3], this.images[4], this.images[5], this.imageFormat);
        job.callback.done(map);
        map.getImage().dispose();
        this.jobs.remove(0);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
        this.rebuild();
    }

    protected void rebuild() {
        if (!this.isInitialized()) {
            return;
        }
        this.cleanup(this.getApplication());
        this.initialize(this.getApplication());
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f position) {
        this.position.set(position);
        if (this.viewports == null) {
            return;
        }
        for (ViewPort viewPort : this.viewports) {
            viewPort.getCamera().setLocation(position);
        }
    }

    @Override
    protected void initialize(Application app) {
        this.backGroundColor = app.getViewPort().getBackgroundColor();
        Camera[] cameras = new Camera[6];
        Texture2D[] textures = new Texture2D[6];
        this.viewports = new ViewPort[6];
        this.framebuffers = new FrameBuffer[6];
        this.buffers = new ByteBuffer[6];
        this.images = new Image[6];
        for (int i = 0; i < 6; ++i) {
            cameras[i] = this.createOffCamera(this.size, this.position, axisX[i], axisY[i], axisZ[i]);
            this.viewports[i] = this.createOffViewPort("EnvView" + i, cameras[i]);
            this.framebuffers[i] = this.createOffScreenFrameBuffer(this.size, this.viewports[i]);
            textures[i] = new Texture2D(this.size, this.size, this.imageFormat);
            this.framebuffers[i].setColorTexture(textures[i]);
        }
    }

    @Override
    protected void cleanup(Application app) {
        this.backGroundColor = null;
        for (FrameBuffer frameBuffer : this.framebuffers) {
            frameBuffer.dispose();
        }
        for (NativeObject nativeObject : this.images) {
            if (nativeObject == null) continue;
            nativeObject.dispose();
        }
    }

    public Image.Format getImageFormat() {
        return this.imageFormat;
    }

    @Override
    protected void onEnable() {
    }

    @Override
    protected void onDisable() {
    }

    protected Camera createOffCamera(int mapSize, Vector3f worldPos, Vector3f axisX, Vector3f axisY, Vector3f axisZ) {
        Camera offCamera = new Camera(mapSize, mapSize);
        offCamera.setLocation(worldPos);
        offCamera.setAxes(axisX, axisY, axisZ);
        offCamera.setFrustumPerspective(90.0f, 1.0f, 1.0f, 1000.0f);
        offCamera.setLocation(this.position);
        return offCamera;
    }

    protected ViewPort createOffViewPort(String name, Camera offCamera) {
        ViewPort offView = new ViewPort(name, offCamera);
        offView.setClearFlags(true, true, true);
        offView.setBackgroundColor(this.backGroundColor);
        return offView;
    }

    protected FrameBuffer createOffScreenFrameBuffer(int mapSize, ViewPort offView) {
        FrameBuffer offBuffer = new FrameBuffer(mapSize, mapSize, 1);
        offBuffer.setDepthBuffer(Image.Format.Depth);
        offView.setOutputFrameBuffer(offBuffer);
        return offBuffer;
    }

    static {
        EnvironmentCamera.axisX[0] = Vector3f.UNIT_Z.mult(1.0f);
        EnvironmentCamera.axisY[0] = Vector3f.UNIT_Y.mult(-1.0f);
        EnvironmentCamera.axisZ[0] = Vector3f.UNIT_X.mult(1.0f);
        EnvironmentCamera.axisX[1] = Vector3f.UNIT_Z.mult(-1.0f);
        EnvironmentCamera.axisY[1] = Vector3f.UNIT_Y.mult(-1.0f);
        EnvironmentCamera.axisZ[1] = Vector3f.UNIT_X.mult(-1.0f);
        EnvironmentCamera.axisX[2] = Vector3f.UNIT_X.mult(-1.0f);
        EnvironmentCamera.axisY[2] = Vector3f.UNIT_Z.mult(1.0f);
        EnvironmentCamera.axisZ[2] = Vector3f.UNIT_Y.mult(1.0f);
        EnvironmentCamera.axisX[3] = Vector3f.UNIT_X.mult(-1.0f);
        EnvironmentCamera.axisY[3] = Vector3f.UNIT_Z.mult(-1.0f);
        EnvironmentCamera.axisZ[3] = Vector3f.UNIT_Y.mult(-1.0f);
        EnvironmentCamera.axisX[4] = Vector3f.UNIT_X.mult(-1.0f);
        EnvironmentCamera.axisY[4] = Vector3f.UNIT_Y.mult(-1.0f);
        EnvironmentCamera.axisZ[4] = Vector3f.UNIT_Z;
        EnvironmentCamera.axisX[5] = Vector3f.UNIT_X.mult(1.0f);
        EnvironmentCamera.axisY[5] = Vector3f.UNIT_Y.mult(-1.0f);
        EnvironmentCamera.axisZ[5] = Vector3f.UNIT_Z.mult(-1.0f);
    }

    protected class SnapshotJob {
        JobProgressListener<TextureCubeMap> callback;
        Spatial scene;

        public SnapshotJob(JobProgressListener callback, Spatial scene) {
            this.callback = callback;
            this.scene = scene;
        }
    }
}

