/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.threats;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;

public class AnalysisTableModel
extends DefaultTableModel {
    private List<String> columnNames = new ArrayList<String>();
    private List<Map<String, String>> data = new ArrayList<Map<String, String>>();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String col = this.columnNames.get(column);
        String val = this.data.get(row).get(col);
        if (column == 0) {
            return Integer.valueOf(val);
        }
        return val;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames != null ? this.columnNames.get(column) : "unknown";
    }

    @Override
    public int getColumnCount() {
        return this.columnNames != null ? this.columnNames.size() : 0;
    }

    @Override
    public int getRowCount() {
        return this.data != null ? this.data.size() : 0;
    }

    public void addColumn(String columnName) {
        if (columnName != null) {
            this.columnNames.add(columnName);
            this.fireTableStructureChanged();
        }
    }

    public void removeColumn(String columnName) {
        if (columnName != null) {
            this.columnNames.remove(columnName);
            this.fireTableStructureChanged();
        }
    }

    public void setData(List<Map<String, String>> data) {
        LinkedHashSet<String> kolone = new LinkedHashSet<String>();
        kolone.add("func.count");
        for (Map<String, String> row : data) {
            for (String k : row.keySet()) {
                kolone.add(k);
            }
        }
        this.columnNames = new ArrayList<String>(kolone);
        this.fireTableStructureChanged();
        this.data = data;
        this.fireTableDataChanged();
        this.pcs.firePropertyChange("ENABLE_ANALYSIS_TAB", false, true);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void resetData() {
        this.columnNames.clear();
        this.data.clear();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void resetDataKeepColumns() {
        this.data.clear();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void addPropertyChangeSupport(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeSupport(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

