/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;

public class RulesTableRenderer
implements TableCellRenderer {
    private JCheckBox checkbox = new JCheckBox();
    private JLabel label = new JLabel();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ParsingRuleDTOWrapper r = (ParsingRuleDTOWrapper)value;
        if (r != null) {
            switch (column) {
                case 0: {
                    this.drawingStaff(this.label, table, isSelected, hasFocus, row, column);
                    if (r.isDirty()) {
                        this.label.setText("<html><strong>" + r.getDescription() + "</strong></html>");
                    } else if (r.isForDelete()) {
                        this.label.setText("<html><strong><strike>" + r.getDescription() + "</strike></strong></html>");
                    } else {
                        this.label.setText(r.getDescription());
                    }
                    return this.label;
                }
                case 1: {
                    this.drawingStaff(this.checkbox, table, isSelected, hasFocus, row, column);
                    this.checkbox.setSelected(r.isContinueParsing() == null ? false : r.isContinueParsing());
                    if (!table.isEditing()) {
                        this.checkbox.setEnabled(false);
                    } else {
                        this.checkbox.setEnabled(true);
                    }
                    return this.checkbox;
                }
                case 2: {
                    this.drawingStaff(this.checkbox, table, isSelected, hasFocus, row, column);
                    this.checkbox.setSelected(r.isSilent() == null ? false : r.isSilent());
                    if (!table.isEditing()) {
                        this.checkbox.setEnabled(false);
                    } else {
                        this.checkbox.setEnabled(true);
                    }
                    return this.checkbox;
                }
            }
            return new JLabel("empty");
        }
        return new JLabel("empty");
    }

    private void drawingStaff(Component comp, JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
        if (comp instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)comp;
            cb.setOpaque(true);
            cb.setHorizontalAlignment(0);
            cb.setBorder(new EmptyBorder(0, 0, 0, 0));
            if (isSelected) {
                cb.setForeground(table.getSelectionForeground());
                cb.setBackground(table.getSelectionBackground());
            } else {
                cb.setForeground(table.getForeground());
                cb.setBackground(table.getBackground());
            }
            if (hasFocus) {
                if (table.isCellEditable(row, column)) {
                    cb.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    cb.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                cb.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
        } else {
            JLabel l = (JLabel)comp;
            l.setOpaque(true);
            l.setBorder(new EmptyBorder(0, 0, 0, 0));
            if (isSelected) {
                l.setForeground(table.getSelectionForeground());
                l.setBackground(table.getSelectionBackground());
            } else {
                l.setForeground(table.getForeground());
                l.setBackground(table.getBackground());
            }
            if (!hasFocus) {
                l.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
        }
    }
}

