/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptModelChanged;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.gui.module.visualization.VisualizationTopComponent;

public final class DynamicVisualizationMenuAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Menu,
LookupListener {
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private JMenu menu = new JMenu(NbBundle.getMessage(DynamicVisualizationMenuAction.class, (String)"CTL_DynamicVisualizationMenuAction"));
    private final Lookup.Result<ScriptModelChanged> scriptModelChanged;

    public DynamicVisualizationMenuAction() {
        this(Utilities.actionsGlobalContext());
    }

    public DynamicVisualizationMenuAction(Lookup lookup) {
        this.scriptModelChanged = lookup.lookupResult(ScriptModelChanged.class);
        this.scriptModelChanged.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.scriptModelChanged));
        this.updateMenu();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DynamicVisualizationMenuAction(lookup);
    }

    public JMenuItem getMenuPresenter() {
        return this.menu;
    }

    public void resultChanged(LookupEvent ev) {
        this.updateMenu();
    }

    private void updateMenu() {
        try {
            List configs = this.apiService.getScriptsByType(ScriptType.VISUALISATION_CONFIGURATION);
            Collections.sort(configs, new Comparator<Script>(){

                @Override
                public int compare(Script s1, Script s2) {
                    return s1.getName().toLowerCase().compareTo(s2.getName().toLowerCase());
                }
            });
            this.menu.removeAll();
            for (Script s : configs) {
                final String name = s.getName();
                this.menu.add(new AbstractAction(s.getName(), new ImageIcon(this.getClass().getResource("/eye.png"))){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VisualizationTopComponent tc = (VisualizationTopComponent)WindowManager.getDefault().findTopComponent("VisualizationTopComponent");
                        tc.setScriptName(name);
                        tc.setDisplayName(NbBundle.getMessage(DynamicVisualizationMenuAction.class, (String)"CTL_VisualizationTopComponent") + " - " + name);
                        if (!tc.isOpened()) {
                            tc.open();
                            tc.requestActive();
                        }
                    }
                });
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

