/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.animation.Bone;
import com.jme3.math.Transform;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.file.Structure;

public class ConstraintDefinitionMaintainVolume
extends ConstraintDefinition {
    private static final int FLAG_MASK_X = 0;
    private static final int FLAG_MASK_Y = 1;
    private static final int FLAG_MASK_Z = 2;
    private float volume;

    public ConstraintDefinitionMaintainVolume(Structure constraintData, Long ownerOMA, BlenderContext blenderContext) {
        super(constraintData, ownerOMA, blenderContext);
        this.volume = (float)Math.sqrt(((Number)constraintData.getFieldValue("volume")).floatValue());
        this.trackToBeChanged = this.volume != 1.0f && (this.flag & 3) != 0;
    }

    @Override
    public void bake(ConstraintHelper.Space ownerSpace, ConstraintHelper.Space targetSpace, Transform targetTransform, float influence) {
        if (this.trackToBeChanged && influence > 0.0f && this.getOwner() instanceof Bone) {
            Transform ownerTransform = this.getOwnerTransform(ownerSpace);
            switch (this.flag) {
                case 0: {
                    ownerTransform.getScale().multLocal(1.0f, this.volume, this.volume);
                    break;
                }
                case 1: {
                    ownerTransform.getScale().multLocal(this.volume, 1.0f, this.volume);
                    break;
                }
                case 2: {
                    ownerTransform.getScale().multLocal(this.volume, this.volume, 1.0f);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown flag value: " + this.flag);
                }
            }
            this.applyOwnerTransform(ownerTransform, ownerSpace);
        }
    }

    @Override
    public String getConstraintTypeName() {
        return "Maintain volume";
    }

    @Override
    public boolean isTargetRequired() {
        return false;
    }
}

