/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.bounding.Intersection;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import java.io.IOException;

public class PointLight
extends Light {
    protected Vector3f position = new Vector3f();
    protected float radius = 0.0f;
    protected float invRadius = 0.0f;

    public PointLight() {
    }

    public PointLight(Vector3f position) {
        this.setPosition(position);
    }

    public PointLight(Vector3f position, ColorRGBA color) {
        super(color);
        this.setPosition(position);
    }

    public PointLight(Vector3f position, ColorRGBA color, float radius) {
        this(position, color);
        this.setRadius(radius);
    }

    public PointLight(Vector3f position, float radius) {
        this(position);
        this.setRadius(radius);
    }

    @Override
    public void computeLastDistance(Spatial owner) {
        if (owner.getWorldBound() != null) {
            BoundingVolume bv = owner.getWorldBound();
            this.lastDistance = bv.distanceSquaredTo(this.position);
        } else {
            this.lastDistance = owner.getWorldTranslation().distanceSquared(this.position);
        }
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public final void setPosition(Vector3f position) {
        this.position.set(position);
    }

    public float getRadius() {
        return this.radius;
    }

    public final void setRadius(float radius) {
        if (radius < 0.0f) {
            throw new IllegalArgumentException("Light radius cannot be negative");
        }
        this.radius = radius;
        this.invRadius = radius != 0.0f ? 1.0f / radius : 0.0f;
    }

    public float getInvRadius() {
        return this.invRadius;
    }

    @Override
    public Light.Type getType() {
        return Light.Type.Point;
    }

    @Override
    public boolean intersectsBox(BoundingBox box, TempVars vars) {
        if (this.radius == 0.0f) {
            return true;
        }
        return Intersection.intersect(box, this.position, this.radius);
    }

    @Override
    public boolean intersectsSphere(BoundingSphere sphere, TempVars vars) {
        if (this.radius == 0.0f) {
            return true;
        }
        return Intersection.intersect(sphere, this.position, this.radius);
    }

    @Override
    public boolean intersectsFrustum(Camera camera, TempVars vars) {
        if (this.radius == 0.0f) {
            return true;
        }
        for (int i = 5; i >= 0; --i) {
            if (!(camera.getWorldPlane(i).pseudoDistance(this.position) <= -this.radius)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.position, "position", null);
        oc.write(this.radius, "radius", 0.0f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.position = (Vector3f)ic.readSavable("position", null);
        this.radius = ic.readFloat("radius", 0.0f);
        this.invRadius = this.radius != 0.0f ? 1.0f / this.radius : 0.0f;
    }

    @Override
    public PointLight clone() {
        PointLight p = (PointLight)super.clone();
        p.position = this.position.clone();
        return p;
    }
}

