/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.gui.module.datamaps.ExcelCellObject;
import rs.co.ast.aspen.gui.module.datamaps.ReportDataMapKey;

public class ExportHelper {
    private static final Logger LOGGER = Logger.getLogger(ExportHelper.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static List<String> getAllUniqueFields(List<ReportDataMapKey> data) {
        HashSet<String> keys = new HashSet<String>();
        ArrayList<String> fields = new ArrayList<String>();
        ReportDataMapKey get = data.get(0);
        ExportHelper.getMapKeysRecursion(ExportHelper.json2HashMap(get.getValue()), keys);
        fields.addAll(keys);
        return fields;
    }

    public static Map<String, Object> json2HashMap(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map map = (Map)mapper.readValue(json, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            return map;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_MAP;
        }
    }

    public static String hashMap2Json(List<ReportDataMapKey> dataMapKeys) {
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(dataMapKeys);
        }
        catch (JsonProcessingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return "";
        }
    }

    public static HSSFWorkbook makeExcelDocument(String mapName, List<ReportDataMapKey> data, List<String> fields) {
        InternalWorkbook workBook = InternalWorkbook.createWorkbook();
        HSSFWorkbook wb = HSSFWorkbook.create((InternalWorkbook)workBook);
        Map<String, List<ExcelCellObject>> map = ExportHelper.getValuesForFields(data, fields);
        int countFields = ExportHelper.countFields(map);
        if (countFields == 0) {
            return wb;
        }
        int page = 1;
        int rowCount = 0;
        int cellCount = 0;
        HSSFSheet sheet = wb.createSheet("page " + page);
        HSSFCellStyle style = wb.createCellStyle();
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIME.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFRow titleRow = sheet.createRow(rowCount++);
        HSSFCell cellKeyCol = titleRow.createCell(cellCount++);
        cellKeyCol.setCellValue("key");
        for (String key : map.keySet()) {
            int i;
            List<ExcelCellObject> val = map.get(key);
            countFields = val.size();
            HSSFRow row = null;
            for (i = 0; i < val.size(); i += countFields) {
                for (int j = i; j < countFields + i; ++j) {
                    if (j % fields.size() == 0 || row == null) {
                        row = sheet.createRow(rowCount++);
                        cellCount = 0;
                        HSSFCell cellKey = row.createCell(cellCount++);
                        cellKey.setCellValue(key);
                        LOGGER.log(Level.INFO, "KEY: {0}", key);
                    }
                    ExcelCellObject excelCellObj = val.get(j);
                    cellKeyCol = titleRow.createCell(cellCount);
                    cellKeyCol.setCellValue(excelCellObj.getKey());
                    LOGGER.log(Level.INFO, "TITLE: {0}", excelCellObj.getKey());
                    HSSFCell cellKey = row.createCell(cellCount++);
                    cellKey.setCellValue(excelCellObj.getValue());
                    LOGGER.log(Level.INFO, "VALUE: {0}", excelCellObj.getValue());
                }
                if (rowCount != 65536) continue;
                rowCount = 1;
                sheet = wb.createSheet("page " + ++page);
            }
            for (i = 0; i < countFields + 1; ++i) {
                sheet.autoSizeColumn(i);
            }
        }
        return wb;
    }

    public static HSSFWorkbook makeExcelMultiSheetDocument(String mapName, List<ReportDataMapKey> data, List<String> fields) {
        InternalWorkbook workBook = InternalWorkbook.createWorkbook();
        HSSFWorkbook wb = HSSFWorkbook.create((InternalWorkbook)workBook);
        Map<String, List<ExcelCellObject>> map = ExportHelper.getValuesForFields(data, fields);
        int countFields = ExportHelper.countFields(map);
        if (countFields == 0) {
            return wb;
        }
        for (String key : map.keySet()) {
            int i;
            LOGGER.log(Level.INFO, "KEY: {0}", key);
            List<ExcelCellObject> val = map.get(key);
            countFields = val.size();
            String sheetName = key.replace("[", "").replace("]", "").replace("\\", "").replace("/", "").replace("?", "").replace("'", "");
            if (sheetName.length() >= 31) {
                sheetName = sheetName.substring(0, 31);
            }
            if (workBook.doesContainsSheetName(sheetName, -1)) {
                sheetName = UUID.randomUUID().toString();
            }
            LOGGER.log(Level.INFO, "SHEET: {0}", sheetName);
            HSSFSheet sheet = wb.createSheet(sheetName);
            HSSFCellStyle style = wb.createCellStyle();
            style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIME.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            HSSFRow titleRow = sheet.createRow(0);
            HSSFRow row = null;
            int rowCount = 1;
            for (i = 0; i < val.size(); i += countFields) {
                int cellCount = 0;
                for (int j = i; j < countFields + i; ++j) {
                    if (j % fields.size() == 0 || row == null) {
                        row = sheet.createRow(rowCount++);
                        cellCount = 0;
                        HSSFCell cellKey = row.createCell(cellCount++);
                        cellKey.setCellValue(key);
                        LOGGER.log(Level.INFO, "KEY: {0}", key);
                    }
                    ExcelCellObject excelCellObj = val.get(j);
                    HSSFCell cellKeyCol = titleRow.createCell(cellCount);
                    cellKeyCol.setCellValue(excelCellObj.getKey());
                    LOGGER.log(Level.INFO, "TITLE: {0}", excelCellObj.getKey());
                    HSSFCell cellKey = row.createCell(cellCount++);
                    cellKey.setCellValue(excelCellObj.getValue());
                    LOGGER.log(Level.INFO, "VALUE: {0}", excelCellObj.getValue());
                }
            }
            for (i = 0; i < countFields; ++i) {
                sheet.autoSizeColumn(i);
            }
        }
        return wb;
    }

    public static StringBuffer makeCsvDocument(String mapName, List<ReportDataMapKey> data, List<String> fields, String separator) {
        StringBuffer sb = new StringBuffer();
        Map<String, List<ExcelCellObject>> map = ExportHelper.getValuesForFields(data, fields);
        int countFields = ExportHelper.countFields(map);
        if (countFields == 0) {
            return sb;
        }
        ArrayList<String> orderedFields = new ArrayList<String>();
        sb.append("key").append(separator);
        Iterator<String> iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            String key = iterator.next();
            List<ExcelCellObject> excelObj = map.get(key);
            for (ExcelCellObject exc : excelObj) {
                if (!fields.contains(exc.getKey())) continue;
                if (orderedFields.size() == fields.size()) break;
                if (orderedFields.contains(exc.getKey())) continue;
                orderedFields.add(exc.getKey());
                sb.append(exc.getKey());
                sb.append(separator);
            }
        }
        sb.append(System.getProperty("line.separator"));
        for (String key : map.keySet()) {
            List<ExcelCellObject> val = map.get(key);
            for (int i = 0; i < val.size(); i += countFields) {
                sb.append(key);
                sb.append(separator);
                int coundFiledsAndi = countFields + i;
                for (int j = i; j < countFields + i; ++j) {
                    ExcelCellObject excelCellObj = val.get(j);
                    sb.append(excelCellObj.getValue());
                    sb.append(separator);
                }
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb;
    }

    private static int countFields(Map<String, List<ExcelCellObject>> map) {
        int max = 0;
        String theKey = "";
        for (String key : map.keySet()) {
            List<ExcelCellObject> get = map.get(key);
            if (get.size() <= max) continue;
            max = get.size();
            theKey = key;
        }
        List<ExcelCellObject> val = map.get(theKey);
        if (val != null && !val.isEmpty()) {
            ExcelCellObject ref = val.get(0);
            for (int i = 1; i < val.size(); ++i) {
                if (!ref.getKey().equals(val.get(i).getKey())) continue;
                return i;
            }
        }
        return max;
    }

    private static Map<String, List<ExcelCellObject>> getValuesForFields(List<ReportDataMapKey> data, List<String> fields) {
        HashMap<String, List<ExcelCellObject>> mapRows = new HashMap<String, List<ExcelCellObject>>();
        for (ReportDataMapKey key : data) {
            Map<String, Object> map = ExportHelper.json2HashMap(key.getValue());
            ArrayList<ExcelCellObject> list = new ArrayList<ExcelCellObject>();
            ExportHelper.mapRecursion(map, fields, list);
            mapRows.put(key.getKey(), list);
        }
        return mapRows;
    }

    private static void mapRecursion(Map<String, Object> map, List<String> fields, List<ExcelCellObject> list) {
        try {
            for (String key : map.keySet()) {
                Object obj = map.get(key);
                if (fields.contains(key)) {
                    String val;
                    if (obj instanceof Map) {
                        ObjectMapper mapper = new ObjectMapper();
                        val = mapper.writeValueAsString(obj);
                        ExportHelper.mapRecursion((Map)obj, fields, list);
                    } else {
                        val = obj instanceof String ? (String)obj : (obj instanceof Integer ? ((Integer)obj).toString() : obj.toString());
                    }
                    ExcelCellObject ero = new ExcelCellObject(key, val);
                    list.add(ero);
                    continue;
                }
                if (!(obj instanceof Map)) continue;
                ExportHelper.mapRecursion((Map)obj, fields, list);
            }
        }
        catch (JsonProcessingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void getMapKeysRecursion(Map<String, Object> map, Set<String> keys) {
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            if (obj instanceof Map) {
                ExportHelper.getMapKeysRecursion((Map)obj, keys);
                continue;
            }
            keys.add(key);
        }
    }
}

