/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.core.multitabs.TabDecorator;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.core.windows.view.ui.tabcontrol.Utilities;
import org.netbeans.swing.tabcontrol.TabData;
import org.openide.awt.CloseButtonFactory;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class TabDataRenderer
implements TableCellRenderer {
    private final RendererPanel renderer = new RendererPanel();
    private final List<TabDecorator> decorators = TabDataRenderer.getDecorators();
    private static final boolean SHOW_CLOSE_BUTTON = !Boolean.getBoolean("nb.tabs.suppressCloseButton");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.renderer.clear();
        Rectangle rect = table.getCellRect(row, column, true);
        this.renderer.setSize(rect.width, rect.height);
        if (value instanceof TabData) {
            TabData tab = (TabData)value;
            String text = tab.getText();
            Icon icon = tab.getIcon();
            Color colBackground = isSelected ? table.getSelectionBackground() : table.getBackground();
            Color colForeground = isSelected ? table.getSelectionForeground() : table.getForeground();
            for (TabDecorator td : this.decorators) {
                Icon i;
                String s;
                Color c = td.getBackground(tab, isSelected);
                if (null != c) {
                    colBackground = c;
                }
                if (null != (c = td.getForeground(tab, isSelected))) {
                    colForeground = c;
                }
                if (null != (s = td.getText(tab))) {
                    text = s;
                }
                if (null == (i = td.getIcon(tab))) continue;
                icon = i;
            }
            this.renderer.label.setText(text);
            this.renderer.label.setIcon(icon);
            this.renderer.label.setFont(table.getFont());
            this.renderer.setBackground(colBackground);
            this.renderer.label.setForeground(colForeground);
            this.renderer.tabData = tab;
            this.renderer.isSelected = isSelected;
            if (table instanceof TabTable) {
                TabTable tabTable = (TabTable)table;
                if (TabDataRenderer.isClosable(tab)) {
                    boolean inCloseButton = tabTable.isCloseButtonHighlighted(row, column);
                    this.renderer.closeButton.setVisible(true);
                    this.renderer.closeButton.getModel().setRollover(inCloseButton);
                    this.renderer.closeButton.getModel().setArmed(inCloseButton);
                } else {
                    this.renderer.closeButton.setVisible(false);
                }
            }
        }
        return this.renderer;
    }

    boolean isInCloseButton(Rectangle cellRect, Point p) {
        return this.renderer.isInCloseButton(cellRect, p);
    }

    static boolean isClosable(TabData tab) {
        if (!SHOW_CLOSE_BUTTON) {
            return false;
        }
        if (!Utilities.isEditorTopComponentClosingEnabled()) {
            return false;
        }
        Component tc = tab.getComponent();
        if (tc instanceof TopComponent) {
            return !Boolean.TRUE.equals(((TopComponent)tc).getClientProperty((Object)"netbeans.winsys.tc.closing_disabled"));
        }
        return true;
    }

    int getPreferredWidth(Object value) {
        int res = -1;
        this.renderer.clear();
        if (value instanceof TabData) {
            TabData tab = (TabData)value;
            String text = tab.getText();
            Icon icon = tab.getIcon();
            for (TabDecorator td : this.decorators) {
                Icon i;
                String s = td.getText(tab);
                if (null != s) {
                    text = s;
                }
                if (null == (i = td.getIcon(tab))) continue;
                icon = i;
            }
            this.renderer.label.setText(text);
            this.renderer.label.setIcon(icon);
            this.renderer.tabData = tab;
            res = this.renderer.getPreferredSize().width;
        }
        return res;
    }

    static int getPreferredTableRowHeight() {
        JLabel lbl = new JLabel("ABC");
        return 4 + Math.max(16, lbl.getPreferredSize().height);
    }

    private static List<TabDecorator> getDecorators() {
        return new ArrayList<TabDecorator>(Lookup.getDefault().lookupAll(TabDecorator.class));
    }

    private class RendererPanel
    extends JPanel {
        private final JLabel label;
        private final JButton closeButton;
        private TabData tabData;
        private boolean isSelected;

        public RendererPanel() {
            super(new BorderLayout(0, 0));
            this.label = new JLabel();
            this.label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 3));
            this.add((Component)this.label, "Center");
            this.closeButton = CloseButtonFactory.createCloseButton();
            this.add((Component)this.closeButton, "East");
        }

        void clear() {
            this.label.setText(null);
            this.label.setIcon(null);
            this.setOpaque(true);
            this.tabData = null;
            this.isSelected = false;
            this.closeButton.getModel().setArmed(false);
            this.closeButton.getModel().setRollover(false);
            this.closeButton.setVisible(true);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Rectangle rect = this.getBounds();
            rect.x = 0;
            rect.y = 0;
            for (TabDecorator td : TabDataRenderer.this.decorators) {
                td.paintAfter(this.tabData, g, rect, this.isSelected);
            }
        }

        private boolean isInCloseButton(Rectangle cellRect, Point p) {
            if (cellRect.contains(p) && this.closeButton.isVisible()) {
                Dimension size = this.closeButton.getPreferredSize();
                Rectangle closeButtonRect = new Rectangle(size);
                closeButtonRect.x = cellRect.x + cellRect.width - closeButtonRect.width - 3;
                closeButtonRect.x = cellRect.x + cellRect.width - closeButtonRect.width - 3;
                closeButtonRect.y = cellRect.y + (cellRect.height - closeButtonRect.height) / 2;
                return closeButtonRect.contains(p);
            }
            return false;
        }
    }
}

