/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.core.module.visengine.VisualizationException;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.visualization.properties.Producer;
import rs.co.ast.aspen.gui.module.visualization.properties.ProducerSupplier;

public class RealtimeProducer
extends Producer {
    private static final Logger LOGGER = Logger.getLogger(RealtimeProducer.class.getName());
    private long totalHits = 0L;
    private final ProducerSupplier producerSupplier;

    public RealtimeProducer(BlockingQueue<List<Node>> queue) {
        super("RealtimeProducer", queue);
        this.page = 50;
        this.generateDateAndTimes();
        this.generateQuery();
        this.producerSupplier = new ProducerSupplier(this.query, this.from, this.to, this.page, this.searchState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.producerSupplier.start();
            this.activeList = new ArrayList();
            while (!this.isInterrupted()) {
                Thread.sleep(500L);
                List<SecurityEvent> results = this.producerSupplier.getEvents();
                this.activeList.addAll(results);
                this.totalHits += (long)results.size();
                this.visPropTC.updateEventsDrawnLabel(String.format("%,8d%n / %,8d%n", this.count, this.totalHits));
                if (this.activeList.isEmpty()) {
                    this.updateStatusSleepSearching();
                } else if (!this.idle) {
                    this.updateStatusRunning();
                }
                while (!(this.activeList.isEmpty() || this.idle && this.goToNextStep <= 0 || this.isInterrupted())) {
                    this.indexTo = this.indexFrom + this.eventsPerStep;
                    this.indexTo = this.indexTo > this.activeList.size() ? this.activeList.size() : this.indexTo;
                    LOGGER.info(String.format("activeList size: %d, indexFrom: %d, indexTo: %d", this.activeList.size(), this.indexFrom, this.indexTo));
                    List subList = this.activeList.subList(this.indexFrom, this.indexTo);
                    this.visManager.getConfig().getVisEngine().process(subList);
                    if (this.goToNextStep <= 0) {
                        this.sleepThread(this.stepDelay);
                    }
                    List<Node> allNodesList = this.allNodesList();
                    this.queue.put(allNodesList);
                    this.activeList.removeAll(subList);
                    this.count += (long)this.eventsPerStep;
                    this.count = this.count > this.totalHits ? this.totalHits : this.count;
                    this.visPropTC.updateEventsDrawnLabel(String.format("%,8d%n / %,8d%n", this.count, this.totalHits));
                    if (this.goToNextStep > 0) {
                        this.goToNextStep = this.goToNextStep - 1;
                    }
                    if (this.count % (long)this.page != 0L) continue;
                    this.sleep();
                    Thread.sleep(500L);
                    this.visManager.reset();
                    Thread.sleep(500L);
                    this.wake();
                    break;
                }
                this.indexFrom = 0;
                this.indexTo = 0;
            }
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, "RealtimeProducer thread interrupted", ex);
        }
        catch (MissingResourceException | ExecutionException | VisualizationException ex) {
            LOGGER.log(Level.SEVERE, "RealtimeProducer thread error", ex);
            this.mode = Producer.Mode.ERROR;
        }
        finally {
            LOGGER.info("Producer finished.");
            if (this.ph != null) {
                this.ph.finish();
            }
            this.executorService.shutdownNow();
            this.producerSupplier.interrupt();
            this.interrupt();
        }
    }

    private void generateDateAndTimes() {
        long now = System.currentTimeMillis();
        this.from = now - 300000L;
        this.to = now;
    }

    @Override
    protected List<SecurityEvent> search(String query, long from, long to) throws ApiServiceException_Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

