/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.script.ScriptException;
import rs.co.ast.aspen.core.module.visengine.graph.Template;
import rs.co.ast.aspen.core.module.visengine.scripting.ExpressionEvaluator;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.ColorString;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.RendererProperties;
import rs.co.ast.aspen.gui.module.vis.threed.phys.FieldMatrix;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsBody;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsConstants;

public class VisualizationConfiguration {
    public String DIMENSIONALITY = "2D";
    public int FIELD_MATRIX_DIFFERENT_SIGN = -1;
    public int FIELD_MATRIX_SAME_SIGN = -1;
    public int NUMBER_OF_EVENTS = 1000;
    public String QUERY = "";
    public String RULESET = "";
    public long SLEEP_TIME = 300L;
    private final Map<String, Template> configurationPropertiesTemplate = new HashMap<String, Template>();

    public static VisualizationConfiguration configFromJson(String ruleset) throws ScriptException {
        ExpressionEvaluator e = new ExpressionEvaluator(null);
        Map map = (Map)e.eval(ruleset, null, null);
        return VisualizationConfiguration.fromMap(map);
    }

    private static VisualizationConfiguration fromMap(Map map) {
        VisualizationConfiguration vc = new VisualizationConfiguration();
        Map props = (Map)map.get("VisualizationConfiguration");
        if (props != null) {
            for (Object prop : props.values()) {
                Map t = (Map)prop;
                vc.addConfigurationProperties((String)t.get("config"), Template.fromMap((Map)((Map)t.get("parameters"))));
            }
        }
        return vc;
    }

    public void addConfigurationProperties(String name, Template tmpl) {
        this.configurationPropertiesTemplate.put(name, tmpl);
    }

    public FieldMatrix getFieldMatrix() {
        Template extraSettings = this.configurationPropertiesTemplate.getOrDefault("ExtraSettings", null);
        if (extraSettings != null) {
            Iterator iterator = extraSettings.attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String tmp;
                switch (tmp = (String)iterator.next()) {
                    case "FIELD_MATRIX_SAME_SIGN": {
                        this.FIELD_MATRIX_SAME_SIGN = Integer.parseInt((String)extraSettings.attributes.get(tmp));
                        break;
                    }
                    case "FIELD_MATRIX_DIFFERENT_SIGN": {
                        this.FIELD_MATRIX_DIFFERENT_SIGN = Integer.parseInt((String)extraSettings.attributes.get(tmp));
                        break;
                    }
                    case "QUERY": {
                        this.QUERY = (String)extraSettings.attributes.get(tmp);
                        break;
                    }
                    case "DIMENSIONALITY": {
                        this.DIMENSIONALITY = (String)extraSettings.attributes.get(tmp);
                        break;
                    }
                    case "SLEEP_TIME": {
                        this.SLEEP_TIME = Integer.parseInt((String)extraSettings.attributes.get(tmp));
                        break;
                    }
                    case "NUMBER_OF_EVENTS": {
                        this.NUMBER_OF_EVENTS = Integer.parseInt((String)extraSettings.attributes.get(tmp));
                        break;
                    }
                    case "RULESET": {
                        this.RULESET = (String)extraSettings.attributes.get(tmp);
                    }
                }
            }
        }
        FieldMatrix fm = new FieldMatrix(this.FIELD_MATRIX_SAME_SIGN, this.FIELD_MATRIX_DIFFERENT_SIGN);
        return fm;
    }

    public PhysicsConstants getPhysicsConstants() {
        PhysicsConstants pc = new PhysicsConstants();
        Template physicsConstants = this.configurationPropertiesTemplate.getOrDefault("PhysicsConstants", null);
        if (physicsConstants != null) {
            Iterator iterator = physicsConstants.attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String tmp;
                switch (tmp = (String)iterator.next()) {
                    case "DEFAULT_CHARGE": {
                        pc.DEFAULT_CHARGE = PhysicsBody.Charge.valueOf((String)((String)physicsConstants.attributes.get(tmp)));
                        break;
                    }
                    case "DEFAULT_Ke": {
                        pc.DEFAULT_Ke = Float.parseFloat((String)physicsConstants.attributes.get(tmp));
                        break;
                    }
                    case "DEFAULT_MASS": {
                        pc.DEFAULT_MASS = Float.parseFloat((String)physicsConstants.attributes.get(tmp));
                        break;
                    }
                    case "DEFAULT_RADIUS": {
                        pc.DEFAULT_RADIUS = Float.parseFloat((String)physicsConstants.attributes.get(tmp));
                        break;
                    }
                    case "DEFAULT_SPRING_LEN": {
                        pc.DEFAULT_SPRING_LEN = Float.parseFloat((String)physicsConstants.attributes.get(tmp));
                        break;
                    }
                    case "FIELD_DAMPING": {
                        pc.FIELD_DAMPING = Float.parseFloat((String)physicsConstants.attributes.get(tmp));
                        break;
                    }
                    case "Kf": {
                        pc.Kf = Float.parseFloat((String)physicsConstants.attributes.get(tmp));
                        break;
                    }
                    case "MAX_SPEED": {
                        pc.MAX_SPEED = Float.parseFloat((String)physicsConstants.attributes.get(tmp));
                        break;
                    }
                    case "SPRING_DAMPING": {
                        pc.SPRING_DAMPING = Float.parseFloat((String)physicsConstants.attributes.get(tmp));
                        break;
                    }
                    case "VELOCITY_DAMPING": {
                        pc.VELOCITY_DAMPING = Float.parseFloat((String)physicsConstants.attributes.get(tmp));
                    }
                }
            }
        }
        return pc;
    }

    public RendererProperties getRendererProperties() {
        RendererProperties rp = new RendererProperties();
        Template rendererProperties = this.configurationPropertiesTemplate.getOrDefault("RendererProperties", null);
        if (rendererProperties != null) {
            Iterator iterator = rendererProperties.attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String tmp;
                switch (tmp = (String)iterator.next()) {
                    case "CAM2D_PAN_SPEED": {
                        rp.CAM2D_PAN_SPEED = Float.parseFloat((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "CAM2D_ZOOM_SPEED": {
                        rp.CAM2D_ZOOM_SPEED = Float.parseFloat((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "CAM3D_MOVE_SPEED": {
                        rp.CAM3D_MOVE_SPEED = Float.parseFloat((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "CAM3D_ROTATION_SPEED": {
                        rp.CAM3D_ROTATION_SPEED = Float.parseFloat((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "FRAMES_RAMP_UP": {
                        rp.FRAMES_RAMP_UP = Integer.parseInt((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "INITIAL_CAMERA_DISTANCE": {
                        rp.INITIAL_CAMERA_DISTANCE = Float.parseFloat((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "LIGHTING": {
                        rp.LIGHTING = Boolean.parseBoolean((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "MAX_LABEL_DRAW_DISTANCE": {
                        rp.MAX_LABEL_DRAW_DISTANCE = Float.parseFloat((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "MAX_TPF": {
                        rp.MAX_TPF = Float.parseFloat((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "SECTOR_SIZE": {
                        rp.SECTOR_SIZE = Float.parseFloat((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "SKYBOX_FILENAME": {
                        rp.SKYBOX_FILENAME = (String)rendererProperties.attributes.get(tmp);
                        break;
                    }
                    case "VIEW_FRUSTUM_FAR_PLANE": {
                        rp.VIEW_FRUSTUM_FAR_PLANE = Float.parseFloat((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "AMBIENT_LIGHT_COLOR": {
                        rp.AMBIENT_LIGHT_COLOR = ColorString.colorFromString((String)((String)rendererProperties.attributes.get(tmp)));
                        break;
                    }
                    case "AMBIENT_LIGHT_INTENSITY": {
                        rp.AMBIENT_LIGHT_INTENSITY = Float.parseFloat((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "LABEL_COLOR": {
                        rp.LABEL_COLOR = ColorString.colorFromString((String)((String)rendererProperties.attributes.get(tmp)));
                        break;
                    }
                    case "DIRECTIONAL_LIGHT_COLOR": {
                        rp.DIRECTIONAL_LIGHT_COLOR = ColorString.colorFromString((String)((String)rendererProperties.attributes.get(tmp)));
                        break;
                    }
                    case "FIXED_NODE_ORIENTATION": {
                        rp.FIXED_NODE_ORIENTATION = Boolean.parseBoolean((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "SHOW_LABELS_ON_MOUSE_OVER": {
                        rp.SHOW_LABELS_ON_MOUSE_OVER = Boolean.parseBoolean((String)rendererProperties.attributes.get(tmp));
                        break;
                    }
                    case "BACKGROUND_COLOR": {
                        rp.BACKGROUND_COLOR = ColorString.colorFromString((String)((String)rendererProperties.attributes.get(tmp)));
                    }
                }
            }
        }
        return rp;
    }
}

