/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.HostStatsAggObject;

public class SumOfCountsPerHostnameTableModel
extends DefaultTableModel {
    private final List<String> columns = Stream.of(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.host"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.domains"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.fqdns"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.numberOfEvents"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.firstActive"), NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"SumOfCountsPerHostnameTableModel.columnName.lastActive")).collect(Collectors.toList());
    private List<HostStatsAggObject> data = new ArrayList<HostStatsAggObject>();
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());

    @Override
    public Object getValueAt(int row, int column) {
        HostStatsAggObject element = this.data.get(row);
        switch (column) {
            case 0: {
                return element.getHost();
            }
            case 1: {
                return element.getDomains().stream().collect(Collectors.joining(";"));
            }
            case 2: {
                return element.getFqdns().stream().collect(Collectors.joining(";"));
            }
            case 3: {
                return this.nf.format(element.getSum());
            }
            case 4: {
                return element.getHumanFirstActive();
            }
            case 5: {
                return element.getHumanLastActive();
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(SumOfCountsPerHostnameTableModel.class, (String)"TableModel.columnName.unknown"));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public void update(List<HostStatsAggObject> data) {
        this.data = data;
        this.fireTableDataChanged();
    }
}

