/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;
import org.jdesktop.swingx.painter.BusyPainter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.HostStatsCsvReport;
import rs.co.ast.aspen.api.service.HostStatsGuiReport;
import rs.co.ast.aspen.gui.module.datamaps.TableTransferHandler;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.HostsPerDomainTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.OverviewTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableTooltipHeader;

@TopComponent.Description(preferredID="SourceStatisticsTopComponent", iconBase="assetts-statistic.png", persistenceType=0)
public final class SourceStatisticsTopComponent
extends TopComponent {
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private final SumOfCountsPerHostnameTableModel sumOfCountsPerHostnameTableModel = new SumOfCountsPerHostnameTableModel();
    private final HostsPerDomainTableModel hostsPerDomainTablemodel = new HostsPerDomainTableModel();
    private final OverviewTableModel overviewTableModel = new OverviewTableModel();
    private final DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
    private final KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                SourceStatisticsTopComponent.this.startSearch();
            }
        }
    };
    private JButton bExport;
    private JButton bRefresh;
    private JXDatePicker dtpTimeFinish;
    private JXDatePicker dtpTimeStart;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lDelimeter;
    private JLabel lFinish;
    private JXBusyLabel lLoading;
    private JLabel lQueryDomain;
    private JLabel lQueryHostname;
    private JLabel lStart;
    private JTable tCountOfHostNamesPerDomain;
    private JTable tOverview;
    private JTable tSumOfCountsPerHostname;
    private JTabbedPane tbPanel;
    private JTextField tfDelimeter;
    private JTextField tfQueryDomain;
    private JTextField tfQueryHostname;

    public SourceStatisticsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"CTL_SourceStatisticsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"HINT_SourceStatisticsTopComponent"));
        this.dtpTimeStart.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeStart.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeFinish.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeFinish.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeStart.setTimeZone(TimeZone.getDefault());
        this.dtpTimeFinish.setTimeZone(TimeZone.getDefault());
        long now = System.currentTimeMillis();
        this.dtpTimeStart.setDate(new DateTime(now - 604800000L).withTimeAtStartOfDay().toDate());
        this.dtpTimeFinish.setDate(new DateTime(now).withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).withMillisOfSecond(0).toDate());
        this.tSumOfCountsPerHostname.setModel(this.sumOfCountsPerHostnameTableModel);
        this.tSumOfCountsPerHostname.setTransferHandler(new TableTransferHandler());
        this.tSumOfCountsPerHostname.setAutoCreateRowSorter(true);
        SumOfCountsPerHostnameTableTooltipHeader sumOfCountsPerHostnameToolTipHeader = new SumOfCountsPerHostnameTableTooltipHeader(this.tSumOfCountsPerHostname.getColumnModel());
        this.tSumOfCountsPerHostname.setTableHeader(sumOfCountsPerHostnameToolTipHeader);
        this.tCountOfHostNamesPerDomain.setModel(this.hostsPerDomainTablemodel);
        this.tCountOfHostNamesPerDomain.setTransferHandler(new TableTransferHandler());
        this.tCountOfHostNamesPerDomain.setAutoCreateRowSorter(true);
        this.tOverview.setModel(this.overviewTableModel);
        this.tOverview.setTransferHandler(new TableTransferHandler());
        this.tOverview.setAutoCreateRowSorter(true);
        this.tfQueryDomain.addKeyListener(this.keyAdapter);
        this.tfQueryHostname.addKeyListener(this.keyAdapter);
        this.tbPanel.setForegroundAt(1, new Color(51, 153, 255));
        this.tbPanel.setForegroundAt(2, new Color(173, 51, 255));
    }

    public long getStartTime() {
        return this.dtpTimeStart.getDate().getTime();
    }

    public long getFinishTime() {
        return this.dtpTimeFinish.getDate().getTime();
    }

    public String getQueryDomain() {
        return this.tfQueryDomain.getText();
    }

    public String getQueryHostname() {
        return this.tfQueryHostname.getText();
    }

    public String getDelimeter() {
        return this.tfDelimeter.getText();
    }

    private void toggleLoading() {
        this.lLoading.setBusy(!this.lLoading.isBusy());
    }

    private String genFileName() {
        DateTime now = new DateTime();
        String ext = "csv";
        return String.format("%s_%s.%s", "SourceStatistics", now.toString(this.dtf), ext);
    }

    private void initComponents() {
        this.lQueryHostname = new JLabel();
        this.tfQueryHostname = new JTextField();
        this.lStart = new JLabel();
        this.dtpTimeStart = new JXDatePicker();
        this.lFinish = new JLabel();
        this.dtpTimeFinish = new JXDatePicker();
        this.lDelimeter = new JLabel();
        this.tfDelimeter = new JTextField();
        this.bExport = new JButton();
        this.lQueryDomain = new JLabel();
        this.tfQueryDomain = new JTextField();
        this.tbPanel = new JTabbedPane();
        this.jScrollPane3 = new JScrollPane();
        this.tOverview = new JTable();
        this.jScrollPane1 = new JScrollPane();
        this.tCountOfHostNamesPerDomain = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.tSumOfCountsPerHostname = new JTable();
        this.lLoading = new JXBusyLabel();
        this.bRefresh = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.lQueryHostname, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lQueryHostname.text"));
        this.tfQueryHostname.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryHostname.text"));
        this.tfQueryHostname.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryHostname.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.lStart, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lStart.text"));
        Mnemonics.setLocalizedText((JLabel)this.lFinish, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lFinish.text"));
        Mnemonics.setLocalizedText((JLabel)this.lDelimeter, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lDelimeter.text"));
        this.tfDelimeter.setHorizontalAlignment(0);
        this.tfDelimeter.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfDelimeter.text"));
        this.tfDelimeter.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfDelimeter.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatisticsTopComponent.this.bExportActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lQueryDomain, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lQueryDomain.text"));
        this.tfQueryDomain.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryDomain.text"));
        this.tfQueryDomain.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryDomain.toolTipText"));
        this.tOverview.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tOverview.setCellSelectionEnabled(true);
        this.jScrollPane3.setViewportView(this.tOverview);
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jScrollPane3.TabConstraints.tabTitle"), this.jScrollPane3);
        this.tCountOfHostNamesPerDomain.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tCountOfHostNamesPerDomain.setColumnSelectionAllowed(true);
        this.jScrollPane1.setViewportView(this.tCountOfHostNamesPerDomain);
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jScrollPane1.TabConstraints.tabTitle"), this.jScrollPane1);
        this.tSumOfCountsPerHostname.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tSumOfCountsPerHostname.setColumnSelectionAllowed(true);
        this.jScrollPane2.setViewportView(this.tSumOfCountsPerHostname);
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jScrollPane2.TabConstraints.tabTitle"), this.jScrollPane2);
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lLoading.text"));
        this.lLoading.setDirection(BusyPainter.Direction.RIGHT);
        this.bRefresh.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bRefresh.text"));
        this.bRefresh.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bRefresh.toolTipText"));
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatisticsTopComponent.this.bRefreshActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tbPanel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lQueryHostname).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfQueryHostname, -2, 200, -2).addGap(24, 24, 24).addComponent(this.lStart)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lQueryDomain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfQueryDomain, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lFinish))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.dtpTimeStart, -2, -1, -2).addGap(18, 18, 18).addComponent(this.bRefresh).addGap(18, 18, 18).addComponent((Component)this.lLoading, -2, -1, -2)).addComponent((Component)this.dtpTimeFinish, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 505, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lDelimeter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfDelimeter, -2, 33, -2)).addComponent(this.bExport, GroupLayout.Alignment.TRAILING)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.lLoading, -2, 27, -2).addComponent(this.bRefresh))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfQueryHostname, -2, -1, -2).addComponent(this.lQueryHostname).addComponent(this.lStart).addComponent((Component)this.dtpTimeStart, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfDelimeter, -2, 25, -2).addComponent(this.lDelimeter)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dtpTimeFinish, -2, -1, -2).addComponent(this.lFinish).addComponent(this.tfQueryDomain, -2, -1, -2).addComponent(this.lQueryDomain)).addComponent(this.bExport)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbPanel, -1, 523, Short.MAX_VALUE).addContainerGap()));
    }

    private void bExportActionPerformed(ActionEvent evt) {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsPanel.export_progress.title"));
        SwingWorker<HostStatsCsvReport, Void> worker = new SwingWorker<HostStatsCsvReport, Void>(){

            @Override
            protected HostStatsCsvReport doInBackground() throws Exception {
                SourceStatisticsTopComponent.this.toggleLoading();
                try {
                    ph.start();
                    return SourceStatisticsTopComponent.this.apiService.hostCsvReport(SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getStartTime(), SourceStatisticsTopComponent.this.getFinishTime(), SourceStatisticsTopComponent.this.getDelimeter());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsTopComponent.this.toggleLoading();
                    ph.finish();
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                block18: {
                    try {
                        HostStatsCsvReport hostCsvReport = (HostStatsCsvReport)this.get();
                        String fileName = SourceStatisticsTopComponent.this.genFileName();
                        JFileChooser saveDialog = new JFileChooser();
                        saveDialog.setDialogTitle(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.saveDialog.title"));
                        saveDialog.setDialogType(1);
                        saveDialog.setSelectedFile(new File(fileName));
                        int actionDialog = saveDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
                        if (actionDialog == 0) {
                            File dfile = new File(saveDialog.getCurrentDirectory(), saveDialog.getSelectedFile().getName());
                            dfile.createNewFile();
                            try (FileOutputStream stream = new FileOutputStream(dfile);){
                                stream.write(hostCsvReport.getDataHandler());
                                break block18;
                            }
                        }
                        ph.finish();
                    }
                    catch (IOException | InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        SourceStatisticsTopComponent.this.toggleLoading();
                        ph.finish();
                    }
                }
            }
        };
        worker.execute();
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void startSearch() {
        SwingWorker<HostStatsGuiReport, Void> worker = new SwingWorker<HostStatsGuiReport, Void>(){

            @Override
            protected HostStatsGuiReport doInBackground() throws Exception {
                SourceStatisticsTopComponent.this.toggleLoading();
                try {
                    return SourceStatisticsTopComponent.this.apiService.hostGuiReport(SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getQueryDomain(), SourceStatisticsTopComponent.this.getStartTime(), SourceStatisticsTopComponent.this.getFinishTime());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsTopComponent.this.toggleLoading();
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    HostStatsGuiReport hostGuiReport = (HostStatsGuiReport)this.get();
                    SourceStatisticsTopComponent.this.overviewTableModel.update(hostGuiReport.getOverview());
                    List hostsPerDomain = hostGuiReport.getHostsPerDomain();
                    SourceStatisticsTopComponent.this.hostsPerDomainTablemodel.update(hostsPerDomain);
                    List sumOfCountsPerHostname = hostGuiReport.getSumOfCountsPerHostname();
                    SourceStatisticsTopComponent.this.sumOfCountsPerHostnameTableModel.update(sumOfCountsPerHostname);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    SourceStatisticsTopComponent.this.toggleLoading();
                }
            }
        };
        worker.execute();
    }

    public void componentOpened() {
        this.startSearch();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

