/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps;

import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DataMapValue;

public class DataMapKey {
    private DataMapValue dmv = new DataMapValue();
    private long lastUpdated;
    private boolean hasValue;

    public DataMapKey(String map, DataMapValue dmv) {
        this.dmv.setKey(dmv.getKey());
        this.lastUpdated = dmv.getLastUpdated();
        this.dmv.setMap(map);
        this.hasValue = false;
    }

    public DataMapValue getDmv() {
        return this.dmv;
    }

    public String getValue() {
        if (!this.hasValue) {
            try {
                ApiService api = (ApiService)Lookup.getDefault().lookup(ApiService.class);
                DataMapValue r = api.getValueForDataMapKey(this.dmv.getMap(), this.dmv.getKey());
                this.setValue(r);
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.dmv.getValue();
    }

    public void setValue(DataMapValue value) {
        this.dmv.setValue(value.getValue());
        this.dmv.setLastUpdated(value.getLastUpdated());
        this.hasValue = true;
    }

    public boolean isHasValue() {
        return this.hasValue;
    }

    public void setHasValue(boolean hasValue) {
        this.hasValue = hasValue;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }
}

