/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.font.BitmapCharacter;
import com.jme3.font.BitmapCharacterSet;
import com.jme3.font.BitmapFont;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.shader.VarType;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.FontKey;

public class TTFFontLoader
implements AssetLoader {
    private static final int MAX_TEXTURE_WIDTH = 8192;

    public Object load(AssetInfo assetInfo) throws IOException {
        if (assetInfo.getKey() instanceof FontKey) {
            Graphics2D graphics = this.getGraphics();
            FontKey fontKey = (FontKey)assetInfo.getKey();
            Font font = this.getFont(assetInfo);
            graphics.setFont(font);
            FontData fontData = this.calculateFontData(graphics, fontKey);
            Texture t = this.prepareTexture(fontData, graphics, fontKey.getColor());
            this.setPagesForFont(assetInfo, fontData.bitmapFont, t);
            return fontData.bitmapFont;
        }
        throw new IllegalArgumentException("The given asset key should be of type: " + FontKey.class.getName());
    }

    protected FontData calculateFontData(Graphics2D graphics, FontKey fontKey) {
        Font font = graphics.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int glyphsAmount = font.getNumGlyphs();
        int i = 0;
        int missingGlyphCode = font.getMissingGlyphCode();
        char[] chars = new char[]{'\u0000'};
        FontData result = new FontData();
        result.bitmapFont = new BitmapFont();
        result.bitmapFont.setCharSet(new BitmapCharacterSet());
        result.bitmapFont.getCharSet().setRenderedSize(font.getSize());
        result.charList = new ArrayList<CharacterData>();
        while (i < glyphsAmount) {
            GlyphVector gv = font.createGlyphVector(graphics.getFontRenderContext(), chars);
            int glyphCode = gv.getGlyphCode(0);
            GlyphMetrics gm = gv.getGlyphMetrics(0);
            if (glyphCode != missingGlyphCode && glyphCode < glyphsAmount && result.bitmapFont.getCharSet().getCharacter((int)chars[0]) == null) {
                BitmapCharacter bitmapCharacter = new BitmapCharacter();
                bitmapCharacter.setWidth(Character.isWhitespace(chars[0]) ? (int)Math.ceil(gm.getAdvanceX()) : (int)Math.ceil(gm.getBounds2D().getWidth() + 1.0));
                bitmapCharacter.setXAdvance((int)Math.ceil(gm.getAdvanceX()));
                result.bitmapFont.getCharSet().addCharacter((int)chars[0], bitmapCharacter);
                result.imageWidth += bitmapCharacter.getWidth() + (int)Math.ceil(Math.abs(gm.getLSB()));
                result.imageHeight = (int)Math.ceil(Math.max((double)result.imageHeight, gv.getGlyphVisualBounds(0).getBounds2D().getHeight()));
                result.charList.add(new CharacterData(chars[0], gm.getLSB(), bitmapCharacter));
                ++i;
            } else if (Character.isWhitespace(chars[0])) {
                ++i;
            }
            chars[0] = (char)(chars[0] + '\u0001');
        }
        int ascentBuffer = this.parseBuffer(fontKey.getAboveAscentBuffer(), result.imageHeight);
        int descentBuffer = this.parseBuffer(fontKey.getAboveAscentBuffer(), result.imageHeight);
        result.imageHeight += ascentBuffer + descentBuffer;
        result.bitmapFont.getCharSet().setBase(fontMetrics.getMaxAscent() + ascentBuffer);
        result.bitmapFont.getCharSet().setLineHeight(fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + ascentBuffer + descentBuffer);
        result.bitmapFont.getCharSet().setRenderedSize(font.getSize());
        return result;
    }

    protected Font getFont(AssetInfo assetInfo) throws IOException {
        try {
            FontKey fontKey = (FontKey)assetInfo.getKey();
            return Font.createFont(fontKey.getType(), assetInfo.openStream()).deriveFont(fontKey.getStyle(), fontKey.getSize());
        }
        catch (FontFormatException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected Graphics2D getGraphics() {
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return gc.createCompatibleImage(1, 1, 3).createGraphics();
    }

    protected int parseBuffer(String buffer, int imageHeight) {
        if (buffer == null || buffer.isEmpty()) {
            return 0;
        }
        if (buffer.endsWith("%")) {
            String value = buffer.split("%")[0];
            float percent = Float.parseFloat(value);
            if (percent != 0.0f) {
                percent = 1.0f / percent;
            }
            return Math.round((float)imageHeight * percent);
        }
        if (buffer.endsWith("px")) {
            String value = buffer.split("px")[0];
            return (int)Float.parseFloat(value);
        }
        return 0;
    }

    protected Texture prepareTexture(FontData fontData, Graphics2D graphics, Color fontColor) {
        int n = fontData.imageWidth / 8192 + 1;
        int height = fontData.imageHeight * n;
        BufferedImage bufferedImage = graphics.getDeviceConfiguration().createCompatibleImage(n == 1 ? fontData.imageWidth : 8192, height, 3);
        Graphics2D imageGraphics = (Graphics2D)bufferedImage.getGraphics();
        imageGraphics.setFont(graphics.getFont());
        imageGraphics.setColor(fontColor);
        imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform at = new AffineTransform();
        at.scale(1.0, -1.0);
        at.translate(0.0, -bufferedImage.getHeight());
        imageGraphics.transform(at);
        int xPos = 0;
        int yPos = 0;
        int base = fontData.bitmapFont.getCharSet().getBase();
        char[] chars = new char[1];
        for (CharacterData characterData : fontData.charList) {
            chars[0] = characterData.character;
            characterData.bitmapCharacter.setXOffset(characterData.lsb);
            characterData.bitmapCharacter.setX(xPos);
            characterData.bitmapCharacter.setY(yPos);
            characterData.bitmapCharacter.setHeight(fontData.imageHeight);
            imageGraphics.drawChars(chars, 0, 1, xPos -= characterData.lsb, base + yPos);
            if ((xPos += characterData.lsb + characterData.bitmapCharacter.getWidth() + characterData.widthDelta) < 8192) continue;
            xPos = 0;
            yPos += fontData.imageHeight;
        }
        fontData.bitmapFont.getCharSet().setHeight(bufferedImage.getHeight());
        fontData.bitmapFont.getCharSet().setWidth(bufferedImage.getWidth());
        Image image = new AWTLoader().load(bufferedImage, false);
        if (image.getFormat() == null) {
            image.setFormat(Image.Format.RGBA8);
        }
        Texture2D texture = new Texture2D(image);
        texture.setMagFilter(Texture.MagFilter.Bilinear);
        texture.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
        return texture;
    }

    protected void setPagesForFont(AssetInfo assetInfo, BitmapFont bitmapFont, Texture ... textures) {
        Material[] pages = new Material[textures.length];
        MaterialDef spriteMat = (MaterialDef)assetInfo.getManager().loadAsset(new AssetKey("Common/MatDefs/Misc/Unshaded.j3md"));
        for (int i = 0; i < textures.length; ++i) {
            Material mat = new Material(spriteMat);
            mat.setTextureParam("ColorMap", VarType.Texture2D, textures[0]);
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            pages[0] = mat;
        }
        bitmapFont.setPages(pages);
    }

    protected static class FontData {
        public BitmapFont bitmapFont;
        public List<CharacterData> charList;
        public int imageWidth;
        public int imageHeight;

        protected FontData() {
        }
    }

    protected static class CharacterData {
        public char character;
        public int lsb;
        public int widthDelta;
        public BitmapCharacter bitmapCharacter;

        public CharacterData(char character, float lsb, BitmapCharacter bitmapCharacter) {
            this.character = character;
            this.lsb = (int)Math.floor(lsb);
            this.widthDelta = (int)Math.ceil(Math.abs(lsb));
            this.bitmapCharacter = bitmapCharacter;
        }
    }
}

