/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.asset.AssetManager;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.ui.Picture;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.RGBAToAwt;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;

public class RenderedText {
    private static final int DEFAULT_PADDING = 3;
    private final AssetManager assetManager;
    private final ColorRGBA color;
    private ColorRGBA shadowColor;
    private final Font font;
    private int padding = 3;
    private final String text;
    private Vector3f shadowOffset;
    private int maxTextureSize;

    public RenderedText(AssetManager assetManager, String text, String fontName, String style, int size, ColorRGBA color, int maxTextureSize) {
        this(assetManager, text, fontName, style, size, color, null, null, maxTextureSize);
    }

    public RenderedText(AssetManager assetManager, String text, String fontName, String style, int size, ColorRGBA color, Vector3f shadowOffset, ColorRGBA shadowColor, int maxTextureSize) {
        this.assetManager = assetManager;
        this.text = text;
        this.color = color;
        this.font = Renderer.getFont(fontName, size, style);
        this.shadowColor = shadowColor;
        this.shadowOffset = shadowOffset;
        this.maxTextureSize = maxTextureSize;
    }

    public Dimension getImageDimensions() {
        Graphics2D g = this.getGraphics();
        g.setFont(this.font);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g.getFontMetrics();
        g.dispose();
        if (this.shadowOffset != null && this.shadowOffset.length() > 0.0f) {
            return this.clipSizeToMaxTextureSize(fm.stringWidth(this.text) + (int)this.shadowOffset.x, fm.getHeight() + (int)this.shadowOffset.y);
        }
        return this.clipSizeToMaxTextureSize(fm.stringWidth(this.text), fm.getHeight());
    }

    private Dimension clipSizeToMaxTextureSize(int width, int height) {
        width = width > this.maxTextureSize ? this.maxTextureSize : width;
        height = height > this.maxTextureSize ? this.maxTextureSize : height;
        return new Dimension(width, height);
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public Picture getPicture() {
        Texture2D tex = this.getTexture();
        Picture ret = new Picture("text");
        ret.setTexture(this.assetManager, tex, true);
        ret.setWidth((float)tex.getImage().getWidth());
        ret.setHeight((float)tex.getImage().getHeight());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getBufferedImage() {
        Dimension dim = this.getImageDimensions();
        int width = dim.width + 2 * this.padding;
        int height = dim.height + 1 * this.padding;
        BufferedImage ret = new BufferedImage(width, height, 2);
        Graphics2D g = ret.createGraphics();
        try {
            int x = this.padding;
            int y = ret.getHeight() - this.padding;
            g.setFont(this.font);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (this.shadowOffset != null) {
                int ox = x + (int)this.shadowOffset.x;
                int oy = y + (int)this.shadowOffset.y;
                g.setColor(new RGBAToAwt(this.shadowColor).getColor());
                g.drawString(this.text, ox, oy);
            }
            g.setColor(new RGBAToAwt(this.color).getColor());
            g.drawString(this.text, x, y);
        }
        finally {
            g.dispose();
        }
        return ret;
    }

    private Graphics2D getGraphics() {
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return gc.createCompatibleImage(1, 1, 3).createGraphics();
    }

    private Texture2D getTexture() {
        Image img = new AWTLoader().load(this.getBufferedImage(), true);
        if (img.getFormat() == null) {
            img.setFormat(Image.Format.RGBA8);
        }
        return new Texture2D(img);
    }
}

