/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.sf.jasperreports.chrome.ChromeInstance;
import net.sf.jasperreports.chrome.ChromeInstanceHandle;
import net.sf.jasperreports.chrome.ChromeInstanceState;
import net.sf.jasperreports.chrome.LaunchConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChromeInstanceRepository {
    private static final Log log = LogFactory.getLog(ChromeInstanceRepository.class);
    private static final ChromeInstanceRepository INSTANCE = new ChromeInstanceRepository();
    private final Map<LaunchConfiguration, ChromeInstance> instances = new HashMap<LaunchConfiguration, ChromeInstance>();
    private final ScheduledExecutorService timeoutExecutor = Executors.newScheduledThreadPool(1, runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("Chrome timeout");
        thread.setDaemon(true);
        return thread;
    });

    public static ChromeInstanceRepository instance() {
        return INSTANCE;
    }

    protected ChromeInstanceRepository() {
    }

    public ChromeInstanceHandle getChromeInstanceHandle(LaunchConfiguration configuration) {
        ChromeInstance chromeInstance = this.instance(configuration);
        return chromeInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChromeInstance instance(LaunchConfiguration configuration) {
        Map<LaunchConfiguration, ChromeInstance> map = this.instances;
        synchronized (map) {
            ChromeInstance instance = this.instances.get(configuration);
            if (instance != null && !instance.isAlive()) {
                log.warn((Object)("Chrome instance " + instance.getId() + " not available"));
                instance = null;
            }
            if (instance == null) {
                instance = new ChromeInstance(configuration);
                instance.start();
                this.scheduleTimeoutChecks(configuration, instance);
                this.instances.put(configuration, instance);
            }
            return instance;
        }
    }

    protected void scheduleTimeoutChecks(LaunchConfiguration configuration, ChromeInstance chromeInstance) {
        long liveTimeout;
        long idleTimeout = configuration.getIdleTimeout();
        if (idleTimeout > 0L) {
            this.scheduleIdleTimeoutCheck(configuration, chromeInstance, idleTimeout, idleTimeout);
        }
        if ((liveTimeout = configuration.getLiveTimeout()) > 0L) {
            this.scheduleLiveTimeoutCheck(configuration, chromeInstance, liveTimeout);
        }
    }

    protected void scheduleIdleTimeoutCheck(LaunchConfiguration configuration, ChromeInstance chromeInstance, long idleTimeout, long delay) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("schedule chrome instance " + chromeInstance.getId() + " idle timeout check after " + delay));
        }
        WeakReference<ChromeInstance> instanceReference = new WeakReference<ChromeInstance>(chromeInstance);
        this.timeoutExecutor.schedule(() -> this.checkIdle(configuration, instanceReference, idleTimeout), delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIdle(LaunchConfiguration configuration, WeakReference<ChromeInstance> instanceReference, long idleTimeout) {
        boolean toClose;
        ChromeInstance instance = (ChromeInstance)instanceReference.get();
        if (instance == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"cleared chrome instance reference on idle check");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("checking idle timeout for chrome instance " + instance.getId()));
        }
        Map<LaunchConfiguration, ChromeInstance> map = this.instances;
        synchronized (map) {
            long now = System.currentTimeMillis();
            ChromeInstanceState state = instance.getState();
            if (state.isClosed()) {
                log.debug((Object)("chrome instance " + instance.getId() + " already closed"));
                toClose = false;
            } else {
                boolean bl = toClose = state.getUseCount() == 0L && state.getUseTimestamp() + idleTimeout <= now;
                if (toClose) {
                    this.removeCachedInstance(configuration, instance);
                } else {
                    this.scheduleIdleTimeoutCheck(configuration, instance, idleTimeout, state.getUseCount() == 0L ? state.getUseTimestamp() + idleTimeout - now : idleTimeout);
                }
            }
        }
        if (toClose) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("chrome instance " + instance.getId() + " exceeded idle timeout"));
            }
            instance.close();
        }
    }

    protected void scheduleLiveTimeoutCheck(LaunchConfiguration configuration, ChromeInstance chromeInstance, long liveTimeout) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("schedule chrome instance " + chromeInstance.getId() + " timeout after " + liveTimeout));
        }
        WeakReference<ChromeInstance> instanceReference = new WeakReference<ChromeInstance>(chromeInstance);
        this.timeoutExecutor.schedule(() -> this.closeInstance(configuration, instanceReference), liveTimeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeInstance(LaunchConfiguration configuration, WeakReference<ChromeInstance> instanceReference) {
        boolean toClose;
        ChromeInstance instance = (ChromeInstance)instanceReference.get();
        if (instance == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"cleared chrome instance reference on close");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("live timeout for chrome instance " + instance.getId()));
        }
        Map<LaunchConfiguration, ChromeInstance> map = this.instances;
        synchronized (map) {
            ChromeInstanceState state = instance.getState();
            boolean bl = toClose = !state.isClosed();
            if (toClose) {
                this.removeCachedInstance(configuration, instance);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("chrome instance " + instance.getId() + " already closed"));
            }
        }
        if (toClose) {
            instance.close();
        }
    }

    protected void removeCachedInstance(LaunchConfiguration configuration, ChromeInstance chromeInstance) {
        ChromeInstance cachedInstance = this.instances.get(configuration);
        if (cachedInstance == chromeInstance) {
            this.instances.remove(configuration);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("found different cached chrome instance " + (cachedInstance == null ? "null" : Long.valueOf(cachedInstance.getId()))));
        }
    }
}

