/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class Attributed {
    private boolean dirty = true;
    int attrHashCode;
    int prevAttrHashCode;
    final Map<String, String> keyAttributes = new HashMap<String, String>();
    final Map<String, String> otherAttributes = new HashMap<String, String>();

    public static String key(String k) {
        String r = k;
        if (k.startsWith("*")) {
            r = k.substring(1, k.length());
        }
        return r;
    }

    public Attributed(Map<String, String> attrs) {
        this.setAll(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> attributes() {
        HashSet<String> r = new HashSet<String>();
        Map<String, String> map = this.keyAttributes;
        synchronized (map) {
            r.addAll(this.keyAttributes.keySet());
        }
        map = this.otherAttributes;
        synchronized (map) {
            r.addAll(this.otherAttributes.keySet());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String k) {
        String r;
        Map<String, String> map = this.keyAttributes;
        synchronized (map) {
            r = this.keyAttributes.get(Attributed.key(k));
            if (r == null) {
                Map<String, String> map2 = this.otherAttributes;
                synchronized (map2) {
                    r = this.otherAttributes.get(Attributed.key(k));
                }
            }
        }
        return r;
    }

    public float get(String k, float def) {
        return Float.parseFloat(this.get(k, String.valueOf(def)));
    }

    public String get(String k, String def) {
        String v = this.get(Attributed.key(k));
        if (v == null) {
            v = def;
        }
        return v;
    }

    public void setAll(Map<String, String> attrs) {
        if (attrs != null) {
            for (Map.Entry<String, String> e : attrs.entrySet()) {
                this.set(e.getKey(), e.getValue(), false);
            }
            this.updateAttrHashCode();
        }
    }

    public int getAttrHashCode() {
        return this.attrHashCode;
    }

    public int getPrevAttrHashCode() {
        return this.prevAttrHashCode;
    }

    public void remove(String k) {
        this.remove(k, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String k, boolean updateHash) {
        Map<String, String> dest = this.otherAttributes;
        if (k.startsWith("*")) {
            dest = this.keyAttributes;
        }
        Map<String, String> map = dest;
        synchronized (map) {
            dest.remove(Attributed.key(k));
            if (updateHash) {
                this.updateAttrHashCode();
            }
        }
    }

    public void set(String k, String v) {
        this.set(k, v, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOthers(Map<String, String> attrs) {
        if (attrs != null) {
            Map<String, String> map = this.otherAttributes;
            synchronized (map) {
                for (Map.Entry<String, String> e : attrs.entrySet()) {
                    this.otherAttributes.put(Attributed.key(e.getKey()), e.getValue());
                }
                this.updateAttrHashCode();
            }
        }
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(String k, String v, boolean updateHash) {
        Map<String, String> dest = this.otherAttributes;
        if (k.startsWith("*")) {
            dest = this.keyAttributes;
        }
        Map<String, String> map = dest;
        synchronized (map) {
            dest.put(Attributed.key(k), v);
            if (updateHash) {
                this.updateAttrHashCode();
            }
        }
        this.dirty = true;
    }

    private void updateAttrHashCode() {
        this.prevAttrHashCode = this.attrHashCode;
        int hash = 5;
        hash = 17 * hash + Objects.hashCode(this.keyAttributes);
        this.attrHashCode = hash = 17 * hash + Objects.hashCode(this.otherAttributes);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

