/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.modifiers.ArmatureModifier;
import com.jme3.scene.plugins.blender.modifiers.ArrayModifier;
import com.jme3.scene.plugins.blender.modifiers.MirrorModifier;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.modifiers.ParticlesModifier;
import com.jme3.scene.plugins.blender.modifiers.SubdivisionSurfaceModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModifierHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ModifierHelper.class.getName());

    public ModifierHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public Collection<Modifier> readModifiers(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        HashSet<String> alreadyReadModifiers = new HashSet<String>();
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        Structure modifiersListBase = (Structure)objectStructure.getFieldValue("modifiers");
        List<Structure> modifiers = modifiersListBase.evaluateListBase();
        for (Structure modifierStructure : modifiers) {
            String modifierType = modifierStructure.getType();
            if (!Modifier.canBeAppliedMultipleTimes(modifierType) && alreadyReadModifiers.contains(modifierType)) {
                LOGGER.log(Level.WARNING, "Modifier {0} can only be applied once to object: {1}", new Object[]{modifierType, objectStructure.getName()});
                continue;
            }
            Modifier modifier = null;
            if ("ArrayModifierData".equals(modifierStructure.getType())) {
                modifier = new ArrayModifier(modifierStructure, blenderContext);
            } else if ("MirrorModifierData".equals(modifierStructure.getType())) {
                modifier = new MirrorModifier(modifierStructure, blenderContext);
            } else if ("ArmatureModifierData".equals(modifierStructure.getType())) {
                modifier = new ArmatureModifier(objectStructure, modifierStructure, blenderContext);
            } else if ("ParticleSystemModifierData".equals(modifierStructure.getType())) {
                modifier = new ParticlesModifier(modifierStructure, blenderContext);
            } else if ("SubsurfModifierData".equals(modifierStructure.getType())) {
                modifier = new SubdivisionSurfaceModifier(modifierStructure, blenderContext);
            }
            if (modifier != null) {
                if (modifier.isModifying()) {
                    result.add(modifier);
                    alreadyReadModifiers.add(modifierType);
                    continue;
                }
                LOGGER.log(Level.WARNING, "The modifier {0} will cause no changes in the model. It will be ignored!", modifierStructure.getName());
                continue;
            }
            LOGGER.log(Level.WARNING, "Unsupported modifier type: {0}", modifierStructure.getType());
        }
        return result;
    }
}

