/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.landscape;

import com.jme3.asset.AssetManager;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.post.filters.FogFilter;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.ColorBand;
import com.jme3.scene.plugins.blender.textures.CombinedTexture;
import com.jme3.scene.plugins.blender.textures.ImageUtils;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.TextureCubeMap;
import com.jme3.util.SkyFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LandscapeHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(LandscapeHelper.class.getName());
    private static final int SKYTYPE_BLEND = 1;
    private static final int SKYTYPE_REAL = 2;
    private static final int SKYTYPE_PAPER = 4;
    private static final int MODE_MIST = 1;

    public LandscapeHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public Light toAmbientLight(Structure worldStructure) {
        LOGGER.fine("Loading ambient light.");
        AmbientLight ambientLight = null;
        float ambr = ((Number)worldStructure.getFieldValue("ambr")).floatValue();
        float ambg = ((Number)worldStructure.getFieldValue("ambg")).floatValue();
        float ambb = ((Number)worldStructure.getFieldValue("ambb")).floatValue();
        if (ambr > 0.0f || ambg > 0.0f || ambb > 0.0f) {
            ambientLight = new AmbientLight();
            ColorRGBA ambientLightColor = new ColorRGBA(ambr, ambg, ambb, 0.0f);
            ambientLight.setColor(ambientLightColor);
            LOGGER.log(Level.FINE, "Loaded ambient light: {0}.", ambientLightColor);
        } else {
            LOGGER.finer("Ambient light is set to BLACK which means: no ambient light! The ambient light node will not be included in the result.");
        }
        return ambientLight;
    }

    public FogFilter toFog(Structure worldStructure) {
        FogFilter result = null;
        int mode = ((Number)worldStructure.getFieldValue("mode")).intValue();
        if ((mode & 1) != 0) {
            LOGGER.fine("Loading fog.");
            result = new FogFilter();
            result.setName("FIfog");
            result.setFogColor(this.toBackgroundColor(worldStructure));
        }
        return result;
    }

    public ColorRGBA toBackgroundColor(Structure worldStructure) {
        float horr = ((Number)worldStructure.getFieldValue("horr")).floatValue();
        float horg = ((Number)worldStructure.getFieldValue("horg")).floatValue();
        float horb = ((Number)worldStructure.getFieldValue("horb")).floatValue();
        return new ColorRGBA(horr, horg, horb, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spatial toSky(Structure worldStructure) throws BlenderFileException {
        int skytype = ((Number)worldStructure.getFieldValue("skytype")).intValue();
        if (skytype == 0) {
            return null;
        }
        LOGGER.fine("Loading sky.");
        ColorRGBA horizontalColor = this.toBackgroundColor(worldStructure);
        float zenr = ((Number)worldStructure.getFieldValue("zenr")).floatValue();
        float zeng = ((Number)worldStructure.getFieldValue("zeng")).floatValue();
        float zenb = ((Number)worldStructure.getFieldValue("zenb")).floatValue();
        ColorRGBA zenithColor = new ColorRGBA(zenr, zeng, zenb, 1.0f);
        boolean loadGeneratedTextures = this.blenderContext.getBlenderKey().isLoadGeneratedTextures();
        this.blenderContext.getBlenderKey().setLoadGeneratedTextures(true);
        TextureHelper textureHelper = (TextureHelper)this.blenderContext.getHelper(TextureHelper.class);
        List<CombinedTexture> loadedTextures = null;
        try {
            loadedTextures = textureHelper.readTextureData(worldStructure, new float[]{horizontalColor.r, horizontalColor.g, horizontalColor.b, horizontalColor.a}, true);
        }
        finally {
            this.blenderContext.getBlenderKey().setLoadGeneratedTextures(loadGeneratedTextures);
        }
        TextureCubeMap texture = null;
        if (loadedTextures != null && loadedTextures.size() > 0) {
            if (loadedTextures.size() > 1) {
                throw new IllegalStateException("There should be only one combined texture for sky!");
            }
            CombinedTexture combinedTexture = loadedTextures.get(0);
            texture = combinedTexture.generateSkyTexture(horizontalColor, zenithColor, this.blenderContext);
        } else {
            int x;
            int y;
            int[] sideImagesIndexes;
            LOGGER.fine("Preparing colors for colorband.");
            int colorbandType = 3;
            ArrayList<ColorRGBA> colorbandColors = new ArrayList<ColorRGBA>(3);
            colorbandColors.add(horizontalColor);
            if ((skytype & 1) != 0) {
                if ((skytype & 4) != 0) {
                    colorbandType = 0;
                }
                if ((skytype & 2) != 0) {
                    colorbandColors.add(0, zenithColor);
                }
                colorbandColors.add(zenithColor);
            }
            int size = this.blenderContext.getBlenderKey().getSkyGeneratedTextureSize();
            ArrayList<Integer> positions = new ArrayList<Integer>(colorbandColors.size());
            positions.add(0);
            if (colorbandColors.size() == 2) {
                positions.add(size - 1);
            } else if (colorbandColors.size() == 3) {
                positions.add(size / 2);
                positions.add(size - 1);
            }
            LOGGER.fine("Generating sky texture.");
            float[][] values = new ColorBand(colorbandType, colorbandColors, positions, size).computeValues();
            Image image = ImageUtils.createEmptyImage(Image.Format.RGB8, size, size, 6);
            PixelInputOutput pixelIO = PixelIOFactory.getPixelIO(image.getFormat());
            TexturePixel pixel = new TexturePixel();
            LOGGER.fine("Creating side textures.");
            for (int i : sideImagesIndexes = new int[]{0, 1, 4, 5}) {
                for (int y2 = 0; y2 < size; ++y2) {
                    pixel.red = values[y2][0];
                    pixel.green = values[y2][1];
                    pixel.blue = values[y2][2];
                    for (int x2 = 0; x2 < size; ++x2) {
                        pixelIO.write(image, i, pixel, x2, y2);
                    }
                }
            }
            LOGGER.fine("Creating top texture.");
            pixelIO.read(image, 0, pixel, 0, image.getHeight() - 1);
            for (y = 0; y < size; ++y) {
                for (x = 0; x < size; ++x) {
                    pixelIO.write(image, 3, pixel, x, y);
                }
            }
            LOGGER.fine("Creating bottom texture.");
            pixelIO.read(image, 0, pixel, 0, 0);
            for (y = 0; y < size; ++y) {
                for (x = 0; x < size; ++x) {
                    pixelIO.write(image, 2, pixel, x, y);
                }
            }
            texture = new TextureCubeMap(image);
        }
        LOGGER.fine("Sky texture created. Creating sky.");
        return SkyFactory.createSky((AssetManager)this.blenderContext.getAssetManager(), (Texture)texture, (SkyFactory.EnvMapType)SkyFactory.EnvMapType.CubeMap);
    }
}

