/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Structure;

public class BoneEnvelope {
    private float distance;
    private float weight;
    private float boneHeadRadius;
    private float boneTailRadius;
    private Vector3f head;
    private Vector3f tail;

    public BoneEnvelope(Structure boneStructure, Matrix4f armatureWorldMatrix, boolean fixUpAxis) {
        this.distance = ((Number)boneStructure.getFieldValue("dist")).floatValue();
        this.weight = ((Number)boneStructure.getFieldValue("weight")).floatValue();
        this.boneHeadRadius = ((Number)boneStructure.getFieldValue("rad_head")).floatValue();
        this.boneTailRadius = ((Number)boneStructure.getFieldValue("rad_tail")).floatValue();
        DynamicArray headArray = (DynamicArray)boneStructure.getFieldValue("arm_head");
        this.head = new Vector3f(((Number)headArray.get(0)).floatValue(), ((Number)headArray.get(1)).floatValue(), ((Number)headArray.get(2)).floatValue());
        if (fixUpAxis) {
            float z = this.head.z;
            this.head.z = -this.head.y;
            this.head.y = z;
        }
        armatureWorldMatrix.mult(this.head, this.head);
        DynamicArray tailArray = (DynamicArray)boneStructure.getFieldValue("arm_tail");
        this.tail = new Vector3f(((Number)tailArray.get(0)).floatValue(), ((Number)tailArray.get(1)).floatValue(), ((Number)tailArray.get(2)).floatValue());
        if (fixUpAxis) {
            float z = this.tail.z;
            this.tail.z = -this.tail.y;
            this.tail.y = z;
        }
        armatureWorldMatrix.mult(this.tail, this.tail);
    }

    public boolean isInEnvelope(Vector3f point) {
        Vector3f v = this.tail.subtract(this.head);
        float boneLength = v.length();
        v.normalizeLocal();
        float D = -v.dot(point);
        float temp = -(v.dot(this.head) + D) / v.dot(v);
        Vector3f p = this.head.add(v.x * temp, v.y * temp, v.z * temp);
        Vector3f headToPointOnLineVector = p.subtract(this.head);
        float headToPointLength = headToPointOnLineVector.length();
        float cosinus = headToPointOnLineVector.dot(v) / headToPointLength;
        if (cosinus < 0.0f && headToPointLength > this.boneHeadRadius || headToPointLength > boneLength + this.boneTailRadius) {
            return false;
        }
        float pointDistanceFromLine = point.subtract(p).length();
        float maximumDistance = 0.0f;
        if (cosinus < 0.0f) {
            maximumDistance = this.boneHeadRadius;
        } else if (headToPointLength < boneLength) {
            if (this.boneTailRadius > this.boneHeadRadius) {
                float headToPDistance = p.subtract(this.head).length();
                float x = headToPDistance * ((this.boneTailRadius - this.boneHeadRadius) / boneLength);
                maximumDistance = x + this.boneHeadRadius;
            } else if (this.boneTailRadius < this.boneHeadRadius) {
                float tailToPDistance = p.subtract(this.tail).length();
                float x = tailToPDistance * ((this.boneHeadRadius - this.boneTailRadius) / boneLength);
                maximumDistance = x + this.boneTailRadius;
            } else {
                maximumDistance = this.boneTailRadius;
            }
        } else {
            maximumDistance = this.boneTailRadius;
        }
        return pointDistanceFromLine <= maximumDistance + this.distance;
    }

    public float getWeight() {
        return this.weight;
    }

    public String toString() {
        return "BoneEnvelope [d=" + this.distance + ", w=" + this.weight + ", hr=" + this.boneHeadRadius + ", tr=" + this.boneTailRadius + ", (" + this.head + ") -> (" + this.tail + ")]";
    }
}

