/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.api.service.RawLogSimWrapper;
import rs.co.ast.aspen.api.service.SavedQueryData;
import rs.co.ast.aspen.api.service.SavedQueryDataType;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.rawlogs.AutoCompleteDecorator;
import rs.co.ast.aspen.gui.rawlogs.DisplayOptions;
import rs.co.ast.aspen.gui.rawlogs.DisplayOptionsDisplayer;
import rs.co.ast.aspen.gui.rawlogs.OverviewPanel;
import rs.co.ast.aspen.gui.rawlogs.QuerySetNamePanel;
import rs.co.ast.aspen.gui.rawlogs.RawLogDetailsTopComponent;
import rs.co.ast.aspen.gui.rawlogs.RawLogSearchQueryUpdate;
import rs.co.ast.aspen.gui.rawlogs.RawLogTableRenderer;
import rs.co.ast.aspen.gui.rawlogs.RawLogsTableModel;
import rs.co.ast.aspen.gui.rawlogs.ResendEventDialog;
import rs.co.ast.aspen.gui.rawlogs.SavedQueryDataDialog;
import rs.co.ast.aspen.gui.rawlogs.query.QueryManager;
import rs.co.ast.aspen.gui.rawlogs.query.RawLogQueryHistory;
import rs.co.ast.aspen.gui.rawlogs.query.TopComponentTitleShortener;
import rs.co.ast.aspen.gui.rawlogs.search.SearchExecutor;
import rs.co.ast.aspen.gui.rawlogs.search.SkippedTaskInfo;
import rs.co.ast.aspen.gui.rawlogs.search.TaskMonitor;
import rs.co.ast.chart.FrontCountBarChart;
import rs.co.ast.chart.MyStackedXYBarRenderer;

@TopComponent.Description(preferredID="RawLogsTopComponent", iconBase="rawlogs.png", persistenceType=1)
public final class RawLogsTopComponent
extends TopComponent
implements PropertyChangeListener {
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private RawLogQueryHistory queryHistory = (RawLogQueryHistory)Lookup.getDefault().lookup(RawLogQueryHistory.class);
    private RawLogsTableModel tableModel = new RawLogsTableModel();
    private static final Logger logger = Logger.getLogger(RawLogsTopComponent.class.getName());
    private InstanceContent instanceContent = new InstanceContent();
    private Lookup selectedLog = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private final DisplayOptions displayOptions = new DisplayOptions();
    private final Timer autoRefreshTimer;
    private SearchExecutor searchExecutor;
    private final OverviewPanel overviewPanel = new OverviewPanel();
    private SavedQueryData queryData;
    private boolean selectLast = false;
    private AutoCompleteDecorator autoCompleteDecorator = new AutoCompleteDecorator();
    private Lookup.Result<RawLogSearchQueryUpdate> lr = Utilities.actionsGlobalContext().lookupResult(RawLogSearchQueryUpdate.class);
    private DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());
    private String undoQuery = "";
    private String tag = UUID.randomUUID().toString();
    private FrontCountBarChart countChart;
    private ChartMouseListener chartMouseListener;
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenuItem miPaste = new JMenuItem(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.miPaste.text"));
    private String previousQuery = "previousQuery";
    private long startCreationOfTable = 0L;
    private RequestProcessor rp = new RequestProcessor("TransmitFromRLRawLogSimWrapperAndSecurityEventWrapper");
    private RawLogSimWrapper prevLog = null;
    private SecurityEvent prevEvent = null;
    public static final String PROP_QUERY_CHANGED = "queryChanged";
    private JButton bBottom;
    private JButton bDisplayOptions;
    private JButton bPageDown;
    private JButton bPageUp;
    private JButton bQueryBookmarks;
    private JButton bSearch;
    private JButton bTop;
    private JToggleButton btQueryBookmarked;
    private JXCollapsiblePane cpChart;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JXBusyLabel lLoading;
    private JLabel lQueryTime;
    private JLabel lSearchStatus;
    private JMenuItem miCopyRawLogText;
    private JMenuItem miResendEvent;
    private JPanel pChart;
    private JPanel pResults;
    private JPopupMenu pmRawLog;
    private JTable tRawLogs;
    private JToggleButton tbDesc;
    private JTextField tfSearch;
    private ListSelectionListener lSL = new ListSelectionListener(){
        private TopComponent securityEventDetails = WindowManager.getDefault().findTopComponent("SecurityEventDetailsTopComponent");

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                RawLog rawLog = (RawLog)RawLogsTopComponent.this.tableModel.getValueAt(RawLogsTopComponent.this.tRawLogs.getSelectedRow(), 0);
                boolean isSecurityEventsDetailsOpened = this.securityEventDetails.isOpened();
                RawLogsTopComponent.this.rp.execute((Runnable)new SelectionRunnable(rawLog, RawLogsTopComponent.this.prevLog, RawLogsTopComponent.this.prevEvent, isSecurityEventsDetailsOpened));
            }
        }
    };

    public RawLogsTopComponent() {
        logger.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.RAWLOGS), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.RAWLOGS)));
        this.displayOptions.load();
        this.displayOptions.setDescOrder(true);
        this.initComponents();
        this.setName(NbBundle.getMessage(RawLogsTopComponent.class, (String)"CTL_RawLogsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"HINT_RawLogsTopComponent"));
        this.bSearch.setForeground(Color.red);
        ProxyLookup mainLookup = new ProxyLookup(new Lookup[]{this.selectedLog, this.overviewPanel.getByFieldPanel().getRawLogQueryUpdateLookup()});
        this.associateLookup((Lookup)mainLookup);
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){
            RawLogSearchQueryUpdate prev = null;

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                Collection instances = lr.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof RawLogSearchQueryUpdate) || !RawLogsTopComponent.this.isVisible()) continue;
                    final RawLogSearchQueryUpdate squ = (RawLogSearchQueryUpdate)o;
                    if (!RawLogsTopComponent.this.tag.equals(squ.getTag())) continue;
                    final StringBuilder query = new StringBuilder();
                    if (squ.isOverride()) {
                        query.append(squ.getQuery());
                    } else {
                        if (RawLogsTopComponent.this.tfSearch.getText().contains("AND") && squ.getQuery().contains("OR") || RawLogsTopComponent.this.tfSearch.getText().contains("OR") && squ.getQuery().contains("AND")) {
                            query.append("(");
                            query.append(RawLogsTopComponent.this.tfSearch.getText());
                            query.append(")");
                        } else {
                            query.append(RawLogsTopComponent.this.tfSearch.getText());
                        }
                        query.append(squ.getQuery());
                    }
                    if (this.prev != null && this.prev.equals(squ)) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RawLogsTopComponent.this.tfSearch.setText(query.toString());
                            prev = squ;
                        }
                    });
                }
            }
        });
        this.tfSearch.setColumns(1);
        this.tfSearch.addMouseListener(new MouseListener(){
            private String text = NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.tfSearch.text");

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.text.equals(RawLogsTopComponent.this.tfSearch.getText())) {
                    RawLogsTopComponent.this.tfSearch.setText("");
                    RawLogsTopComponent.this.normal();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.addFocusListener(new FocusListener(){
            private String text = NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.tfSearch.text");

            @Override
            public void focusGained(FocusEvent e) {
                if (this.text.equals(RawLogsTopComponent.this.tfSearch.getText())) {
                    RawLogsTopComponent.this.tfSearch.setText("");
                    RawLogsTopComponent.this.normal();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.tfSearch.getDocument().addDocumentListener(new DocumentListener(){
            private RawLogSimWrapper prevRawLogSimWrapper;

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.fireQueryChanged(e);
                this.changeButtonColor();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.fireQueryChanged(e);
                this.changeButtonColor();
                RawLogsTopComponent.this.normal();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.fireQueryChanged(e);
                this.changeButtonColor();
            }

            private void changeButtonColor() {
                if (RawLogsTopComponent.this.previousQuery.equals(RawLogsTopComponent.this.tfSearch.getText())) {
                    RawLogsTopComponent.this.bSearch.setForeground(Color.black);
                } else {
                    RawLogsTopComponent.this.bSearch.setForeground(Color.red);
                }
            }

            private void fireQueryChanged(DocumentEvent e) {
                RawLogsTopComponent.this.displayOptions.setQuery(RawLogsTopComponent.this.tfSearch.getText());
                final RawLog log = (RawLog)RawLogsTopComponent.this.tableModel.getValueAt(RawLogsTopComponent.this.tRawLogs.getSelectedRow(), 0);
                if (log != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RawLogSimWrapper rlsw = new RawLogSimWrapper(log, RawLogsTopComponent.this.displayOptions.getTimeStart(), RawLogsTopComponent.this.displayOptions.getTimeFinish(), RawLogsTopComponent.this.tag, RawLogsTopComponent.this.displayOptions.isLastNHours(), RawLogsTopComponent.this.displayOptions.getLastNHoursSelectedIndex(), RawLogsTopComponent.this.displayOptions.isNow());
                            rlsw.setQuery(RawLogsTopComponent.this.tfSearch.getText());
                            if (prevRawLogSimWrapper != null) {
                                RawLogsTopComponent.this.instanceContent.remove((Object)prevRawLogSimWrapper);
                            }
                            RawLogsTopComponent.this.instanceContent.add((Object)rlsw);
                            prevRawLogSimWrapper = rlsw;
                        }
                    });
                }
            }
        });
        this.tfSearch.add(this.popupMenu);
        this.tfSearch.setComponentPopupMenu(this.popupMenu);
        this.miPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RawLogsTopComponent.this.reformatQueryInClipboard();
                RawLogsTopComponent.this.tfSearch.paste();
            }
        });
        this.popupMenu.add(this.miPaste);
        this.tRawLogs.setAutoResizeMode(4);
        int columnCount = this.tRawLogs.getColumnCount();
        int timestampColumnWidth = 200;
        int sourceColumnWidth = 100;
        if (columnCount > 0 && columnCount > 2) {
            TableColumn col1 = this.tRawLogs.getColumnModel().getColumn(0);
            col1.setMinWidth(timestampColumnWidth);
            col1.setMaxWidth(timestampColumnWidth);
            col1.setWidth(timestampColumnWidth);
            col1.setPreferredWidth(timestampColumnWidth);
            TableColumn col2 = this.tRawLogs.getColumnModel().getColumn(1);
            col2.setMinWidth(sourceColumnWidth);
            col2.setMaxWidth(sourceColumnWidth);
            col2.setWidth(sourceColumnWidth);
            col2.setPreferredWidth(sourceColumnWidth);
        }
        this.tRawLogs.getTableHeader().setReorderingAllowed(false);
        this.tRawLogs.setDefaultRenderer(RawLog.class, new RawLogTableRenderer());
        this.tRawLogs.setSelectionMode(0);
        this.tRawLogs.setRowSelectionAllowed(true);
        this.lQueryTime.setCursor(new Cursor(12));
        this.lQueryTime.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String query = QueryManager.makeQueryTimeQuery(RawLogsTopComponent.this.displayOptions.getTimeStart(), RawLogsTopComponent.this.displayOptions.getTimeFinish(), RawLogsTopComponent.this.isoTimeFormat);
                RawLogsTopComponent.this.tfSearch.setText(query);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RawLog event = (RawLog)RawLogsTopComponent.this.tableModel.getValueAt(RawLogsTopComponent.this.tRawLogs.getSelectedRow(), 0);
                String category = RawLogsTopComponent.this.tableModel.getColumnName(RawLogsTopComponent.this.tRawLogs.getSelectedColumn());
                String query = QueryManager.copyRawLogRow(event, category, RawLogsTopComponent.this.isoTimeFormat);
                StringSelection selection = new StringSelection(query);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        };
        KeyStroke strokeCopy = KeyStroke.getKeyStroke(67, 2, false);
        this.tRawLogs.registerKeyboardAction(listener, "Copy", strokeCopy, 0);
        this.tRawLogs.addKeyListener(new KeyListener(){
            private TopComponent securityEventDetails = WindowManager.getDefault().findTopComponent("SecurityEventDetailsTopComponent");

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int row = RawLogsTopComponent.this.tRawLogs.getSelectedRow();
                if (row != -1) {
                    RawLog rawLog = (RawLog)RawLogsTopComponent.this.tableModel.getValueAt(row, 0);
                    RawLogsTopComponent.this.rp.execute((Runnable)new SelectionRunnable(rawLog, RawLogsTopComponent.this.prevLog, RawLogsTopComponent.this.prevEvent, this.securityEventDetails.isOpened()));
                }
            }
        });
        this.tRawLogs.addMouseListener(new MouseListener(){
            private TopComponent securityEventDetails = WindowManager.getDefault().findTopComponent("SecurityEventDetailsTopComponent");

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = RawLogsTopComponent.this.tRawLogs.rowAtPoint(e.getPoint());
                if (row != -1) {
                    RawLog rawLog = (RawLog)RawLogsTopComponent.this.tableModel.getValueAt(row, 0);
                    RawLogsTopComponent.this.rp.execute((Runnable)new SelectionRunnable(rawLog, RawLogsTopComponent.this.prevLog, RawLogsTopComponent.this.prevEvent, this.securityEventDetails.isOpened()));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = RawLogsTopComponent.this.tRawLogs.rowAtPoint(e.getPoint());
                    int column = RawLogsTopComponent.this.tRawLogs.columnAtPoint(e.getPoint());
                    if (!RawLogsTopComponent.this.tRawLogs.isRowSelected(row)) {
                        if (row > -1) {
                            RawLogsTopComponent.this.tRawLogs.setRowSelectionInterval(row, row);
                        }
                        RawLogsTopComponent.this.tRawLogs.changeSelection(row, column, false, false);
                    }
                    RawLogsTopComponent.this.pmRawLog.show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getClickCount() == 2) {
                    TopComponent[] openedTopComponents;
                    Mode mode = WindowManager.getDefault().findMode("properties");
                    for (TopComponent tc : openedTopComponents = WindowManager.getDefault().getOpenedTopComponents(mode)) {
                        if (!(tc instanceof RawLogDetailsTopComponent)) continue;
                        tc.requestActive();
                        return;
                    }
                    RawLogDetailsTopComponent details = (RawLogDetailsTopComponent)WindowManager.getDefault().findTopComponent("RawLogDetailsTopComponent");
                    mode.dockInto((TopComponent)details);
                    RawLog event = (RawLog)RawLogsTopComponent.this.tableModel.getValueAt(RawLogsTopComponent.this.tRawLogs.getSelectedRow(), 0);
                    RawLogSimWrapper rlsw = new RawLogSimWrapper(event, RawLogsTopComponent.this.displayOptions.getTimeStart(), RawLogsTopComponent.this.displayOptions.getTimeFinish(), RawLogsTopComponent.this.tag, RawLogsTopComponent.this.displayOptions.isLastNHours(), RawLogsTopComponent.this.displayOptions.getLastNHoursSelectedIndex(), RawLogsTopComponent.this.displayOptions.isNow());
                    rlsw.setQuery(RawLogsTopComponent.this.tfSearch.getText());
                    details.setRawLogSimWrapper(rlsw);
                    details.open();
                    details.requestActive();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke controlV = KeyStroke.getKeyStroke(86, 2);
                if (e.getKeyCode() == controlV.getKeyCode()) {
                    RawLogsTopComponent.this.reformatQueryInClipboard();
                }
                if (e.getKeyCode() == 10) {
                    System.out.println("Started search.....");
                    RawLogsTopComponent.this.startSearch();
                } else {
                    RawLogsTopComponent.this.btQueryBookmarked.setSelected(false);
                }
            }
        });
        ActionListener undoListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RawLogsTopComponent.this.tfSearch.setText(RawLogsTopComponent.this.undoQuery);
            }
        };
        KeyStroke strokeUndo = KeyStroke.getKeyStroke(90, 2, false);
        this.tfSearch.registerKeyboardAction(undoListener, "Undo", strokeUndo, 0);
        KeyListener undoKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case ' ': 
                    case '\"': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '-': 
                    case ':': 
                    case '[': 
                    case ']': {
                        RawLogsTopComponent.this.updateUndoQuery();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        this.tfSearch.addKeyListener(undoKeyListener);
        this.displayOptions.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RawLogsTopComponent.this.displayOptions.save();
                RawLogsTopComponent.this.toggleButtonDescSetSelected(RawLogsTopComponent.this.displayOptions.isDescOrder());
                if (RawLogsTopComponent.this.displayOptions.getAutoRefresh() == 0) {
                    RawLogsTopComponent.this.stopAutoRefreshTimer();
                } else {
                    RawLogsTopComponent.this.startAutoRefreshTimer();
                }
                RawLogsTopComponent.this.startSearch();
            }
        });
        this.overviewPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("RL_FILTER_OUT_QUERY")) {
                    StringBuilder query = new StringBuilder();
                    if ((OverviewPanel.FilterOutParameters)evt.getNewValue() != null) {
                        OverviewPanel.FilterOutParameters parameters = (OverviewPanel.FilterOutParameters)evt.getNewValue();
                        if (!RawLogsTopComponent.this.tfSearch.getText().isEmpty()) {
                            query.append(RawLogsTopComponent.this.appendFilterOutQuery(parameters.getEvents(), parameters.getField()));
                        } else {
                            query.append(RawLogsTopComponent.this.makeFilterOutQuery(parameters.getEvents(), parameters.getField()));
                        }
                        RawLogsTopComponent.this.tfSearch.setText(query.toString());
                    }
                }
            }
        });
        this.autoRefreshTimer = new Timer(this.displayOptions.getAutoRefresh(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RawLogsTopComponent.this.startSearch();
            }
        });
        this.tbDesc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RawLogsTopComponent.this.tbDesc.isSelected()) {
                    RawLogsTopComponent.this.displayOptions.setDescOrder(false);
                    RawLogsTopComponent.this.tbDesc.setText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.asc"));
                } else {
                    RawLogsTopComponent.this.displayOptions.setDescOrder(true);
                    RawLogsTopComponent.this.tbDesc.setText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.desc"));
                }
            }
        });
        this.jTabbedPane1.insertTab(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.pOverview.TabConstraints.tabTitle", (Object[])new Object[0]), null, this.overviewPanel, "", 0);
        this.cpChart.setLayout((LayoutManager)new BorderLayout());
        this.cpChart.add((Component)this.pChart, (Object)"Center");
        this.chartMouseListener = new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                ChartEntity entity = event.getEntity();
                if (entity instanceof XYItemEntity) {
                    XYItemEntity item = (XYItemEntity)event.getEntity();
                    RawLogsTopComponent.this.countChart.getMyBarRenderer().resetSelectedItems();
                    RawLogsTopComponent.this.countChart.getMyBarRenderer().addSelectedItem(item.getItem());
                    List<DateRange> ranges = RawLogsTopComponent.this.searchExecutor.getSearchContext().getDateRanges();
                    DateRange dateRange = ranges.get(item.getItem());
                    RawLogsTopComponent.this.searchExecutor.setSelectedDateRange(dateRange);
                    RawLogsTopComponent.this.searchExecutor.getSearchContext().getSearchResults().getRawLogs().clear();
                    RawLogsTopComponent.this.fetch(dateRange);
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        };
        this.lSearchStatus.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    if (RawLogsTopComponent.this.cpChart.isCollapsed()) {
                        RawLogsTopComponent.this.cpChart.setCollapsed(false);
                        RawLogsTopComponent.this.displayOptions.setChartManuallyOpened(true);
                    } else {
                        RawLogsTopComponent.this.cpChart.setCollapsed(true);
                        RawLogsTopComponent.this.displayOptions.setChartManuallyOpened(false);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        AbstractAction searchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RawLogsTopComponent.this.startSearch();
            }
        };
        this.bSearch.setAction(searchAction);
        searchAction.putValue("AcceleratorKey", 116);
        this.bSearch.setText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.bSearch.text"));
        this.bSearch.getActionMap().put("searchAction", searchAction);
        KeyStroke keyStrokeForSearch = KeyStroke.getKeyStroke(116, 0);
        this.bSearch.getInputMap(2).put(keyStrokeForSearch, "searchAction");
    }

    private String appendFilterOutQuery(List<String> values, String field) {
        int i;
        String actualQuery = this.tfSearch.getText();
        if (actualQuery.length() >= 6000) {
            JOptionPane.showMessageDialog(null, "Query reached a maximum length. It's not possible to append a new query.", "Query length exceeded", 2);
            return actualQuery;
        }
        StringBuilder sb = new StringBuilder();
        int startIndex = -1;
        int endIndex = -1;
        String[] split = field.split("\\.");
        Pattern pattern = null;
        pattern = field.contains(".") ? Pattern.compile(split[0] + "\\." + split[1] + ":\\(") : Pattern.compile(field + ":\\(");
        Matcher matcher = pattern.matcher(actualQuery);
        while (matcher.find()) {
            startIndex = matcher.end();
        }
        if (startIndex != -1) {
            for (i = startIndex; i < actualQuery.length(); ++i) {
                if (actualQuery.charAt(i) != ')') continue;
                endIndex = i;
                break;
            }
        }
        if (endIndex != -1) {
            sb.append(actualQuery.substring(0, endIndex));
            sb.append(", ");
            for (i = 0; i < values.size(); ++i) {
                String val;
                sb.append("\"");
                if (values.get(i).contains("\\")) {
                    val = values.get(i).replace("\\", "\\\\");
                    sb.append(val);
                } else if (values.get(i).contains("\"")) {
                    val = values.get(i).replace("\"", "\\\"");
                    sb.append(val);
                } else {
                    sb.append(values.get(i));
                }
                sb.append("\"");
                if (i == values.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(actualQuery.substring(endIndex));
        } else {
            sb.append(actualQuery);
            sb.append(" AND ");
            sb.append(this.makeFilterOutQuery(values, field));
        }
        return sb.toString();
    }

    private String makeFilterOutQuery(List<String> values, String field) {
        if (this.tfSearch.getText().length() >= 6000) {
            JOptionPane.showMessageDialog(null, "Query reached a maximum length. It's not possible to append a new query.", "Query length exceeded", 2);
            return this.tfSearch.getText();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("NOT ");
        sb.append(field);
        sb.append(":(");
        for (int i = 0; i < values.size(); ++i) {
            String val;
            sb.append("\"");
            if (values.get(i).contains("\\")) {
                val = values.get(i).replace("\\", "\\\\");
                sb.append(val);
            } else if (values.get(i).contains("\"")) {
                val = values.get(i).replace("\"", "\\\"");
                sb.append(val);
            } else {
                sb.append(values.get(i));
            }
            sb.append("\"");
            if (i == values.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private void reformatQueryInClipboard() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String s = (String)cb.getData(DataFlavor.stringFlavor);
            s = s.replaceAll("\\n|\\t|\\r", "");
            s = s.replaceAll(" \\\\", " ");
            s = s.replaceAll("\\\\\"", "\"");
            StringSelection stringSelection = new StringSelection(s);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void setMappingsInOverviewPanel() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        TreeSet meta = new TreeSet();
        fields.add("source");
        fields.add("text");
        List<RawLog> rawLogs = this.searchExecutor.getSearchContext().getSearchResults().getRawLogs();
        rawLogs.forEach(e -> e.getMetaData().getEntry().forEach(m -> meta.add("metaData." + m.getKey())));
        fields.addAll(meta);
        this.overviewPanel.setMappingsInWidgetSettigsPanels(fields);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "PROP_TOTAL_HITS": {
                this.updateCountSearchStatus();
                break;
            }
            case "PROP_EVENTS": {
                List events = (List)evt.getNewValue();
                this.tableModel.setData(events);
                this.selectItemInTable();
                logger.info(String.format("CREATION OF TABLE IS FINISHED IN %d ms", System.currentTimeMillis() - this.startCreationOfTable));
                break;
            }
            case "PROP_COUNT_TASK_FINISHED": {
                this.updateCountSearchStatus();
                this.pChart.removeAll();
                if (this.searchExecutor.getSearchContext().getDateRanges().size() > 1) {
                    this.pChart.add((Component)this.createChart(this.createDataset()));
                    if (this.cpChart.isCollapsed() && this.displayOptions.isChartManuallyOpened()) {
                        this.cpChart.setCollapsed(false);
                    }
                } else {
                    List<DateRange> ranges = this.searchExecutor.getSearchContext().getDateRanges();
                    this.searchExecutor.setSelectedDateRange(ranges.get(0));
                }
                this.fetch((DateRange)evt.getNewValue());
                break;
            }
            case "PROP_FETCH_TASK_FINISHED": {
                this.updateCountSearchStatus();
                try {
                    this.searchExecutor.count();
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case "PROP_COUNT_TASK_FINISHED_SUCCESS": {
                if (!this.searchExecutor.getSearchContext().getTaskMonitor().isAllCountTasksCompleted() || this.countChart == null) break;
                List<DateRange> dateRanges = this.searchExecutor.getSearchContext().getDateRanges();
                DateRange dt = (DateRange)evt.getNewValue();
                this.countChart.getMyBarRenderer().removeFailedItem(dateRanges.indexOf(dt));
                break;
            }
            case "PROP_COUNT_TASK_SKIPPED": {
                SkippedTaskInfo sti = (SkippedTaskInfo)evt.getNewValue();
                logger.info(String.format("Date Range skipped: s: %s, f: %s", new DateTime(sti.getStartTimeStamp()), new DateTime(sti.getFinishTimeStamp())));
                if (this.searchExecutor.getSearchContext().getTaskMonitor().isAllCountTasksCompleted()) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), sti);
                } else {
                    this.searchExecutor.addTaskToSkippedTask(sti);
                }
                if (this.countChart == null) break;
                List<DateRange> dateRanges = this.searchExecutor.getSearchContext().getDateRanges();
                DateRange dt = sti.getDateRange();
                this.countChart.getMyBarRenderer().addFailedItem(dateRanges.indexOf(dt));
                break;
            }
            case "PROP_ALL_COUNT_TASKS_FINISHED": {
                logger.info("PROP_ALL_COUNT_TASKS_FINISHED");
                List<SkippedTaskInfo> tasks = this.searchExecutor.getSearchContext().getSkippedTasks();
                for (SkippedTaskInfo ski : tasks) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), ski);
                }
                this.searchExecutor.getSearchContext().getSkippedTasks().clear();
                break;
            }
            case "PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED": {
                logger.info("PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED");
                break;
            }
            case "PROP_ALL_FETCH_TASKS_FINISHED": {
                logger.info("PROP_ALL_FETCH_TASKS_FINISHED");
                break;
            }
            case "PROP_ALL_TASKS_FINISHED": {
                this.updateCountSearchStatus();
                if (this.countChart != null) {
                    this.countChart.getChartPanel().addChartMouseListener(this.chartMouseListener);
                }
                this.lLoading.setBusy(false);
                logger.info("ALL TASKS ARE COMPLETED");
                this.searchExecutor.getSearchContext().getSearchResults().setAccumulateTotalDuration(false);
                this.bPageUp.setEnabled(true);
                this.bPageDown.setEnabled(true);
                this.bTop.setEnabled(true);
                this.bBottom.setEnabled(true);
                if (this.displayOptions.isShowOverview()) {
                    this.setMappingsInOverviewPanel();
                }
                this.queryHistory.put(this.tfSearch.getText());
                break;
            }
            case "PROP_FETCH_TASK_FAILED": {
                break;
            }
            case "PROP_COUNT_TASK_FAILED": {
                this.updateCountSearchStatus();
                List errors = (List)evt.getNewValue();
                logger.info(String.format("TASK FAILED: %s", errors));
                this.lLoading.setBusy(false);
                this.searchExecutor.shutdown();
                this.bPageUp.setEnabled(true);
                this.bPageDown.setEnabled(true);
                this.bTop.setEnabled(true);
                this.bBottom.setEnabled(true);
                break;
            }
            case "PROP_FETCH_TASK_FINISHED_SUCCESS": {
                if (this.countChart == null || this.searchExecutor.getSearchContext().getTaskMonitor().isAllTasksCompleted()) break;
                DateRange dateRange = (DateRange)evt.getNewValue();
                List<DateRange> ranges = this.searchExecutor.getSearchContext().getDateRanges();
                int index = ranges.indexOf(dateRange);
                this.searchExecutor.setSelectedDateRange(ranges.get(index));
                this.countChart.getMyBarRenderer().addSelectedItem(index);
                this.countChart.updateChart(this.createDataset());
                this.countChart.getChartPanel().repaint();
                this.pChart.invalidate();
                this.pChart.repaint();
                break;
            }
            case "PROP_NEXT_PREV_MESSAGE": {
                JOptionPane.showMessageDialog((Component)((Object)this), evt.getNewValue());
                break;
            }
            case "PROP_FIRST_LAST_MESSAGE": {
                JOptionPane.showMessageDialog((Component)((Object)this), evt.getNewValue());
            }
        }
    }

    public HelpCtx getHelpCtx() {
        if (this.tfSearch.hasFocus()) {
            return new HelpCtx("rs.co.ast.aspen.gui.module.rawlogs.query");
        }
        return new HelpCtx("rs.co.ast.aspen.gui.module.rawlogs.about");
    }

    private void startAutoRefreshTimer() {
        if (this.displayOptions.getAutoRefresh() > 0) {
            this.autoRefreshTimer.setInitialDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.setDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.setRepeats(true);
            this.autoRefreshTimer.start();
        }
    }

    private void stopAutoRefreshTimer() {
        this.autoRefreshTimer.stop();
    }

    private void updateUndoQuery() {
        this.undoQuery = this.tfSearch.getText();
    }

    public void italic() {
        Font font = new Font("Dialog", 2, 12);
        this.tfSearch.setFont(font);
        this.tfSearch.setForeground(new Color(204, 204, 204));
    }

    public void normal() {
        Font font = new Font("Dialog", 0, 12);
        this.tfSearch.setFont(font);
        this.tfSearch.setForeground(Color.BLACK);
    }

    public void setAsc() {
        this.tbDesc.setSelected(false);
    }

    private void initComponents() {
        this.pmRawLog = new JPopupMenu();
        this.miCopyRawLogText = new JMenuItem();
        this.miResendEvent = new JMenuItem();
        this.pChart = new JPanel();
        this.tfSearch = new JTextField();
        this.bDisplayOptions = new JButton();
        this.bSearch = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.pResults = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tRawLogs = new JTable();
        this.bTop = new JButton();
        this.bPageUp = new JButton();
        this.bBottom = new JButton();
        this.bPageDown = new JButton();
        this.btQueryBookmarked = new JToggleButton();
        this.bQueryBookmarks = new JButton();
        this.lSearchStatus = new JLabel();
        this.lQueryTime = new JLabel();
        this.tbDesc = new JToggleButton();
        this.cpChart = new JXCollapsiblePane();
        this.lLoading = new JXBusyLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.miCopyRawLogText, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.miCopyRawLogText.text"));
        this.miCopyRawLogText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogsTopComponent.this.miCopyRawLogTextActionPerformed(evt);
            }
        });
        this.pmRawLog.add(this.miCopyRawLogText);
        Mnemonics.setLocalizedText((AbstractButton)this.miResendEvent, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.miResendEvent.text"));
        this.miResendEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogsTopComponent.this.miResendEventActionPerformed(evt);
            }
        });
        this.pmRawLog.add(this.miResendEvent);
        this.pChart.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.pChart.setMinimumSize(new Dimension(0, 100));
        this.pChart.setPreferredSize(new Dimension(0, 100));
        this.pChart.setLayout(new BorderLayout());
        this.tfSearch.setFont(new Font("Dialog", 2, 12));
        this.tfSearch.setForeground(new Color(204, 204, 204));
        this.tfSearch.setText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.tfSearch.text"));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogsTopComponent.this.tfSearchActionPerformed(evt);
            }
        });
        this.bDisplayOptions.setFont(new Font("Dialog", 0, 12));
        this.bDisplayOptions.setIcon(new ImageIcon(this.getClass().getResource("/wrench_orange.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bDisplayOptions, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.bDisplayOptions.text"));
        this.bDisplayOptions.setToolTipText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.bDisplayOptions.toolTipText"));
        this.bDisplayOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogsTopComponent.this.bDisplayOptionsActionPerformed(evt);
            }
        });
        this.bSearch.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.bSearch.text"));
        this.jTabbedPane1.setFont(new Font("Dialog", 0, 12));
        this.tRawLogs.setModel(this.tableModel);
        this.tRawLogs.setComponentPopupMenu(this.pmRawLog);
        this.jScrollPane2.setViewportView(this.tRawLogs);
        this.bTop.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_top.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bTop, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.bTop.text"));
        this.bTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogsTopComponent.this.bTopActionPerformed(evt);
            }
        });
        this.bPageUp.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_up.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bPageUp, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.bPageUp.text"));
        this.bPageUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogsTopComponent.this.bPageUpActionPerformed(evt);
            }
        });
        this.bBottom.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_bottom.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bBottom, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.bBottom.text"));
        this.bBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogsTopComponent.this.bBottomActionPerformed(evt);
            }
        });
        this.bPageDown.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_down.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bPageDown, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.bPageDown.text"));
        this.bPageDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogsTopComponent.this.bPageDownActionPerformed(evt);
            }
        });
        GroupLayout pResultsLayout = new GroupLayout(this.pResults);
        this.pResults.setLayout(pResultsLayout);
        pResultsLayout.setHorizontalGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pResultsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 887, Short.MAX_VALUE).addGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pResultsLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bBottom, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.bPageDown, -2, 30, -2))).addGroup(GroupLayout.Alignment.TRAILING, pResultsLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bPageUp, -2, 30, -2).addComponent(this.bTop, -2, 30, -2)))).addContainerGap()));
        pResultsLayout.setVerticalGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pResultsLayout.createSequentialGroup().addContainerGap().addGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pResultsLayout.createSequentialGroup().addComponent(this.bTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bPageUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bPageDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bBottom)).addComponent(this.jScrollPane2, -1, 368, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.pResults.TabConstraints.tabTitle"), this.pResults);
        this.btQueryBookmarked.setIcon(new ImageIcon(this.getClass().getResource("/star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btQueryBookmarked, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.btQueryBookmarked.text"));
        this.btQueryBookmarked.setToolTipText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.btQueryBookmarked.toolTipText"));
        this.btQueryBookmarked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogsTopComponent.this.btQueryBookmarkedActionPerformed(evt);
            }
        });
        this.bQueryBookmarks.setFont(new Font("Dialog", 0, 12));
        this.bQueryBookmarks.setIcon(new ImageIcon(this.getClass().getResource("/folder_star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bQueryBookmarks, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.bQueryBookmarks.text"));
        this.bQueryBookmarks.setToolTipText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.bQueryBookmarks.toolTipText"));
        this.bQueryBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogsTopComponent.this.bQueryBookmarksActionPerformed(evt);
            }
        });
        this.lSearchStatus.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lSearchStatus, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.lSearchStatus.text"));
        this.lQueryTime.setFont(new Font("Dialog", 0, 12));
        this.lQueryTime.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lQueryTime, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.lQueryTime.text"));
        this.tbDesc.setFont(new Font("Dialog", 0, 12));
        this.tbDesc.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDesc, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.tbDesc.text"));
        this.tbDesc.setMargin(new Insets(2, 2, 2, 2));
        this.cpChart.setCollapsed(true);
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.lLoading.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.cpChart, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent((Component)this.lLoading, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbDesc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bQueryBookmarks, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btQueryBookmarked, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDisplayOptions, -2, 30, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lSearchStatus, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lQueryTime, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bDisplayOptions).addComponent(this.btQueryBookmarked).addComponent(this.bSearch).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tbDesc).addComponent(this.tfSearch, -2, 26, -2).addComponent((Component)this.lLoading, -2, -1, -2)).addComponent(this.bQueryBookmarks)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lSearchStatus).addComponent(this.lQueryTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cpChart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addContainerGap()));
    }

    private void bDisplayOptionsActionPerformed(ActionEvent evt) {
        DisplayOptionsDisplayer.display(this.displayOptions);
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void bTopActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.first();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bPageUpActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.prev();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bBottomActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.last();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bPageDownActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.next();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void miCopyRawLogTextActionPerformed(ActionEvent evt) {
        if (this.tRawLogs.getSelectedRow() > -1) {
            RawLog rawLog = this.tableModel.getRawLog(this.tRawLogs.getSelectedRow());
            StringSelection selection = new StringSelection(rawLog.getText());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }
    }

    private void bQueryBookmarksActionPerformed(ActionEvent evt) {
        ArrayList<SavedQueryData> queries;
        try {
            queries = this.apiService.getRawLogQueries();
        }
        catch (ApiServiceException_Exception ex) {
            queries = new ArrayList<SavedQueryData>();
            Exceptions.printStackTrace((Throwable)ex);
        }
        final SavedQueryDataDialog dialog = new SavedQueryDataDialog();
        dialog.setData(queries);
        dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                SavedQueryData selectedQueryBookmark = dialog.getSelectedQueryBookmark();
                if (selectedQueryBookmark != null) {
                    RawLogsTopComponent.this.queryData = selectedQueryBookmark;
                    RawLogsTopComponent.this.tfSearch.setText(dialog.getSelectedQueryBookmark().getQuery());
                    RawLogsTopComponent.this.btQueryBookmarked.setSelected(true);
                    RawLogsTopComponent.this.startSearch();
                }
            }
        });
    }

    private void btQueryBookmarkedActionPerformed(ActionEvent evt) {
        try {
            if (this.btQueryBookmarked.isSelected() && !this.tfSearch.getText().isEmpty()) {
                final QuerySetNamePanel panel = new QuerySetNamePanel();
                DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(RawLogsTopComponent.class, (String)"SetQueryName.dialog.title"), true, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int opt = (Integer)e.getSource();
                        if (DialogDescriptor.OK_OPTION.equals(opt)) {
                            SavedQueryData q = new SavedQueryData();
                            q.setName(panel.getTypedName());
                            q.setQuery(RawLogsTopComponent.this.tfSearch.getText());
                            q.setType(SavedQueryDataType.RAW_LOGS_QUERY);
                            q.setId(DigestUtils.md5Hex((String)String.format("%s%s", q.getQuery(), q.getType())));
                            try {
                                RawLogsTopComponent.this.apiService.saveSavedQuery(q);
                            }
                            catch (ApiServiceException_Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            } else if (this.queryData != null) {
                this.apiService.deleteSavedQuery(this.queryData.getId());
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void miResendEventActionPerformed(ActionEvent evt) {
        if (this.tRawLogs.getSelectedRow() > -1) {
            RawLog rawLog = this.tableModel.getRawLog(this.tRawLogs.getSelectedRow());
            ResendEventDialog dialog = new ResendEventDialog(rawLog);
            dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
            dialog.setVisible(true);
            dialog.setDefaultCloseOperation(2);
        }
    }

    public void componentOpened() {
        this.startAutoRefreshTimer();
        this.queryHistory.init();
        this.autoCompleteDecorator.autoComplete(this.tfSearch, this.getMappings());
    }

    public void componentClosed() {
        this.stopAutoRefreshTimer();
    }

    private Set<String> getMappings() {
        HashSet<String> items = new HashSet<String>();
        return items;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("trl_col_count", String.valueOf(this.tRawLogs.getColumnModel().getColumnCount()));
        for (int i = 0; i < this.tRawLogs.getColumnModel().getColumnCount(); ++i) {
            TableColumn tc = this.tRawLogs.getColumnModel().getColumn(i);
            p.setProperty(String.format("trl_col%d_width", i), String.valueOf(tc.getWidth()));
        }
        p.setProperty("search_string", this.tfSearch.getText());
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        String colCountString = p.getProperty("trl_col_count");
        try {
            int colCount = colCountString != null ? Integer.valueOf(colCountString) : 0;
            for (int i = 0; i < colCount; ++i) {
                String s = p.getProperty("trl_col" + i + "_width");
                if (s == null) continue;
                this.tRawLogs.getColumnModel().getColumn(i).setPreferredWidth(Integer.valueOf(s));
            }
            this.tfSearch.setText(p.getProperty("search_string"));
        }
        catch (NumberFormatException ex) {
            logger.warning(String.format("Error converting to number: %s", ex.getMessage()));
        }
        this.tfSearchChangeFont();
    }

    private void selectLastItemInTableAndScroll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int rowCount = RawLogsTopComponent.this.tRawLogs.getRowCount() - 1;
                RawLogsTopComponent.this.tRawLogs.setRowSelectionInterval(rowCount, 0);
                RawLogsTopComponent.this.tRawLogs.changeSelection(rowCount, 0, false, false);
                RawLogsTopComponent.this.tRawLogs.scrollRectToVisible(new Rectangle(RawLogsTopComponent.this.tRawLogs.getCellRect(rowCount, 0, true)));
                RawLogsTopComponent.this.lSL.valueChanged(new ListSelectionEvent(RawLogsTopComponent.this.tRawLogs, rowCount, 0, false));
            }
        });
    }

    public void doSearch(String query, long startTime, long finishTime) {
        this.displayOptions.setTimeStart(startTime);
        this.displayOptions.setTimeFinish(finishTime);
        this.doSearch(query);
    }

    public void doSearch(String query) {
        this.tfSearch.setText(query);
        this.startSearch();
    }

    private void tfSearchChangeFont() {
        String text = NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.tfSearch.text");
        if (text.equals(this.tfSearch.getText())) {
            Font font = new Font("Dialog", 2, 12);
            this.tfSearch.setFont(font);
            this.tfSearch.setForeground(Color.LIGHT_GRAY);
        } else {
            Font font = new Font("Dialog", 0, 12);
            this.tfSearch.setFont(font);
            this.tfSearch.setForeground(Color.BLACK);
        }
    }

    public String getTag() {
        return this.tag;
    }

    public DisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    public void startSearch() {
        if (this.countChart != null) {
            this.countChart.getChartPanel().removeChartMouseListener(this.chartMouseListener);
            this.countChart = null;
        }
        this.cpChart.setCollapsed(true);
        this.tableModel.clearData();
        this.startCreationOfTable = System.currentTimeMillis();
        if (this.searchExecutor != null) {
            this.searchExecutor.shutdown();
        }
        this.bPageUp.setEnabled(false);
        this.bPageDown.setEnabled(false);
        this.bTop.setEnabled(false);
        this.bBottom.setEnabled(false);
        this.lQueryTime.setText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.lQueryTime.text.CalculatingTimestamps"));
        this.lSearchStatus.setText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.lSearchStatus.text.PreparingSearch"));
        this.displayOptions.adjustTime();
        if (this.tfSearch.getText().equals(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.tfSearch.text"))) {
            this.tfSearch.setText("");
            this.normal();
        }
        this.jTabbedPane1.setEnabledAt(0, this.displayOptions.isShowOverview());
        if (!this.displayOptions.isShowOverview()) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
        try {
            logger.info(String.format("START SEARCH: s: %s f: %s", new DateTime(this.displayOptions.getTimeStart()), new DateTime(this.displayOptions.getTimeFinish())));
            this.lLoading.setBusy(true);
            this.searchExecutor = new SearchExecutor(this.tfSearch.getText(), this.displayOptions.getTimeStart(), this.displayOptions.getTimeFinish(), this.displayOptions.getIndexSplit(), this.displayOptions.getPageSize(), !this.tbDesc.isSelected(), this);
            this.searchExecutor.startSearch();
            this.updateSearchTime();
            this.setDisplayName(TopComponentTitleShortener.shortenTitle(this.searchExecutor.ifQueryIsEmptySetToDefault(this.tfSearch.getText())));
            this.startAutoRefreshTimer();
            this.previousQuery = this.tfSearch.getText();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.displayOptions.isShowOverview()) {
            this.overviewPanel.update(this.searchExecutor.ifQueryIsEmptySetToDefault(this.tfSearch.getText()), this.displayOptions);
        }
        this.updateUndoQuery();
    }

    private void fetch(DateRange dr) {
        try {
            this.searchExecutor.fetch(dr);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateCountSearchStatus() {
        if (this.searchExecutor != null) {
            List<String> errors = this.searchExecutor.getSearchContext().getSearchResults().getErrors();
            long totalDuration = this.searchExecutor.getSearchContext().getSearchResults().getTotalDuration();
            if (!errors.isEmpty()) {
                this.lSearchStatus.setIcon(new ImageIcon(this.getClass().getResource("/delete.png")));
                StringBuilder sb = new StringBuilder();
                for (String err : errors) {
                    sb.append(err);
                    sb.append(", ");
                }
                if (sb.toString().length() > 2) {
                    sb.replace(sb.toString().length() - 2, sb.toString().length(), "");
                }
                String error = NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.lSearchStatus.failed.text", (Object[])new Object[]{totalDuration, sb.toString()});
                this.lSearchStatus.setToolTipText(error);
            } else {
                this.lSearchStatus.setIcon(null);
                this.lSearchStatus.setToolTipText("");
                this.bSearch.setForeground(Color.black);
            }
            this.lSearchStatus.setText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.lSearchStatus.text.label", (Object[])new Object[]{totalDuration, this.searchExecutor.getSearchContext().getSearchResults().getTotalHits()}));
        }
    }

    private void selectItemInTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RawLogsTopComponent.this.tRawLogs.getRowCount() > 0) {
                    if (RawLogsTopComponent.this.selectLast) {
                        RawLogsTopComponent.this.selectLastItemInTableAndScroll();
                        RawLogsTopComponent.this.selectLast = false;
                    } else if (!RawLogsTopComponent.this.tRawLogs.isRowSelected(0)) {
                        RawLogsTopComponent.this.tRawLogs.setRowSelectionInterval(0, 0);
                        RawLogsTopComponent.this.tRawLogs.changeSelection(0, 0, false, false);
                        RawLogsTopComponent.this.lSL.valueChanged(new ListSelectionEvent(RawLogsTopComponent.this.tRawLogs, 0, 0, false));
                    }
                }
            }
        });
    }

    private ChartPanel createChart(TimeTableXYDataset dataset) {
        if (this.countChart == null) {
            MyStackedXYBarRenderer renderer = new MyStackedXYBarRenderer();
            this.countChart = new FrontCountBarChart(dataset, renderer);
            ChartPanel chartPanel = this.countChart.getChartPanel();
            chartPanel.getChart().removeLegend();
        } else {
            this.countChart.updateChart(dataset);
            this.pChart.invalidate();
            this.pChart.repaint();
        }
        return this.countChart.getChartPanel();
    }

    private TimeTableXYDataset createDataset() {
        long startTime = System.currentTimeMillis();
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        dataset.setDomainIsPointsInTime(true);
        Map<DateRange, SearchState> searchStateForDateRange = this.searchExecutor.getSearchContext().getSearchStateForDateRange();
        for (DateRange dr : searchStateForDateRange.keySet()) {
            SearchState ss = searchStateForDateRange.get(dr);
            if (ss.getTotalHits() == null) continue;
            long totalHits = ss.getTotalHits();
            if (ss.getTotalHits() == -1L) {
                long m;
                totalHits = m = this.searchExecutor.getAverageCountValueForGraph();
            }
            dataset.add((TimePeriod)new SimpleTimePeriod(dr.getStartTimeStamp(), dr.getFinishTimeStamp()), (double)totalHits, (Comparable)((Object)""));
        }
        logger.info(String.format("CREATION OF DATASET IS FINISHED IN %d ms", System.currentTimeMillis() - startTime));
        return dataset;
    }

    private void updateSearchTime() {
        this.lQueryTime.setText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.lQueryTime.text.update", (Object[])new Object[]{this.isoTimeFormat.print(this.displayOptions.getTimeStart()), this.isoTimeFormat.print(this.displayOptions.getTimeFinish())}));
    }

    private void toggleButtonDescSetSelected(boolean isDescSelected) {
        if (isDescSelected) {
            this.tbDesc.setSelected(true);
            this.tbDesc.setText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.desc"));
        } else {
            this.tbDesc.setSelected(false);
            this.tbDesc.setText(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.asc"));
        }
        this.tbDesc.repaint();
    }

    private class SelectionRunnable
    implements Runnable {
        private RawLogSimWrapper prevLog = null;
        private SecurityEvent prevEvent = null;
        RawLog log = null;
        boolean isSecurityEventsDetailsOpened = false;

        public SelectionRunnable(RawLog log, RawLogSimWrapper prevLog, SecurityEvent prevEvent, boolean isSecurityEventDetailsOpened) {
            this.log = log;
            this.prevLog = prevLog;
            this.prevEvent = prevEvent;
            this.isSecurityEventsDetailsOpened = isSecurityEventDetailsOpened;
        }

        @Override
        public void run() {
            if (this.log != null) {
                RawLogSimWrapper rlsw = new RawLogSimWrapper(this.log, RawLogsTopComponent.this.displayOptions.getTimeStart(), RawLogsTopComponent.this.displayOptions.getTimeFinish(), RawLogsTopComponent.this.tag, RawLogsTopComponent.this.displayOptions.isLastNHours(), RawLogsTopComponent.this.displayOptions.getLastNHoursSelectedIndex(), RawLogsTopComponent.this.displayOptions.isNow());
                rlsw.setQuery(RawLogsTopComponent.this.tfSearch.getText());
                if (this.prevLog != null) {
                    RawLogsTopComponent.this.instanceContent.remove((Object)this.prevLog);
                }
                RawLogsTopComponent.this.instanceContent.add((Object)rlsw);
                this.prevLog = rlsw;
                if (this.isSecurityEventsDetailsOpened) {
                    try {
                        long start = this.log.getTimestamp() - 600000L;
                        long finish = this.log.getTimestamp() + 600000L;
                        SecurityEvent event = RawLogsTopComponent.this.apiService.getSecurityEvent(this.log.getId(), start, finish);
                        if (event == null) {
                            event = new SecurityEvent();
                            event.setId(NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.nodata"));
                            event.setTimestamp(Long.valueOf(0L));
                        }
                        if (this.prevEvent != null) {
                            RawLogsTopComponent.this.instanceContent.remove((Object)this.prevEvent);
                        }
                        RawLogsTopComponent.this.instanceContent.add((Object)event);
                        this.prevEvent = event;
                    }
                    catch (ApiServiceException_Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }
}

