/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.simplecorrelator;

import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.CellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionComboBoxNodeData;

public class EditorComboBox
extends JPanel
implements CellEditor {
    private JLabel label;
    private ComboBoxEditor comboBoxE;

    public EditorComboBox() {
        String[] m = new String[]{"1", "2"};
        this.comboBoxE = new ComboBoxEditor(m);
        this.label = new JLabel();
        this.label.setIcon(new ImageIcon(this.getClass().getResource("/application_form_edit.png")));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        this.setBackground(UIManager.getColor("Tree.background"));
        this.setLayout(flowLayout);
        this.add(this.label);
        this.add(this.comboBoxE);
    }

    void setNode(ActionComboBoxNodeData comboBoxNodeData) {
        this.comboBoxE.setNode(comboBoxNodeData);
        this.label.setText(comboBoxNodeData.getProperty());
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.comboBoxE.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.comboBoxE.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.comboBoxE.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.comboBoxE.cancelCellEditing();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.comboBoxE.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.comboBoxE.removeCellEditorListener(l);
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBoxE.getCellEditorValue();
    }

    private class ComboBoxEditor
    extends JComboBox
    implements CellEditor {
        private ActionComboBoxNodeData dataNode;
        private List listeners;

        public ComboBoxEditor(String[] items) {
            super(items);
            this.listeners = new ArrayList();
            this.addActionListener(ae -> {
                if (this.stopCellEditing()) {
                    this.fireEditingStopped();
                }
            });
        }

        public ActionComboBoxNodeData getNode() {
            return this.dataNode;
        }

        public void setNode(ActionComboBoxNodeData node) {
            this.dataNode = node;
            this.removeAllItems();
            for (String value : node.getValues()) {
                this.addItem(value);
            }
            this.setSelectedIndex(node.getSelectedIndex());
            this.dataNode.setSelectedIndex(node.getSelectedIndex());
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public boolean stopCellEditing() {
            try {
                if (this.isPopupVisible()) {
                    this.dataNode.setSelectedIndex(this.getSelectedIndex());
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.dataNode;
        }

        @Override
        public boolean isCellEditable(EventObject eo) {
            return eo == null || eo instanceof MouseEvent && ((MouseEvent)eo).isMetaDown();
        }

        @Override
        public boolean shouldSelectCell(EventObject eo) {
            return true;
        }

        @Override
        public void addCellEditorListener(CellEditorListener cel) {
            this.listeners.add(cel);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cel) {
            this.listeners.remove(cel);
        }

        protected void fireEditingStopped() {
            if (this.listeners.size() > 0) {
                ChangeEvent ce = new ChangeEvent(this);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    ((CellEditorListener)this.listeners.get(i)).editingStopped(ce);
                }
            }
        }
    }
}

