/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.search;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.joda.time.DateTime;
import org.openide.util.Lookup;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.IndexDateRange;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEventsCountContainer;
import rs.co.ast.aspen.api.service.SecurityEventsSearchResults;
import rs.co.ast.aspen.gui.module.alertevents.search.CountPage;
import rs.co.ast.aspen.gui.module.alertevents.search.Pageable;
import rs.co.ast.aspen.gui.module.alertevents.search.SearchContext;
import rs.co.ast.aspen.gui.module.alertevents.search.SkippedTaskInfo;
import rs.co.ast.aspen.gui.module.alertevents.search.TaskFactory;
import rs.co.ast.aspen.gui.module.alertevents.search.TaskMonitor;

public class SearchExecutor
implements Pageable {
    public static final String DEFAULT_SEARCH = "*";
    private static final Logger logger = Logger.getLogger(SearchExecutor.class.getName());
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PropertyChangeListener propertyChangeListener;
    private SearchContext searchContext;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private ScheduledExecutorService skippedTasksScheduler = Executors.newSingleThreadScheduledExecutor();
    private CountPage page;
    private String query;
    private int pageSize;
    private boolean sortAsc;
    private DateRange selectedDateRange = null;

    public SearchExecutor(String query, long startTime, long finishTime, long indexSplit, int pageSize, boolean sortAsc, PropertyChangeListener propertyChangeListener) throws ApiServiceException_Exception {
        this.query = query;
        this.pageSize = pageSize;
        this.sortAsc = sortAsc;
        this.propertyChangeListener = propertyChangeListener;
        this.searchContext = new SearchContext(pageSize, sortAsc, propertyChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        logger.info(String.format("START TIME %s: FINISH TIME %s: Split %d", new DateTime(startTime), new DateTime(finishTime), indexSplit));
        this.fillIndexDateIntervals(startTime, finishTime, indexSplit, sortAsc);
        this.initPageWithDateRanges();
    }

    public void startSearch() throws ApiServiceException_Exception {
        if (this.searchContext.getIndexDateIntervals().isEmpty()) {
            this.searchContext.getSearchResults().addError("No data to search for!");
            this.searchContext.getTaskMonitor().fireAllTasksCompleted();
            return;
        }
        this.count();
    }

    public void count() throws ApiServiceException_Exception {
        this.propertyChangeSupport.firePropertyChange("PROP_COUNT_TASK_STARTED", false, true);
        this.query = this.ifQueryIsEmptySetToDefault(this.query);
        if (this.page.hasNext()) {
            DateRange dr = this.page.next();
            try {
                SwingWorker<SecurityEventsCountContainer, Void> run = TaskFactory.getCountTask(this.searchContext, this.query, dr);
                run.addPropertyChangeListener(this.propertyChangeListener);
                this.executor.submit(run);
            }
            catch (RejectedExecutionException ex) {
                logger.warning("Can't submit task - executor is shutting down!");
            }
        }
    }

    public void fetch(DateRange dateRange) throws ApiServiceException_Exception {
        this.propertyChangeSupport.firePropertyChange("PROP_FETCH_TASK_STARTED", false, true);
        SearchState ss = this.searchContext.getSearchStateForDateRange().get(dateRange);
        if (ss == null) {
            this.propertyChangeSupport.firePropertyChange("PROP_FETCH_TASK_FINISHED", null, dateRange);
            return;
        }
        if (ss.getTotalHits() == null) {
            this.propertyChangeSupport.firePropertyChange("PROP_FETCH_TASK_FINISHED", null, dateRange);
            return;
        }
        this.query = this.ifQueryIsEmptySetToDefault(this.query);
        logger.info(String.format("E: %d, PS: %d, ST: %s, ST2: %s, TC: %s", this.searchContext.getSearchResults().getEvents().size(), this.pageSize, this.searchContext.getTaskMonitor().areThereSkippedTasks(), this.searchContext.getTaskMonitor().isAllSkippedTasksCompleted(), this.searchContext.getTaskMonitor().isAllCountTasksCompleted()));
        if (this.searchContext.getSearchResults().getEvents().size() < this.pageSize || this.searchContext.getTaskMonitor().areThereSkippedTasks() && this.searchContext.getTaskMonitor().isAllCountTasksCompleted() && this.searchContext.getSearchResults().getTotalHits() == (long)this.searchContext.getSearchResults().getEvents().size()) {
            logger.info(String.format("FETCH: s: %s f: %s", new DateTime(dateRange.getStartTimeStamp()), new DateTime(dateRange.getFinishTimeStamp())));
            try {
                SwingWorker<SecurityEventsSearchResults, Void> run = TaskFactory.getFetchTask(this.searchContext, this.query, this.pageSize, dateRange, this.sortAsc);
                run.addPropertyChangeListener(this.searchContext.getPropertyChangeListener());
                this.executor.submit(run);
            }
            catch (RejectedExecutionException ex) {
                logger.warning("Can't submit task - executor is shutting down!");
            }
        } else {
            this.searchContext.getTaskMonitor().completeTask(TaskMonitor.BaseTaskName.FETCH, dateRange.getStartTimeStamp(), dateRange.getFinishTimeStamp());
            this.propertyChangeSupport.firePropertyChange("PROP_FETCH_TASK_FINISHED", null, dateRange);
        }
    }

    public void submitSkippedTaskWithBackoff(String taskName, SkippedTaskInfo ski) {
        String skippedTaskName = this.searchContext.getTaskMonitor().generateSkippedTaskName(taskName, ski.getStartTimeStamp(), ski.getFinishTimeStamp());
        if (!this.searchContext.getSkippedTaskDelayes().isSkipCountLimitExceeded(skippedTaskName)) {
            Long delay = this.searchContext.getSkippedTaskDelayes().getDelayForSkippedTaskName(skippedTaskName);
            try {
                this.skippedTasksScheduler.schedule(TaskFactory.getSkippedTask(this.searchContext, ski, this.executor, this.propertyChangeListener), (long)delay, TimeUnit.MILLISECONDS);
                delay = delay * 2L;
                this.searchContext.getSkippedTaskDelayes().putDelayForSkippedTaskName(skippedTaskName, delay);
            }
            catch (RejectedExecutionException ex) {
                logger.warning("Can't submit task - executor is shutting down!");
            }
        } else {
            this.searchContext.getTaskMonitor().completeTask(TaskMonitor.BaseTaskName.COUNT, ski.getStartTimeStamp(), ski.getFinishTimeStamp());
        }
    }

    public void addTaskToSkippedTask(SkippedTaskInfo ski) {
        this.searchContext.getTaskMonitor().putIntoSkippedTasks(TaskMonitor.BaseTaskName.COUNT, ski.getStartTimeStamp(), ski.getFinishTimeStamp());
        this.searchContext.getSkippedTasks().add(ski);
    }

    public void shutdown() {
        logger.warning("Executor is shutting down!");
        this.skippedTasksScheduler.shutdownNow();
        this.executor.shutdownNow();
    }

    public final void initPageWithDateRanges() {
        ArrayList<DateRange> dateRanges = new ArrayList<DateRange>();
        for (IndexDateRange idr : this.searchContext.getIndexDateIntervals()) {
            dateRanges.addAll(idr.getDateRanges());
        }
        this.page = new CountPage(dateRanges);
    }

    public final void fillIndexDateIntervals(long startTime, long finishTime, long indexSplit, boolean sortAsc) throws ApiServiceException_Exception {
        if (this.searchContext.getIndexDateIntervals() == null) {
            this.searchContext.setIndexDateIntervals(this.getDateIntervals(startTime, finishTime, indexSplit, sortAsc));
            this.searchContext.getTaskMonitor().fill(this.searchContext.getIndexDateIntervals());
        }
        this.printIndexDateIntervals();
    }

    private void printIndexDateIntervals() {
        for (IndexDateRange idx : this.searchContext.getIndexDateIntervals()) {
            logger.info(String.format("%s - s: %s, f: %s", idx.getName(), new DateTime(idx.getStartTimeStamp()), new DateTime(idx.getEndTimeStamp())));
            for (DateRange dr : idx.getDateRanges()) {
                logger.info(String.format("     s: %s, f: %s", new DateTime(dr.getStartTimeStamp()), new DateTime(dr.getFinishTimeStamp())));
            }
        }
    }

    public List<IndexDateRange> getDateIntervals(long startTime, long finishTime, long indexSplit, boolean sortAsc) throws ApiServiceException_Exception {
        return this.apiService.getCustomAlertEventDateRangeByIndex(startTime, finishTime, indexSplit, sortAsc);
    }

    public String ifQueryIsEmptySetToDefault(String query) {
        return query == null || query.isEmpty() ? DEFAULT_SEARCH : query;
    }

    public SearchContext getSearchContext() {
        return this.searchContext;
    }

    public DateRange getSelectedDateRange() {
        return this.selectedDateRange;
    }

    public void setSelectedDateRange(DateRange selectedDateRange) {
        this.selectedDateRange = selectedDateRange;
    }

    @Override
    public void next() throws ApiServiceException_Exception {
        this.doNext();
    }

    private void doNext() throws ApiServiceException_Exception {
        if (this.selectedDateRange != null) {
            SearchState searchState = this.searchContext.getSearchStateForDateRange().get(this.selectedDateRange);
            long totalHits = searchState.getTotalHits();
            long offset = searchState.getOffset() + (long)this.pageSize;
            long l = offset = offset > totalHits ? totalHits : offset;
            if (offset > 5000L) {
                this.propertyChangeSupport.firePropertyChange("PROP_NEXT_PREV_MESSAGE", "", String.format("These are the %s 5000 events matching your search, refine your search to see more.", this.sortAsc ? "first" : "last"));
                return;
            }
            if (searchState.getOffset() + (long)this.pageSize < totalHits) {
                this.searchContext.getSearchResults().getEvents().clear();
                searchState.setOffset(offset);
                logger.info(String.format("NEXT: [%s - %s] - TH: %d, OS: %d", new DateTime(this.selectedDateRange.getStartTimeStamp()), new DateTime(this.selectedDateRange.getFinishTimeStamp()), totalHits, offset));
                this.fetch(this.selectedDateRange);
            }
        }
    }

    @Override
    public void prev() throws ApiServiceException_Exception {
        this.doPrev();
    }

    private void doPrev() throws ApiServiceException_Exception {
        if (this.selectedDateRange != null) {
            SearchState searchState = this.searchContext.getSearchStateForDateRange().get(this.selectedDateRange);
            long totalHits = searchState.getTotalHits();
            long offset = searchState.getOffset() - (long)this.pageSize;
            if (offset > 5000L) {
                this.propertyChangeSupport.firePropertyChange("PROP_NEXT_PREV_MESSAGE", "", String.format("These are the %s 5000 events matching your search, refine your search to see more.", this.sortAsc ? "first" : "last"));
                return;
            }
            if (searchState.getOffset() > 0L) {
                this.searchContext.getSearchResults().getEvents().clear();
                searchState.setOffset(offset);
                logger.info(String.format("PREV: [%s - %s] - TH: %d, OS: %d", new DateTime(this.selectedDateRange.getStartTimeStamp()), new DateTime(this.selectedDateRange.getFinishTimeStamp()), totalHits, offset));
                this.fetch(this.selectedDateRange);
            } else {
                this.propertyChangeSupport.firePropertyChange("PROP_NEXT_PREV_MESSAGE", "", String.format("You have reached end of visible events. Try %s or refine your search to se others.", this.sortAsc ? "next" : "previous"));
            }
        }
    }

    @Override
    public void first() throws ApiServiceException_Exception {
        this.doFirst();
    }

    private void doFirst() throws ApiServiceException_Exception {
        if (this.selectedDateRange != null) {
            SearchState searchState = this.searchContext.getSearchStateForDateRange().get(this.selectedDateRange);
            long totalHits = searchState.getTotalHits();
            if (searchState.getOffset() > 0L) {
                this.searchContext.getSearchResults().getEvents().clear();
                searchState.setOffset(0L);
                logger.info(String.format("FIRST: [%s - %s] - TH: %d, OS: %d", new DateTime(this.selectedDateRange.getStartTimeStamp()), new DateTime(this.selectedDateRange.getFinishTimeStamp()), totalHits, 0));
                this.fetch(this.selectedDateRange);
            } else {
                this.propertyChangeSupport.firePropertyChange("PROP_FIRST_LAST_MESSAGE", "", String.format("You have reached end of visible events. Try %s or refine your search to se others.", this.sortAsc ? "next" : "previous"));
            }
        }
    }

    @Override
    public void last() throws ApiServiceException_Exception {
        this.doLast();
    }

    private void doLast() throws ApiServiceException_Exception {
        if (this.selectedDateRange != null) {
            long offset;
            SearchState searchState = this.searchContext.getSearchStateForDateRange().get(this.selectedDateRange);
            long totalHits = searchState.getTotalHits();
            long l = offset = totalHits <= (long)this.pageSize ? 0L : totalHits - (long)this.pageSize;
            if (offset > 5000L) {
                this.propertyChangeSupport.firePropertyChange("PROP_FIRST_LAST_MESSAGE", "", String.format("These are the %s 5000 events matching your search, refine your search to see others.\nHint: if you want to see very %s records for this timeslot, select %s and click search again", this.sortAsc ? "first" : "last", this.sortAsc ? "last" : "first", this.sortAsc ? "DESC" : "ASC"));
                return;
            }
            if (searchState.getOffset() < totalHits - (long)this.pageSize) {
                this.searchContext.getSearchResults().getEvents().clear();
                searchState.setOffset(offset);
                logger.info(String.format("LAST: [%s - %s] - TH: %d, OS: %d", new DateTime(this.selectedDateRange.getStartTimeStamp()), new DateTime(this.selectedDateRange.getFinishTimeStamp()), totalHits, offset));
                this.fetch(this.selectedDateRange);
            } else {
                this.propertyChangeSupport.firePropertyChange("PROP_FIRST_LAST_MESSAGE", "", String.format("You have reached end of visible events. Try %s or refine your search to se others.", this.sortAsc ? "next" : "previous"));
            }
        }
    }

    public long getAverageCountValueForGraph() {
        long totalHits = this.searchContext.getSearchResults().getTotalHits();
        int size = this.searchContext.getDateRanges().size();
        return totalHits / (long)size;
    }
}

