/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.export.strategies;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.api.service.SecurityEventsSearchResults;
import rs.co.ast.aspen.gui.module.alertevents.export.strategies.ExportStrategy;

public class XMLExportStrategy
extends ExportStrategy {
    public XMLExportStrategy(String query, String exportPath, long startTime, long finishTime, long indexSplit) throws ApiServiceException_Exception {
        super(query, exportPath, startTime, finishTime, indexSplit, "xml");
    }

    @Override
    public SwingWorker<byte[], Void> search(final String fileName, final SearchState searchState, final DateRange dateRange) {
        return new SwingWorker<byte[], Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected byte[] doInBackground() throws Exception {
                SecurityEventsSearchResults result = XMLExportStrategy.this.fetch(searchState, dateRange);
                ExportStrategy.logger.info(String.format("FETCH - s: %s - f: %s, o: %d, d: %d, t: %d", new DateTime(dateRange.getStartTimeStamp()), new DateTime(dateRange.getFinishTimeStamp()), result.getSearchState().getOffset(), result.getContainer().getSecurityEvents().size(), result.getSearchState().getTotalHits()));
                if (!result.getContainer().getErrors().isEmpty()) {
                    ExportStrategy.logger.warning(String.format("FETCH ERRORS - %s", result.getContainer().getErrors()));
                    XMLExportStrategy.this.fileSkippedSupport.fireFileSkippedEvent(fileName, dateRange, searchState);
                    return null;
                }
                try (ByteArrayOutputStream osFile = new ByteArrayOutputStream();){
                    JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SecurityEvent.class});
                    Marshaller m = ctx.createMarshaller();
                    m.setProperty("jaxb.formatted.output", (Object)true);
                    m.setProperty("jaxb.fragment", (Object)true);
                    StringBuilder sb = new StringBuilder();
                    sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    sb.append("<events>");
                    osFile.write(sb.toString().getBytes());
                    int progress = 0;
                    for (SecurityEvent r : result.getContainer().getSecurityEvents()) {
                        ByteArrayOutputStream osSecurityEvent = new ByteArrayOutputStream();
                        Throwable throwable2 = null;
                        try {
                            JAXBElement je2 = new JAXBElement(new QName("securityevent"), SecurityEvent.class, (Object)r);
                            m.marshal((Object)je2, (OutputStream)osSecurityEvent);
                            osSecurityEvent.writeTo(osFile);
                            XMLExportStrategy.this.progressValueChangedSupport.fireProgressValueChangedEvent(progress++, progress, result.getContainer().getSecurityEvents().size(), 0.0f);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (osSecurityEvent == null) continue;
                            if (throwable2 != null) {
                                try {
                                    osSecurityEvent.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            osSecurityEvent.close();
                        }
                    }
                    osFile.write("</events>".getBytes());
                    osFile.close();
                    Object object = osFile.toByteArray();
                    return object;
                }
                catch (IOException | JAXBException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    byte[] file = (byte[])this.get();
                    if (file == null) {
                        return;
                    }
                    XMLExportStrategy.this.taskMonitor.completeFetch(fileName);
                    XMLExportStrategy.this.fileCreatedSupport.fireFileCreatedEvent(fileName, file, true);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
    }
}

