/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.gui.module.alertevents.analysis.Column;
import rs.co.ast.aspen.gui.module.alertevents.analysis.DatabaseEvent;
import rs.co.ast.aspen.gui.module.alertevents.analysis.DatabaseEventListener;
import rs.co.ast.aspen.gui.module.alertevents.analysis.InMemoryDatabase;

public class AlertFieldsTableModel
extends DefaultTableModel {
    private List<Column> columsModel = new ArrayList<Column>();
    private List<Column> columns = new ArrayList<Column>();
    private List<String> columnNames = new ArrayList<String>();
    private List<Column> deletedColumns = new ArrayList<Column>();
    private Column newlyAddedColumn;
    private InMemoryDatabase memDB = (InMemoryDatabase)Lookup.getDefault().lookup(InMemoryDatabase.class);
    private DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());
    private int rowCount = 0;
    private int currentRowIndex = 0;
    private Map<String, String> currentRow;
    private Comparator<Column> comparator = new Comparator<Column>(){

        @Override
        public int compare(Column o1, Column o2) {
            int i1 = 0;
            int i2 = 0;
            for (int i = 0; i < AlertFieldsTableModel.this.columsModel.size(); ++i) {
                if (((Column)AlertFieldsTableModel.this.columsModel.get(i)).getName().equalsIgnoreCase(o1.getName())) {
                    i1 = i;
                    continue;
                }
                if (!((Column)AlertFieldsTableModel.this.columsModel.get(i)).getName().equalsIgnoreCase(o2.getName())) continue;
                i2 = i;
            }
            if (i1 < i2) {
                return -1;
            }
            if (i2 < i1) {
                return 1;
            }
            return 0;
        }
    };

    public AlertFieldsTableModel() {
        this.memDB.addDatabaseEventListener(new DatabaseEventListener(){

            @Override
            public void tableCreated(DatabaseEvent event) {
            }

            @Override
            public void dataInserted(DatabaseEvent event) {
                SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        AlertFieldsTableModel.this.rowCount = 0;
                        AlertFieldsTableModel.this.currentRowIndex = 0;
                        AlertFieldsTableModel.this.currentRow = null;
                        AlertFieldsTableModel.this.columns.clear();
                        AlertFieldsTableModel.this.columnNames.clear();
                        for (String c : AlertFieldsTableModel.this.memDB.getColumns()) {
                            Column col = new Column(c);
                            AlertFieldsTableModel.this.columns.add(col);
                            AlertFieldsTableModel.this.columnNames.add(c);
                        }
                        AlertFieldsTableModel.this.columsModel.addAll(AlertFieldsTableModel.this.columns);
                        AlertFieldsTableModel.this.memDB.setColumns(AlertFieldsTableModel.this.columnNames);
                        AlertFieldsTableModel.this.rowCount = AlertFieldsTableModel.this.memDB.getRowCount();
                        return true;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AlertFieldsTableModel.this.fireTableStructureChanged();
                                    AlertFieldsTableModel.this.fireTableDataChanged();
                                }
                            });
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                };
                worker.execute();
            }

            @Override
            public void functionQueryExecuted(DatabaseEvent event) {
            }
        });
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames != null ? this.columnNames.get(column) : NbBundle.getMessage(AlertFieldsTableModel.class, (String)"FieldsTableModel.column.unknown");
    }

    public Column getColumn(int column) {
        return this.columns != null ? this.columns.get(column) : null;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames != null ? this.columnNames.size() : 0;
    }

    public void addColumn(String columnName) {
        for (int i = 0; i < this.deletedColumns.size(); ++i) {
            Column col = this.deletedColumns.get(i);
            if (!col.getName().equalsIgnoreCase(columnName)) continue;
            this.columns.add(col);
            this.deletedColumns.remove(i);
            break;
        }
        this.sortColumns();
        this.updateColumnNames();
        this.fireTableStructureChanged();
    }

    public void removeColumn(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            Column col = this.columns.get(i);
            if (!col.getName().equalsIgnoreCase(columnName)) continue;
            this.deletedColumns.add(col);
            this.columns.remove(i);
            break;
        }
        this.updateColumnNames();
        this.fireTableStructureChanged();
    }

    private void updateColumnNames() {
        this.columnNames.clear();
        for (Column c : this.columns) {
            this.columnNames.add(c.getName());
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        String col;
        String value;
        if (this.currentRowIndex != row || this.currentRow == null) {
            this.currentRow = this.memDB.selectSpecificRow(row);
            if (this.currentRow != null) {
                ++this.currentRowIndex;
            }
        }
        if ((value = this.currentRow.get(col = this.columnNames.get(column))) != null && (col.contains("when.generated") || col.contains("when.persisted") || col.contains("when.request_time"))) {
            if (col.contains("when.request_time")) {
                value = value.replace(".", "");
            }
            try {
                Long lVal = Long.valueOf(value);
                value = this.isoTimeFormat.print(lVal.longValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public Column getNewlyAddedColumn() {
        return this.newlyAddedColumn;
    }

    public void setNewlyAddedColumn(Column newlyAddedColumn) {
        this.newlyAddedColumn = newlyAddedColumn;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void resetData() {
        this.columnNames.clear();
        this.columsModel.clear();
        this.deletedColumns.clear();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    private void sortColumns() {
        Collections.sort(this.columns, this.comparator);
    }
}

