/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.api.service;

import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;

public class ModuleVersionUtils {
    public static String getModuleVersion(String codename) {
        for (UpdateUnit updateUnit : UpdateManager.getDefault().getUpdateUnits()) {
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateElement == null || !codename.equals(updateElement.getCodeName())) continue;
            return updateElement.getSpecificationVersion();
        }
        return "unknown";
    }

    public static String getModuleVersion(CodeName codeName) {
        return ModuleVersionUtils.getModuleVersion(codeName.getCodeName());
    }

    public static String getConsoleVersion() {
        return ModuleVersionUtils.getModuleVersion(CodeName.CONSOLE);
    }

    public static String getModuleDisplayName(String codename) {
        for (UpdateUnit updateUnit : UpdateManager.getDefault().getUpdateUnits()) {
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateElement == null || !codename.equals(updateElement.getCodeName())) continue;
            return updateElement.getDisplayName();
        }
        return "unknown";
    }

    public static String getModuleDisplayName(CodeName codeName) {
        return ModuleVersionUtils.getModuleDisplayName(codeName.getCodeName());
    }

    public static boolean isInstalled(CodeName codeName) {
        return ModuleVersionUtils.isInstalled(codeName.getCodeName());
    }

    public static boolean isInstalled(String codename) {
        for (UpdateUnit updateUnit : UpdateManager.getDefault().getUpdateUnits()) {
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateElement == null || !codename.equals(updateElement.getCodeName())) continue;
            return true;
        }
        return false;
    }

    public static enum CodeName {
        RAWLOGS("rs.co.ast.aspen.gui.module.rawlogs"),
        SWINGX("rs.co.ast.aspen.lib.module.swingx"),
        USER_MANAGEMENT("rs.co.ast.aspen.gui.module.usermgmt"),
        PRSMODEL("rs.co.ast.aspen.core.module.prsmodel"),
        FONTS("rs.co.ast.aspen.lib.module.jasperreports.custom.fonts"),
        PUS("rs.co.ast.aspen.gui.module.pus"),
        JASPERREPORTS("rs.co.ast.aspen.lib.module.jasperreports"),
        DATAMAPS("rs.co.ast.aspen.gui.module.datamaps"),
        SECURITYEVENTS("rs.co.ast.aspen.gui.module.securityevents"),
        LOGIN("rs.co.ast.aspen.gui.module.login"),
        JODATIME("rs.co.ast.aspen.lib.module.jodatime"),
        VID3D("rs.co.ast.aspen.gui.module.vis.3d"),
        VIS_ENGINE("rs.co.ast.aspen.core.module.vis.engine"),
        FASTINFOSET("rs.co.ast.aspen.lib.module.fastinfoset"),
        CXF("rs.co.ast.aspen.lib.module.cxf"),
        PRSEDITOR("rs.co.ast.aspen.gui.module.prseditor"),
        JACKSON("rs.co.ast.aspen.lib.module.jackson"),
        CONSOLE("rs.co.ast.aspen.console.branding"),
        SCRIPTEDITOR("rs.co.ast.aspen.gui.module.scripteditor"),
        APIMANAGER("rs.co.ast.aspen.gui.module.centralized.api.manager"),
        RSYNTAX("rs.co.ast.aspen.lib.module.rsyntaxtextarea"),
        NOTIFICATIONS("rs.co.ast.aspen.gui.module.notifications"),
        API_INTERFACE("rs.co.ast.aspen.core.module.api.service.interface"),
        APACHE_COMMONS("rs.co.ast.aspen.lib.module.apachecommons"),
        VISUALIZATION("rs.co.ast.aspen.gui.module.visualization"),
        JFREECHARTS("rs.co.ast.aspen.lib.module.jfreechart");

        private String codeName;

        private CodeName(String codeName) {
            this.codeName = codeName;
        }

        public String getCodeName() {
            return this.codeName;
        }
    }
}

