/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.centralized.api.manager.account;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.EnumSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXDatePicker;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import rs.co.ast.aspen.api.service.ApiAccount;
import rs.co.ast.aspen.api.service.ApiErrorMessage;
import rs.co.ast.aspen.api.service.ApiKeyResponse;
import rs.co.ast.aspen.api.service.ApiResponse;
import rs.co.ast.aspen.api.service.ApiRole;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ListAccountsResponse;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.UpdateAccountResponse;
import rs.co.ast.aspen.gui.module.centralized.api.manager.account.AccountsTableModel;
import rs.co.ast.aspen.gui.module.centralized.api.manager.account.AccountsTableRenderer;
import rs.co.ast.aspen.gui.module.centralized.api.manager.account.DefferedDocumentListener;
import rs.co.ast.aspen.gui.module.centralized.api.manager.account.NewAccountPanel;
import rs.co.ast.aspen.gui.module.centralized.api.manager.account.RolesListModel;

@TopComponent.Description(preferredID="CentralizedApiAccountManagerTopComponent", iconBase="user_green.png", persistenceType=2)
public final class CentralizedApiAccountManagerTopComponent
extends TopComponent {
    public static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);
    private static final Logger LOGGER = Logger.getLogger(CentralizedApiAccountManagerTopComponent.class.getName());
    private static final DateTimeFormatter dtf = ISODateTimeFormat.basicDateTime();
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private final RolesListModel listModelAvailable = new RolesListModel();
    private final RolesListModel listModelGranted = new RolesListModel();
    private final AccountsTableModel accountModel = new AccountsTableModel();
    private ApiAccount selectedAccount = null;
    private Dialog dialog;
    private boolean isEmailValid = true;
    private boolean isRoleValid;
    private int lastSelectedIndex = -1;
    private boolean abcSort = true;
    private JButton bCopyApiKey;
    private JButton bDelete;
    private JButton bGrantRole;
    private JButton bNew;
    private JButton bNewApiKey;
    private JButton bRename;
    private JButton bReset;
    private JButton bRevokeRole;
    private JButton bSave;
    private JCheckBox cbAccountEnabled;
    private JCheckBox cbCaseSensitiveKeyword;
    private JXDatePicker dpAccountApiKeyExpiration;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    private JLabel lAccountCreated;
    private JLabel lAccountEnabled;
    private JLabel lApiKey;
    private JLabel lApiKeyExpiration;
    private JList<ApiRole> lAvailableRoles;
    private JLabel lCreated;
    private JLabel lEmail;
    private JList<ApiRole> lGrantedRoles;
    private JXBusyLabel lLoading;
    private JLabel lName;
    private JMenuItem miCopy;
    private JPanel pLeft;
    private JPanel pRight;
    private JPanel pRolesContainer;
    private JTable tAccounts;
    private JTextField tfAccountApiKey;
    private JTextField tfAccountEmail;
    private JTextField tfAccountName;
    private JTextField tfKeywords;
    private JTextField tfQueryFilter;

    public CentralizedApiAccountManagerTopComponent() {
        LOGGER.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.APIMANAGER), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.APIMANAGER)));
        this.initComponents();
        this.setName(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CTL_CentralizedApiAccountManagerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"HINT_CentralizedApiAccountManagerTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.dragging_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.undocking_disabled", Boolean.TRUE);
        this.listModelAvailable.setRoles(ApiRole.values());
        this.lAvailableRoles.setModel(this.listModelAvailable);
        this.tfAccountApiKey.setEditable(false);
        this.lGrantedRoles.setModel(this.listModelGranted);
        this.tAccounts.setModel(this.accountModel);
        this.tAccounts.setDefaultRenderer(ApiAccount.class, new AccountsTableRenderer());
        this.tAccounts.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int selectedRow = CentralizedApiAccountManagerTopComponent.this.tAccounts.getSelectedRow();
                    selectedRow = CentralizedApiAccountManagerTopComponent.this.tAccounts.convertRowIndexToModel(selectedRow);
                    CentralizedApiAccountManagerTopComponent.this.selectedAccount = CentralizedApiAccountManagerTopComponent.this.accountModel.getAccountByRow(selectedRow);
                    CentralizedApiAccountManagerTopComponent.this.updateAccountDetails(CentralizedApiAccountManagerTopComponent.this.selectedAccount);
                }
            }
        });
        this.tAccounts.getTableHeader().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CentralizedApiAccountManagerTopComponent.this.accountModel.sortAccountsByName(CentralizedApiAccountManagerTopComponent.this.abcSort);
                CentralizedApiAccountManagerTopComponent.this.abcSort = !CentralizedApiAccountManagerTopComponent.this.abcSort;
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.cbAccountEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CentralizedApiAccountManagerTopComponent.this.selectedAccount != null) {
                    CentralizedApiAccountManagerTopComponent.this.selectedAccount.setEnabled(CentralizedApiAccountManagerTopComponent.this.cbAccountEnabled.isSelected());
                }
            }
        });
        this.tfAccountEmail.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkEmail();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkEmail();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkEmail();
            }

            private void checkEmail() {
                Matcher mat = VALID_EMAIL_ADDRESS_REGEX.matcher(CentralizedApiAccountManagerTopComponent.this.tfAccountEmail.getText());
                CentralizedApiAccountManagerTopComponent.this.isEmailValid = CentralizedApiAccountManagerTopComponent.this.tfAccountEmail.getText().isEmpty() ? true : mat.matches();
                if (CentralizedApiAccountManagerTopComponent.this.isEmailValid) {
                    CentralizedApiAccountManagerTopComponent.this.tfAccountEmail.setBorder(UIManager.getBorder("TextField.border"));
                } else {
                    CentralizedApiAccountManagerTopComponent.this.tfAccountEmail.setBorder(new LineBorder(Color.RED));
                }
                CentralizedApiAccountManagerTopComponent.this.tfAccountEmail.repaint();
            }
        });
        this.tfAccountApiKey.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    CentralizedApiAccountManagerTopComponent.this.jPopupMenu1.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.miCopy.addActionListener(e -> {
            StringSelection stringSelection = new StringSelection(this.tfAccountApiKey.getText());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        });
        final DefferedDocumentListener searchScriptActionListener = new DefferedDocumentListener(500, e -> this.accountModel.filterScripts(this.tfKeywords.getText(), this.cbCaseSensitiveKeyword.isSelected()), true);
        this.tfKeywords.getDocument().addDocumentListener(searchScriptActionListener);
        this.tfKeywords.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CentralizedApiAccountManagerTopComponent.this.tfKeywords.getText().equals(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.tfKeywords.text"))) {
                    CentralizedApiAccountManagerTopComponent.this.tfKeywords.setText("");
                    CentralizedApiAccountManagerTopComponent.this.tfKeywords.setForeground(Color.BLACK);
                }
                searchScriptActionListener.start();
            }

            @Override
            public void focusLost(FocusEvent e) {
                searchScriptActionListener.stop();
            }
        });
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.miCopy = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.pLeft = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tAccounts = new JTable();
        this.bNew = new JButton();
        this.bDelete = new JButton();
        this.bRename = new JButton();
        this.tfKeywords = new JTextField();
        this.cbCaseSensitiveKeyword = new JCheckBox();
        this.pRight = new JPanel();
        this.lName = new JLabel();
        this.lEmail = new JLabel();
        this.tfAccountEmail = new JTextField();
        this.lCreated = new JLabel();
        this.lAccountCreated = new JLabel();
        this.lApiKey = new JLabel();
        this.lApiKeyExpiration = new JLabel();
        this.dpAccountApiKeyExpiration = new JXDatePicker();
        this.cbAccountEnabled = new JCheckBox();
        this.lAccountEnabled = new JLabel();
        this.pRolesContainer = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lAvailableRoles = new JList();
        this.bGrantRole = new JButton();
        this.bRevokeRole = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.lGrantedRoles = new JList();
        this.bSave = new JButton();
        this.bReset = new JButton();
        this.lLoading = new JXBusyLabel();
        this.bNewApiKey = new JButton();
        this.bCopyApiKey = new JButton();
        this.tfAccountApiKey = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfQueryFilter = new JTextField();
        this.tfAccountName = new JTextField();
        Mnemonics.setLocalizedText((AbstractButton)this.miCopy, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.miCopy.text"));
        this.jPopupMenu1.add(this.miCopy);
        this.setMinimumSize(new Dimension(800, 501));
        this.jSplitPane1.setDividerLocation(270);
        this.jSplitPane1.setResizeWeight(0.2);
        this.tAccounts.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.tAccounts);
        Mnemonics.setLocalizedText((AbstractButton)this.bNew, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.bNew.text"));
        this.bNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiAccountManagerTopComponent.this.bNewActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bDelete, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.bDelete.text"));
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiAccountManagerTopComponent.this.bDeleteActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bRename, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.bRename.text"));
        this.bRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiAccountManagerTopComponent.this.bRenameActionPerformed(evt);
            }
        });
        this.tfKeywords.setForeground(Color.gray);
        this.tfKeywords.setText(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.tfKeywords.text"));
        this.tfKeywords.setToolTipText(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.tfKeywords.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCaseSensitiveKeyword, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.cbCaseSensitiveKeyword.text"));
        GroupLayout pLeftLayout = new GroupLayout(this.pLeft);
        this.pLeft.setLayout(pLeftLayout);
        pLeftLayout.setHorizontalGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(pLeftLayout.createSequentialGroup().addContainerGap().addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.tfKeywords, -2, 151, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCaseSensitiveKeyword).addGap(0, 0, Short.MAX_VALUE)).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.bNew, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bRename, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDelete, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        pLeftLayout.setVerticalGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLeftLayout.createSequentialGroup().addContainerGap().addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfKeywords, -2, -1, -2).addComponent(this.cbCaseSensitiveKeyword)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 502, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bNew).addComponent(this.bDelete).addComponent(this.bRename)).addGap(6, 6, 6)));
        this.jSplitPane1.setLeftComponent(this.pLeft);
        this.lName.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lName, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.lName.text"));
        this.lEmail.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lEmail, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.lEmail.text"));
        this.tfAccountEmail.setText(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.tfAccountEmail.text"));
        this.lCreated.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lCreated, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.lCreated.text"));
        Mnemonics.setLocalizedText((JLabel)this.lAccountCreated, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.lAccountCreated.text"));
        this.lAccountCreated.setBorder(BorderFactory.createEtchedBorder());
        this.lAccountCreated.setMaximumSize(new Dimension(4, 19));
        this.lAccountCreated.setMinimumSize(new Dimension(4, 19));
        this.lAccountCreated.setPreferredSize(new Dimension(4, 19));
        this.lApiKey.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lApiKey, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.lApiKey.text"));
        Mnemonics.setLocalizedText((JLabel)this.lApiKeyExpiration, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.lApiKeyExpiration.text"));
        this.dpAccountApiKeyExpiration.setMaximumSize(new Dimension(145, 19));
        this.dpAccountApiKeyExpiration.setMinimumSize(new Dimension(145, 19));
        this.dpAccountApiKeyExpiration.setPreferredSize(new Dimension(145, 19));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAccountEnabled, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.cbAccountEnabled.text"));
        this.cbAccountEnabled.setToolTipText(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.cbAccountEnabled.toolTipText"));
        this.cbAccountEnabled.setBorder(null);
        this.cbAccountEnabled.setHorizontalTextPosition(2);
        this.cbAccountEnabled.setIconTextGap(0);
        this.cbAccountEnabled.setMargin(new Insets(2, 0, 2, 2));
        this.lAccountEnabled.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lAccountEnabled, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.lAccountEnabled.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.jLabel2.text"));
        this.lAvailableRoles.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.lAvailableRoles);
        this.bGrantRole.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_right.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bGrantRole, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.bGrantRole.text"));
        this.bGrantRole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiAccountManagerTopComponent.this.bGrantRoleActionPerformed(evt);
            }
        });
        this.bRevokeRole.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_left.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRevokeRole, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.bRevokeRole.text"));
        this.bRevokeRole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiAccountManagerTopComponent.this.bRevokeRoleActionPerformed(evt);
            }
        });
        this.lGrantedRoles.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.lGrantedRoles);
        GroupLayout pRolesContainerLayout = new GroupLayout(this.pRolesContainer);
        this.pRolesContainer.setLayout(pRolesContainerLayout);
        pRolesContainerLayout.setHorizontalGroup(pRolesContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRolesContainerLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(pRolesContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRolesContainerLayout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 212, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRolesContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bGrantRole).addComponent(this.bRevokeRole))).addComponent(this.jLabel2)).addGap(6, 6, 6).addGroup(pRolesContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jScrollPane3, -1, 260, Short.MAX_VALUE))));
        pRolesContainerLayout.setVerticalGroup(pRolesContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRolesContainerLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(pRolesContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRolesContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRolesContainerLayout.createSequentialGroup().addComponent(this.bGrantRole).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bRevokeRole)).addComponent(this.jScrollPane2, -2, 236, -2).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -2, 236, -2))));
        Mnemonics.setLocalizedText((AbstractButton)this.bSave, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.bSave.text"));
        this.bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiAccountManagerTopComponent.this.bSaveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bReset, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.bReset.text"));
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiAccountManagerTopComponent.this.bResetActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.lLoading.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bNewApiKey, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.bNewApiKey.text"));
        this.bNewApiKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiAccountManagerTopComponent.this.bNewApiKeyActionPerformed(evt);
            }
        });
        this.bCopyApiKey.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/copy.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bCopyApiKey, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.bCopyApiKey.text"));
        this.bCopyApiKey.setBorder(null);
        this.bCopyApiKey.setContentAreaFilled(false);
        this.bCopyApiKey.setCursor(new Cursor(12));
        this.bCopyApiKey.setMargin(new Insets(0, 0, 0, 0));
        this.bCopyApiKey.setMaximumSize(new Dimension(19, 19));
        this.bCopyApiKey.setMinimumSize(new Dimension(19, 19));
        this.bCopyApiKey.setPreferredSize(new Dimension(19, 19));
        this.bCopyApiKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiAccountManagerTopComponent.this.bCopyApiKeyActionPerformed(evt);
            }
        });
        this.tfAccountApiKey.setText(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.tfAccountApiKey.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.jLabel1.text"));
        this.tfQueryFilter.setText(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.tfQueryFilter.text"));
        this.tfQueryFilter.setToolTipText(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.tfQueryFilter.toolTipText"));
        this.tfAccountName.setText(NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.tfAccountName.text"));
        GroupLayout pRightLayout = new GroupLayout(this.pRight);
        this.pRight.setLayout(pRightLayout);
        pRightLayout.setHorizontalGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRightLayout.createSequentialGroup().addContainerGap().addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pRolesContainer, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pRightLayout.createSequentialGroup().addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lAccountEnabled, -2, 132, -2).addComponent(this.lApiKey, -2, 132, -2).addComponent(this.lCreated, -2, 132, -2).addComponent(this.lEmail, -2, 132, -2).addComponent(this.lName, -2, 132, -2).addComponent(this.lApiKeyExpiration, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lAccountCreated, -1, -1, Short.MAX_VALUE).addComponent(this.tfAccountEmail).addComponent(this.cbAccountEnabled, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.dpAccountApiKeyExpiration, -1, -1, Short.MAX_VALUE).addGroup(pRightLayout.createSequentialGroup().addComponent(this.tfAccountApiKey).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bCopyApiKey, -2, -1, -2)).addComponent(this.tfQueryFilter).addComponent(this.tfAccountName))).addGroup(pRightLayout.createSequentialGroup().addComponent(this.bSave).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bReset).addGap(18, 18, 18).addComponent(this.bNewApiKey).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.lLoading, -2, -1, -2))).addContainerGap()));
        pRightLayout.setVerticalGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRightLayout.createSequentialGroup().addGap(11, 11, 11).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lName, -2, 15, -2).addComponent(this.tfAccountName, -2, -1, -2)).addGap(18, 18, 18).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfAccountEmail, -2, -1, -2).addComponent(this.lEmail)).addGap(18, 18, 18).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lCreated).addComponent(this.lAccountCreated, -2, 19, -2)).addGap(18, 18, 18).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lApiKey).addComponent(this.tfAccountApiKey, -2, -1, -2)).addComponent(this.bCopyApiKey, -2, -1, -2)).addGap(18, 18, 18).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lApiKeyExpiration).addComponent((Component)this.dpAccountApiKeyExpiration, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfQueryFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbAccountEnabled, -1, -1, Short.MAX_VALUE).addComponent(this.lAccountEnabled)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pRolesContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bSave).addComponent(this.bReset).addComponent((Component)this.lLoading, -2, -1, -2).addComponent(this.bNewApiKey)).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.pRight);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
    }

    private void bGrantRoleActionPerformed(ActionEvent evt) {
        ApiRole selectedRole;
        if (this.selectedAccount != null && (selectedRole = this.lAvailableRoles.getSelectedValue()) != null) {
            this.listModelAvailable.removeRole(selectedRole);
            this.listModelGranted.addRole(selectedRole);
            if (!this.listModelGranted.getRoles().isEmpty()) {
                this.isRoleValid = true;
                this.lGrantedRoles.setBorder(UIManager.getBorder("TextField.border"));
            } else {
                this.isRoleValid = false;
                this.lGrantedRoles.setBorder(new LineBorder(Color.RED));
            }
            this.lGrantedRoles.repaint();
        }
    }

    private void bRevokeRoleActionPerformed(ActionEvent evt) {
        ApiRole selectedRole;
        if (this.selectedAccount != null && (selectedRole = this.lGrantedRoles.getSelectedValue()) != null) {
            this.listModelGranted.removeRole(selectedRole);
            this.listModelAvailable.addRole(selectedRole);
            if (!this.listModelGranted.getRoles().isEmpty()) {
                this.isRoleValid = true;
                this.lGrantedRoles.setBorder(UIManager.getBorder("TextField.border"));
            } else {
                this.isRoleValid = false;
                this.lGrantedRoles.setBorder(new LineBorder(Color.RED));
            }
            this.lGrantedRoles.repaint();
        }
    }

    private void bResetActionPerformed(ActionEvent evt) {
        this.updateAccountDetails(this.selectedAccount);
    }

    private void bSaveActionPerformed(ActionEvent evt) {
        if (this.isEmailValid && this.isRoleValid && this.selectedAccount != null) {
            this.toggleLoading(true);
            SwingWorker<UpdateAccountResponse, Void> worker = new SwingWorker<UpdateAccountResponse, Void>(){

                @Override
                protected UpdateAccountResponse doInBackground() throws Exception {
                    if (CentralizedApiAccountManagerTopComponent.this.dpAccountApiKeyExpiration.getDate() == null) {
                        Date date = new Date(0L);
                        CentralizedApiAccountManagerTopComponent.this.selectedAccount.setApiKeyExpiry(date.getTime());
                    } else {
                        CentralizedApiAccountManagerTopComponent.this.selectedAccount.setApiKeyExpiry(CentralizedApiAccountManagerTopComponent.this.dpAccountApiKeyExpiration.getDate().getTime());
                    }
                    CentralizedApiAccountManagerTopComponent.this.selectedAccount.setName(CentralizedApiAccountManagerTopComponent.this.tfAccountName.getText());
                    CentralizedApiAccountManagerTopComponent.this.selectedAccount.setEmail(CentralizedApiAccountManagerTopComponent.this.tfAccountEmail.getText());
                    CentralizedApiAccountManagerTopComponent.this.selectedAccount.setQueryFilter(CentralizedApiAccountManagerTopComponent.this.tfQueryFilter.getText());
                    CentralizedApiAccountManagerTopComponent.this.selectedAccount.getRoles().clear();
                    CentralizedApiAccountManagerTopComponent.this.selectedAccount.getRoles().addAll(CentralizedApiAccountManagerTopComponent.this.listModelGranted.getRoles());
                    return CentralizedApiAccountManagerTopComponent.this.apiService.apiUpdateAccount(CentralizedApiAccountManagerTopComponent.this.selectedAccount.getId(), CentralizedApiAccountManagerTopComponent.this.selectedAccount);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    try {
                        UpdateAccountResponse response = (UpdateAccountResponse)this.get();
                        if (response.isSuccess()) {
                            new Updater().execute();
                        } else {
                            ApiErrorMessage apiError = response.getErrorMessage();
                            LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                        }
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        CentralizedApiAccountManagerTopComponent.this.toggleLoading(false);
                    }
                }
            };
            worker.execute();
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.IncorrectInput.message"), NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.IncorrectInput.title"), 0);
        }
    }

    private void bNewActionPerformed(ActionEvent evt) {
        final NewAccountPanel panel = new NewAccountPanel();
        final JButton bOK = new JButton("OK");
        DialogDescriptor des = new DialogDescriptor((Object)panel, NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"NewAccountPanel.message.title"), false, new Object[]{bOK, DialogDescriptor.CANCEL_OPTION}, (Object)bOK, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(bOK)) {
                    if (panel.isEmailValid() && panel.isNameValid() && panel.isRoleValid()) {
                        CentralizedApiAccountManagerTopComponent.this.toggleLoading(true);
                        SwingWorker<ApiKeyResponse, Void> worker = new SwingWorker<ApiKeyResponse, Void>(){

                            @Override
                            protected ApiKeyResponse doInBackground() throws Exception {
                                return CentralizedApiAccountManagerTopComponent.this.apiService.apiCreateAccount(panel.getAccount());
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void done() {
                                try {
                                    ApiKeyResponse response = (ApiKeyResponse)this.get();
                                    if (response.isSuccess()) {
                                        CentralizedApiAccountManagerTopComponent.this.lastSelectedIndex = -1;
                                        new Updater().execute();
                                    } else {
                                        ApiErrorMessage apiError = response.getErrorMessage();
                                        LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                                        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                                    }
                                }
                                catch (InterruptedException | ExecutionException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                finally {
                                    CentralizedApiAccountManagerTopComponent.this.toggleLoading(false);
                                    CentralizedApiAccountManagerTopComponent.this.dialog.setVisible(false);
                                    CentralizedApiAccountManagerTopComponent.this.dialog.dispose();
                                }
                            }
                        };
                        worker.execute();
                    } else {
                        String faildMsg = NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.IncorrectInput.message");
                        JOptionPane.showMessageDialog(panel, faildMsg, "Error", 0);
                    }
                }
            }
        });
        this.dialog = DialogDisplayer.getDefault().createDialog(des);
        this.dialog.setVisible(true);
    }

    private void bDeleteActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog((Component)((Object)this), NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"AccountDelete.message.message"), NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"AccountDelete.message.title"), 2);
        if (result == 0 && this.selectedAccount != null) {
            this.toggleLoading(true);
            SwingWorker<ApiResponse, Void> worker = new SwingWorker<ApiResponse, Void>(){

                @Override
                protected ApiResponse doInBackground() throws Exception {
                    return CentralizedApiAccountManagerTopComponent.this.apiService.apiDeleteAccount(CentralizedApiAccountManagerTopComponent.this.selectedAccount.getId());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    try {
                        ApiResponse response = (ApiResponse)this.get();
                        if (response.isSuccess()) {
                            CentralizedApiAccountManagerTopComponent.this.accountModel.removeAccount(CentralizedApiAccountManagerTopComponent.this.tAccounts.getSelectedRow());
                            CentralizedApiAccountManagerTopComponent.this.lastSelectedIndex = -1;
                            CentralizedApiAccountManagerTopComponent.this.selectedAccount = null;
                            new Updater().execute();
                        } else {
                            ApiErrorMessage apiError = response.getErrorMessage();
                            LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                        }
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        CentralizedApiAccountManagerTopComponent.this.toggleLoading(false);
                    }
                }
            };
            worker.execute();
        }
    }

    private void bNewApiKeyActionPerformed(ActionEvent evt) {
        this.toggleLoading(true);
        if (this.selectedAccount != null) {
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.NewApiKeyNotifyDescriptor.message"), NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"CentralizedApiAccountManagerTopComponent.NewApiKeyNotifyDescriptor.title"), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                SwingWorker<ApiKeyResponse, Void> worker = new SwingWorker<ApiKeyResponse, Void>(){

                    @Override
                    protected ApiKeyResponse doInBackground() throws Exception {
                        return CentralizedApiAccountManagerTopComponent.this.apiService.apiGenerateNewApiKeyForAccount(CentralizedApiAccountManagerTopComponent.this.selectedAccount.getId());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void done() {
                        try {
                            ApiKeyResponse response = (ApiKeyResponse)this.get();
                            if (response.isSuccess()) {
                                new Updater().execute();
                            } else {
                                ApiErrorMessage apiError = response.getErrorMessage();
                                LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                            }
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        finally {
                            CentralizedApiAccountManagerTopComponent.this.toggleLoading(false);
                        }
                    }
                };
                worker.execute();
            }
        }
    }

    private void bRenameActionPerformed(ActionEvent evt) {
        String name;
        this.toggleLoading(true);
        Object showInputDialog = JOptionPane.showInputDialog((Component)((Object)this), NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"AccountRenameAction.message.message"), NbBundle.getMessage(CentralizedApiAccountManagerTopComponent.class, (String)"AccountRenameAction.message.title"), -1, null, null, this.selectedAccount.getName());
        if (showInputDialog != null && (name = showInputDialog.toString()) != null && !name.isEmpty() && this.selectedAccount != null) {
            SwingWorker<ApiResponse, Void> worker = new SwingWorker<ApiResponse, Void>(){

                @Override
                protected ApiResponse doInBackground() throws Exception {
                    return CentralizedApiAccountManagerTopComponent.this.apiService.apiRenameAccount(CentralizedApiAccountManagerTopComponent.this.selectedAccount.getId(), name);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    try {
                        ApiResponse response = (ApiResponse)this.get();
                        if (response.isSuccess()) {
                            new Updater().execute();
                        } else {
                            ApiErrorMessage apiError = response.getErrorMessage();
                            LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                        }
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        CentralizedApiAccountManagerTopComponent.this.toggleLoading(false);
                    }
                }
            };
            worker.execute();
        }
    }

    private void bCopyApiKeyActionPerformed(ActionEvent evt) {
        StringSelection selection = new StringSelection(this.tfAccountApiKey.getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public void componentOpened() {
        new Updater().execute();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void updateAccountDetails(ApiAccount account) {
        if (account != null) {
            this.tfAccountName.setText(account.getName());
            this.tfAccountEmail.setText(account.getEmail());
            this.lAccountCreated.setText(dtf.print(account.getCreated()));
            this.tfAccountApiKey.setText(account.getApiKey());
            this.tfQueryFilter.setText(account.getQueryFilter());
            this.dpAccountApiKeyExpiration.setDate(new Date(account.getApiKeyExpiry()));
            this.cbAccountEnabled.setSelected(account.isEnabled());
            EnumSet<Object> granted = account.getRoles().isEmpty() ? EnumSet.noneOf(ApiRole.class) : EnumSet.copyOf(account.getRoles());
            this.listModelGranted.setRoles(granted.toArray(new ApiRole[0]));
            if (!account.getRoles().isEmpty()) {
                this.isRoleValid = true;
                this.lGrantedRoles.setBorder(UIManager.getBorder("TextField.border"));
            } else {
                this.isRoleValid = false;
                this.lGrantedRoles.setBorder(new LineBorder(Color.RED));
            }
            this.lGrantedRoles.repaint();
            this.listModelAvailable.setRoles(EnumSet.complementOf(granted).toArray(new ApiRole[0]));
        }
    }

    private void cleanFields() {
        this.tfAccountName.setText("");
        this.tfAccountEmail.setText("");
        this.lAccountCreated.setText("");
        this.tfAccountApiKey.setText("");
        this.tfQueryFilter.setText("");
        this.dpAccountApiKeyExpiration.setDate(null);
        this.cbAccountEnabled.setSelected(false);
        this.listModelAvailable.setRoles(ApiRole.values());
        this.listModelGranted.clear();
    }

    private void toggleLoading(boolean init) {
        if (init) {
            this.bGrantRole.setEnabled(false);
            this.bRevokeRole.setEnabled(false);
            this.bReset.setEnabled(false);
            this.bSave.setEnabled(false);
            this.tfAccountEmail.setEditable(false);
            this.dpAccountApiKeyExpiration.setEditable(false);
            this.lLoading.setBusy(true);
        } else {
            this.bGrantRole.setEnabled(true);
            this.bRevokeRole.setEnabled(true);
            this.bReset.setEnabled(true);
            this.bSave.setEnabled(true);
            this.tfAccountEmail.setEditable(true);
            this.dpAccountApiKeyExpiration.setEditable(true);
            this.lLoading.setBusy(false);
        }
    }

    public class Updater
    extends SwingWorker<ListAccountsResponse, Void> {
        @Override
        protected ListAccountsResponse doInBackground() throws Exception {
            CentralizedApiAccountManagerTopComponent.this.toggleLoading(true);
            try {
                return CentralizedApiAccountManagerTopComponent.this.apiService.apiGetAllAccounts();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                ListAccountsResponse response = (ListAccountsResponse)this.get();
                if (response.isSuccess()) {
                    CentralizedApiAccountManagerTopComponent.this.lastSelectedIndex = CentralizedApiAccountManagerTopComponent.this.tAccounts.getSelectedRow();
                    CentralizedApiAccountManagerTopComponent.this.accountModel.setData(response.getAccounts());
                    if (CentralizedApiAccountManagerTopComponent.this.lastSelectedIndex != -1) {
                        CentralizedApiAccountManagerTopComponent.this.tAccounts.getSelectionModel().addSelectionInterval(CentralizedApiAccountManagerTopComponent.this.lastSelectedIndex, CentralizedApiAccountManagerTopComponent.this.lastSelectedIndex);
                        CentralizedApiAccountManagerTopComponent.this.selectedAccount = CentralizedApiAccountManagerTopComponent.this.accountModel.getAccountByRow(CentralizedApiAccountManagerTopComponent.this.lastSelectedIndex);
                    } else {
                        CentralizedApiAccountManagerTopComponent.this.cleanFields();
                    }
                } else {
                    ApiErrorMessage apiError = response.getErrorMessage();
                    LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                CentralizedApiAccountManagerTopComponent.this.toggleLoading(false);
            }
        }
    }
}

