/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.login;

import com.github.zafarkhaja.semver.Version;

public class CompatibilityCheck {
    public static CompatibilityStatus checkVersionCompatibility(String serverApiVersion, String apiInterfaceVersion) {
        if (serverApiVersion.equals("UNKNOWN") || apiInterfaceVersion.isEmpty()) {
            return new CompatibilityStatus(true, false, false);
        }
        Version serverApi = Version.valueOf((String)serverApiVersion);
        Version apiInterface = Version.valueOf((String)apiInterfaceVersion);
        if (serverApi.getMajorVersion() > apiInterface.getMajorVersion() || serverApi.getMajorVersion() < apiInterface.getMajorVersion()) {
            if (serverApi.getMajorVersion() > apiInterface.getMajorVersion()) {
                return new CompatibilityStatus(false, true, false);
            }
            return new CompatibilityStatus(false, false, true);
        }
        if (serverApi.getMinorVersion() > apiInterface.getMinorVersion() || serverApi.getMinorVersion() < apiInterface.getMinorVersion()) {
            if (serverApi.getMinorVersion() > apiInterface.getMinorVersion()) {
                return new CompatibilityStatus(false, true, false);
            }
            return new CompatibilityStatus(false, false, true);
        }
        return new CompatibilityStatus(true, false, false);
    }

    static class CompatibilityStatus {
        boolean compatible;
        boolean updateConsole;
        boolean updateServer;

        public CompatibilityStatus(boolean compatible, boolean updateConsole, boolean updateServer) {
            this.compatible = compatible;
            this.updateConsole = updateConsole;
            this.updateServer = updateServer;
        }

        public boolean isCompatible() {
            return this.compatible;
        }

        public boolean isUpdateConsole() {
            return this.updateConsole;
        }

        public boolean isUpdateServer() {
            return this.updateServer;
        }
    }
}

