/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment.util;

import com.jme3.environment.util.EnvMapUtils;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.texture.Image;
import com.jme3.texture.TextureCubeMap;
import com.jme3.texture.image.DefaultImageRaster;
import com.jme3.texture.image.MipMapImageRaster;
import com.jme3.util.BufferUtils;

public class CubeMapWrapper {
    private MipMapImageRaster mipMapRaster;
    private final DefaultImageRaster raster;
    private int[] sizes;
    private final Vector2f uvs = new Vector2f();
    private final Image image;
    private final ColorRGBA tmpColor = new ColorRGBA();

    public CubeMapWrapper(TextureCubeMap cubeMap) {
        this.image = cubeMap.getImage();
        if (this.image.hasMipmaps()) {
            int nbMipMaps = this.image.getMipMapSizes().length;
            this.sizes = new int[nbMipMaps];
            this.mipMapRaster = new MipMapImageRaster(this.image, 0);
            for (int i = 0; i < nbMipMaps; ++i) {
                this.sizes[i] = Math.max(1, this.image.getWidth() >> i);
            }
        } else {
            this.sizes = new int[1];
            this.sizes[0] = this.image.getWidth();
        }
        this.raster = new DefaultImageRaster(this.image, 0, 0, false);
    }

    public ColorRGBA getPixel(Vector3f vector, ColorRGBA store) {
        if (store == null) {
            store = new ColorRGBA();
        }
        int face = EnvMapUtils.getCubemapFaceTexCoordFromVector(vector, this.sizes[0], this.uvs, EnvMapUtils.FixSeamsMethod.Stretch);
        this.raster.setSlice(face);
        return this.raster.getPixel((int)this.uvs.x, (int)this.uvs.y, store);
    }

    public ColorRGBA getPixel(Vector3f vector, float mipLevel, ColorRGBA store) {
        if (this.mipMapRaster == null) {
            throw new IllegalArgumentException("This cube map has no mip maps");
        }
        if (store == null) {
            store = new ColorRGBA();
        }
        int lowerMipLevel = (int)mipLevel;
        int higherMipLevel = (int)FastMath.ceil(mipLevel);
        float ratio = mipLevel - (float)lowerMipLevel;
        int face = EnvMapUtils.getCubemapFaceTexCoordFromVector(vector, this.sizes[lowerMipLevel], this.uvs, EnvMapUtils.FixSeamsMethod.Stretch);
        this.mipMapRaster.setSlice(face);
        this.mipMapRaster.setMipLevel(lowerMipLevel);
        this.mipMapRaster.getPixel((int)this.uvs.x, (int)this.uvs.y, store);
        face = EnvMapUtils.getCubemapFaceTexCoordFromVector(vector, this.sizes[higherMipLevel], this.uvs, EnvMapUtils.FixSeamsMethod.Stretch);
        this.mipMapRaster.setSlice(face);
        this.mipMapRaster.setMipLevel(higherMipLevel);
        this.mipMapRaster.getPixel((int)this.uvs.x, (int)this.uvs.y, this.tmpColor);
        store.r = FastMath.interpolateLinear(ratio, store.r, this.tmpColor.r);
        store.g = FastMath.interpolateLinear(ratio, store.g, this.tmpColor.g);
        store.b = FastMath.interpolateLinear(ratio, store.b, this.tmpColor.b);
        store.a = FastMath.interpolateLinear(ratio, store.a, this.tmpColor.a);
        return store;
    }

    public ColorRGBA getPixel(int x, int y, int face, ColorRGBA store) {
        if (store == null) {
            store = new ColorRGBA();
        }
        this.raster.setSlice(face);
        return this.raster.getPixel(x, y, store);
    }

    public ColorRGBA getPixel(int x, int y, int face, int mipLevel, ColorRGBA store) {
        if (this.mipMapRaster == null) {
            throw new IllegalArgumentException("This cube map has no mip maps");
        }
        if (store == null) {
            store = new ColorRGBA();
        }
        this.mipMapRaster.setSlice(face);
        this.mipMapRaster.setMipLevel(mipLevel);
        return this.mipMapRaster.getPixel(x, y, store);
    }

    public void setPixel(Vector3f vector, ColorRGBA color) {
        int face = EnvMapUtils.getCubemapFaceTexCoordFromVector(vector, this.sizes[0], this.uvs, EnvMapUtils.FixSeamsMethod.Stretch);
        this.raster.setSlice(face);
        this.raster.setPixel((int)this.uvs.x, (int)this.uvs.y, color);
    }

    public void setPixel(Vector3f vector, int mipLevel, ColorRGBA color) {
        if (this.mipMapRaster == null) {
            throw new IllegalArgumentException("This cube map has no mip maps");
        }
        int face = EnvMapUtils.getCubemapFaceTexCoordFromVector(vector, this.sizes[mipLevel], this.uvs, EnvMapUtils.FixSeamsMethod.Stretch);
        this.mipMapRaster.setSlice(face);
        this.mipMapRaster.setMipLevel(mipLevel);
        this.mipMapRaster.setPixel((int)this.uvs.x, (int)this.uvs.y, color);
    }

    public void setPixel(int x, int y, int face, ColorRGBA color) {
        this.raster.setSlice(face);
        this.raster.setPixel(x, y, color);
    }

    public void setPixel(int x, int y, int face, int mipLevel, ColorRGBA color) {
        if (this.mipMapRaster == null) {
            throw new IllegalArgumentException("This cube map has no mip maps");
        }
        this.mipMapRaster.setSlice(face);
        this.mipMapRaster.setMipLevel(mipLevel);
        this.mipMapRaster.setPixel(x, y, color);
    }

    public void initMipMaps(int nbMipMaps) {
        int i;
        int maxMipMap = (int)(Math.log(this.image.getWidth()) / Math.log(2.0) + 1.0);
        if (nbMipMaps > maxMipMap) {
            throw new IllegalArgumentException("Max mip map number for a " + this.image.getWidth() + "x" + this.image.getHeight() + " cube map is " + maxMipMap);
        }
        this.sizes = new int[nbMipMaps];
        int totalSize = 0;
        for (i = 0; i < nbMipMaps; ++i) {
            int size = (int)FastMath.pow(2.0f, maxMipMap - 1 - i);
            this.sizes[i] = size * size * this.image.getFormat().getBitsPerPixel() / 8;
            totalSize += this.sizes[i];
        }
        this.image.setMipMapSizes(this.sizes);
        this.image.getData().clear();
        for (i = 0; i < 6; ++i) {
            this.image.addData(BufferUtils.createByteBuffer(totalSize));
        }
        this.mipMapRaster = new MipMapImageRaster(this.image, 0);
    }
}

