/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.textures.generating.TextureGeneratorMusgrave;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class NoiseGenerator {
    private static final Logger LOGGER = Logger.getLogger(NoiseGenerator.class.getName());
    protected static final int TEX_PLASTIC = 0;
    protected static final int TEX_WALLIN = 1;
    protected static final int TEX_WALLOUT = 2;
    protected static final int TEX_MFRACTAL = 0;
    protected static final int TEX_RIDGEDMF = 1;
    protected static final int TEX_HYBRIDMF = 2;
    protected static final int TEX_FBM = 3;
    protected static final int TEX_HTERRAIN = 4;
    protected static final int KEY_LINEAR = 0;
    protected static final int KEY_CARDINAL = 1;
    protected static final int KEY_BSPLINE = 2;
    protected static float[] hashpntf;
    protected static short[] hash;
    protected static float[] hashvectf;
    protected static short[] p;
    protected static float[][] g;
    protected static Map<Integer, NoiseFunction> noiseFunctions;
    protected static Map<Integer, DistanceFunction> distanceFunctions;
    private static DistanceFunction NATURAL_DISTANCE_FUNCTION;
    protected static Map<Integer, MusgraveFunction> musgraveFunctions;

    public NoiseGenerator() {
        LOGGER.fine("Loading noise constants.");
        InputStream is = NoiseGenerator.class.getResourceAsStream("noiseconstants.dat");
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            hashpntf = (float[])ois.readObject();
            hash = (short[])ois.readObject();
            hashvectf = (float[])ois.readObject();
            p = (short[])ois.readObject();
            g = (float[][])ois.readObject();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException e) {
            assert (false) : "Constants' classes should be arrays of primitive types, so they are ALWAYS known!";
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage());
                }
            }
        }
    }

    static {
        noiseFunctions = new HashMap<Integer, NoiseFunction>();
        noiseFunctions.put(0, new NoiseFunction(){

            @Override
            public float execute(float x, float y, float z) {
                return NoiseFunctions.originalBlenderNoise(x, y, z);
            }

            @Override
            public float executeSigned(float x, float y, float z) {
                return 2.0f * NoiseFunctions.originalBlenderNoise(x, y, z) - 1.0f;
            }
        });
        noiseFunctions.put(1, new NoiseFunction(){

            @Override
            public float execute(float x, float y, float z) {
                return 0.5f + 0.5f * NoiseFunctions.noise3Perlin(x, y, z);
            }

            @Override
            public float executeSigned(float x, float y, float z) {
                return NoiseFunctions.noise3Perlin(x, y, z);
            }
        });
        noiseFunctions.put(2, new NoiseFunction(){

            @Override
            public float execute(float x, float y, float z) {
                return 0.5f + 0.5f * NoiseFunctions.newPerlin(x, y, z);
            }

            @Override
            public float executeSigned(float x, float y, float z) {
                return this.execute(x, y, z);
            }
        });
        noiseFunctions.put(3, new NoiseFunction(){
            private final float[] da = new float[4];
            private final float[] pa = new float[12];

            @Override
            public float execute(float x, float y, float z) {
                NoiseFunctions.voronoi(x, y, z, this.da, this.pa, 1.0f, NATURAL_DISTANCE_FUNCTION);
                return this.da[0];
            }

            @Override
            public float executeSigned(float x, float y, float z) {
                NoiseFunctions.voronoi(x, y, z, this.da, this.pa, 1.0f, NATURAL_DISTANCE_FUNCTION);
                return 2.0f * this.da[0] - 1.0f;
            }
        });
        noiseFunctions.put(4, new NoiseFunction(){
            private final float[] da = new float[4];
            private final float[] pa = new float[12];

            @Override
            public float execute(float x, float y, float z) {
                NoiseFunctions.voronoi(x, y, z, this.da, this.pa, 1.0f, NATURAL_DISTANCE_FUNCTION);
                return this.da[1];
            }

            @Override
            public float executeSigned(float x, float y, float z) {
                NoiseFunctions.voronoi(x, y, z, this.da, this.pa, 1.0f, NATURAL_DISTANCE_FUNCTION);
                return 2.0f * this.da[1] - 1.0f;
            }
        });
        noiseFunctions.put(5, new NoiseFunction(){
            private final float[] da = new float[4];
            private final float[] pa = new float[12];

            @Override
            public float execute(float x, float y, float z) {
                NoiseFunctions.voronoi(x, y, z, this.da, this.pa, 1.0f, NATURAL_DISTANCE_FUNCTION);
                return this.da[2];
            }

            @Override
            public float executeSigned(float x, float y, float z) {
                NoiseFunctions.voronoi(x, y, z, this.da, this.pa, 1.0f, NATURAL_DISTANCE_FUNCTION);
                return 2.0f * this.da[2] - 1.0f;
            }
        });
        noiseFunctions.put(6, new NoiseFunction(){
            private final float[] da = new float[4];
            private final float[] pa = new float[12];

            @Override
            public float execute(float x, float y, float z) {
                NoiseFunctions.voronoi(x, y, z, this.da, this.pa, 1.0f, NATURAL_DISTANCE_FUNCTION);
                return this.da[3];
            }

            @Override
            public float executeSigned(float x, float y, float z) {
                NoiseFunctions.voronoi(x, y, z, this.da, this.pa, 1.0f, NATURAL_DISTANCE_FUNCTION);
                return 2.0f * this.da[3] - 1.0f;
            }
        });
        noiseFunctions.put(7, new NoiseFunction(){
            private final float[] da = new float[4];
            private final float[] pa = new float[12];

            @Override
            public float execute(float x, float y, float z) {
                NoiseFunctions.voronoi(x, y, z, this.da, this.pa, 1.0f, NATURAL_DISTANCE_FUNCTION);
                return this.da[1] - this.da[0];
            }

            @Override
            public float executeSigned(float x, float y, float z) {
                NoiseFunctions.voronoi(x, y, z, this.da, this.pa, 1.0f, NATURAL_DISTANCE_FUNCTION);
                return 2.0f * (this.da[1] - this.da[0]) - 1.0f;
            }
        });
        noiseFunctions.put(8, new NoiseFunction(){
            private final NoiseFunction voronoiF1F2NoiseFunction = noiseFunctions.get(7);

            @Override
            public float execute(float x, float y, float z) {
                float t = 10.0f * this.voronoiF1F2NoiseFunction.execute(x, y, z);
                return t > 1.0f ? 1.0f : t;
            }

            @Override
            public float executeSigned(float x, float y, float z) {
                float t = 10.0f * this.voronoiF1F2NoiseFunction.execute(x, y, z);
                return t > 1.0f ? 1.0f : 2.0f * t - 1.0f;
            }
        });
        noiseFunctions.put(14, new NoiseFunction(){

            @Override
            public float execute(float x, float y, float z) {
                int xi = (int)FastMath.floor((float)x);
                int yi = (int)FastMath.floor((float)y);
                int zi = (int)FastMath.floor((float)z);
                long n = xi + yi * 1301 + zi * 314159;
                n ^= n << 13;
                return (float)(n * (n * n * 15731L + 789221L) + 1376312589L) / 4.2949673E9f;
            }

            @Override
            public float executeSigned(float x, float y, float z) {
                return 2.0f * this.execute(x, y, z) - 1.0f;
            }
        });
        distanceFunctions = new HashMap<Integer, DistanceFunction>();
        distanceFunctions.put(0, new DistanceFunction(){

            @Override
            public float execute(float x, float y, float z, float e) {
                return (float)Math.sqrt(x * x + y * y + z * z);
            }
        });
        distanceFunctions.put(1, new DistanceFunction(){

            @Override
            public float execute(float x, float y, float z, float e) {
                return x * x + y * y + z * z;
            }
        });
        distanceFunctions.put(2, new DistanceFunction(){

            @Override
            public float execute(float x, float y, float z, float e) {
                return FastMath.abs((float)x) + FastMath.abs((float)y) + FastMath.abs((float)z);
            }
        });
        distanceFunctions.put(3, new DistanceFunction(){

            @Override
            public float execute(float x, float y, float z, float e) {
                x = FastMath.abs((float)x);
                y = FastMath.abs((float)y);
                z = FastMath.abs((float)z);
                float t = x > y ? x : y;
                return z > t ? z : t;
            }
        });
        distanceFunctions.put(4, new DistanceFunction(){

            @Override
            public float execute(float x, float y, float z, float e) {
                float d = (float)(Math.sqrt(FastMath.abs((float)x)) + Math.sqrt(FastMath.abs((float)y)) + Math.sqrt(FastMath.abs((float)z)));
                return d * d;
            }
        });
        distanceFunctions.put(5, new DistanceFunction(){

            @Override
            public float execute(float x, float y, float z, float e) {
                x *= x;
                y *= y;
                z *= z;
                return (float)Math.sqrt(Math.sqrt(x * x + y * y + z * z));
            }
        });
        distanceFunctions.put(6, new DistanceFunction(){

            @Override
            public float execute(float x, float y, float z, float e) {
                return (float)Math.pow(Math.pow(FastMath.abs((float)x), e) + Math.pow(FastMath.abs((float)y), e) + Math.pow(FastMath.abs((float)z), e), 1.0f / e);
            }
        });
        NATURAL_DISTANCE_FUNCTION = distanceFunctions.get(0);
        musgraveFunctions = new HashMap<Integer, MusgraveFunction>();
        musgraveFunctions.put(0, new MusgraveFunction(){

            @Override
            public float execute(TextureGeneratorMusgrave.MusgraveData musgraveData, float x, float y, float z) {
                float value = 1.0f;
                float pwr = 1.0f;
                float pwHL = (float)Math.pow(musgraveData.lacunarity, -musgraveData.h);
                for (int i = 0; i < (int)musgraveData.octaves; ++i) {
                    value *= pwr * musgraveData.noiseFunction.executeSigned(x, y, z) + 1.0f;
                    pwr *= pwHL;
                    x *= musgraveData.lacunarity;
                    y *= musgraveData.lacunarity;
                    z *= musgraveData.lacunarity;
                }
                float rmd = musgraveData.octaves - FastMath.floor((float)musgraveData.octaves);
                if (rmd != 0.0f) {
                    value *= rmd * musgraveData.noiseFunction.executeSigned(x, y, z) * pwr + 1.0f;
                }
                return value;
            }
        });
        musgraveFunctions.put(1, new MusgraveFunction(){

            @Override
            public float execute(TextureGeneratorMusgrave.MusgraveData musgraveData, float x, float y, float z) {
                float pwHL;
                float pwr = pwHL = (float)Math.pow(musgraveData.lacunarity, -musgraveData.h);
                float signal = musgraveData.offset - FastMath.abs((float)musgraveData.noiseFunction.executeSigned(x, y, z));
                signal *= signal;
                float result = signal;
                float weight = 1.0f;
                for (int i = 1; i < (int)musgraveData.octaves; ++i) {
                    x *= musgraveData.lacunarity;
                    y *= musgraveData.lacunarity;
                    z *= musgraveData.lacunarity;
                    weight = signal * musgraveData.gain;
                    if (weight > 1.0f) {
                        weight = 1.0f;
                    } else if ((double)weight < 0.0) {
                        weight = 0.0f;
                    }
                    signal = musgraveData.offset - FastMath.abs((float)musgraveData.noiseFunction.executeSigned(x, y, z));
                    signal *= signal;
                    result += (signal *= weight) * pwr;
                    pwr *= pwHL;
                }
                return result;
            }
        });
        musgraveFunctions.put(2, new MusgraveFunction(){

            @Override
            public float execute(TextureGeneratorMusgrave.MusgraveData musgraveData, float x, float y, float z) {
                float pwHL;
                float pwr = pwHL = (float)Math.pow(musgraveData.lacunarity, -musgraveData.h);
                float result = musgraveData.noiseFunction.executeSigned(x, y, z) + musgraveData.offset;
                float weight = musgraveData.gain * result;
                x *= musgraveData.lacunarity;
                y *= musgraveData.lacunarity;
                z *= musgraveData.lacunarity;
                for (int i = 1; weight > 0.001f && i < (int)musgraveData.octaves; ++i) {
                    if (weight > 1.0f) {
                        weight = 1.0f;
                    }
                    float signal = (musgraveData.noiseFunction.executeSigned(x, y, z) + musgraveData.offset) * pwr;
                    pwr *= pwHL;
                    result += weight * signal;
                    weight *= musgraveData.gain * signal;
                    x *= musgraveData.lacunarity;
                    y *= musgraveData.lacunarity;
                    z *= musgraveData.lacunarity;
                }
                float rmd = musgraveData.octaves - FastMath.floor((float)musgraveData.octaves);
                if (rmd != 0.0f) {
                    result += rmd * (musgraveData.noiseFunction.executeSigned(x, y, z) + musgraveData.offset) * pwr;
                }
                return result;
            }
        });
        musgraveFunctions.put(3, new MusgraveFunction(){

            @Override
            public float execute(TextureGeneratorMusgrave.MusgraveData musgraveData, float x, float y, float z) {
                float value = 0.0f;
                float pwr = 1.0f;
                float pwHL = (float)Math.pow(musgraveData.lacunarity, -musgraveData.h);
                for (int i = 0; i < (int)musgraveData.octaves; ++i) {
                    value += musgraveData.noiseFunction.executeSigned(x, y, z) * pwr;
                    pwr *= pwHL;
                    x *= musgraveData.lacunarity;
                    y *= musgraveData.lacunarity;
                    z *= musgraveData.lacunarity;
                }
                float rmd = musgraveData.octaves - FastMath.floor((float)musgraveData.octaves);
                if (rmd != 0.0f) {
                    value += rmd * musgraveData.noiseFunction.executeSigned(x, y, z) * pwr;
                }
                return value;
            }
        });
        musgraveFunctions.put(4, new MusgraveFunction(){

            @Override
            public float execute(TextureGeneratorMusgrave.MusgraveData musgraveData, float x, float y, float z) {
                float increment;
                float pwHL;
                float pwr = pwHL = (float)Math.pow(musgraveData.lacunarity, -musgraveData.h);
                float value = musgraveData.offset + musgraveData.noiseFunction.executeSigned(x, y, z);
                x *= musgraveData.lacunarity;
                y *= musgraveData.lacunarity;
                z *= musgraveData.lacunarity;
                for (int i = 1; i < (int)musgraveData.octaves; ++i) {
                    increment = (musgraveData.noiseFunction.executeSigned(x, y, z) + musgraveData.offset) * pwr * value;
                    value += increment;
                    pwr *= pwHL;
                    x *= musgraveData.lacunarity;
                    y *= musgraveData.lacunarity;
                    z *= musgraveData.lacunarity;
                }
                float rmd = musgraveData.octaves - FastMath.floor((float)musgraveData.octaves);
                if ((double)rmd != 0.0) {
                    increment = (musgraveData.noiseFunction.executeSigned(x, y, z) + musgraveData.offset) * pwr * value;
                    value += rmd * increment;
                }
                return value;
            }
        });
    }

    static interface MusgraveFunction {
        public float execute(TextureGeneratorMusgrave.MusgraveData var1, float var2, float var3, float var4);
    }

    static interface DistanceFunction {
        public float execute(float var1, float var2, float var3, float var4);
    }

    public static class NoiseMath {
        public static float lerp(float t, float a, float b) {
            return a + t * (b - a);
        }

        public static float npfade(float t) {
            return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
        }

        public static float grad(int hash, float x, float y, float z) {
            float u;
            int h = hash & 0xF;
            float f = u = h < 8 ? x : y;
            float v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
            return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
        }

        public static float surve(float t) {
            return t * t * (3.0f - 2.0f * t);
        }

        public static float at(float x, float y, float z, float[] q) {
            return x * q[0] + y * q[1] + z * q[2];
        }

        public static void hash(int x, int y, int z, float[] result) {
            result[0] = hashpntf[3 * hash[hash[hash[z & 0xFF] + y & 0xFF] + x & 0xFF]];
            result[1] = hashpntf[3 * hash[hash[hash[z & 0xFF] + y & 0xFF] + x & 0xFF] + 1];
            result[2] = hashpntf[3 * hash[hash[hash[z & 0xFF] + y & 0xFF] + x & 0xFF] + 2];
        }
    }

    static interface NoiseFunction {
        public float execute(float var1, float var2, float var3);

        public float executeSigned(float var1, float var2, float var3);
    }

    public static class NoiseFunctions {
        private static final float[] voronoiP = new float[3];
        private static final float[] cn = new float[8];
        private static final int[] b1 = new int[8];
        private static final int[] b2 = new int[2];
        private static final float[] xFactor = new float[8];
        private static final float[] yFactor = new float[8];
        private static final float[] zFactor = new float[8];

        public static float noise(float x, float y, float z, float noiseSize, int noiseDepth, NoiseFunction noiseFunction, boolean isHard) {
            if ((double)noiseSize != 0.0) {
                noiseSize = 1.0f / noiseSize;
                x *= noiseSize;
                y *= noiseSize;
                z *= noiseSize;
            }
            float result = noiseFunction.execute(x, y, z);
            return isHard ? FastMath.abs((float)(2.0f * result - 1.0f)) : result;
        }

        public static float turbulence(float x, float y, float z, float noiseSize, int noiseDepth, NoiseFunction noiseFunction, boolean isHard) {
            if ((double)noiseSize != 0.0) {
                noiseSize = 1.0f / noiseSize;
                x *= noiseSize;
                y *= noiseSize;
                z *= noiseSize;
            }
            float sum = 0.0f;
            float amp = 1.0f;
            float fscale = 1.0f;
            int i = 0;
            while (i <= noiseDepth) {
                float t = noiseFunction.execute(fscale * x, fscale * y, fscale * z);
                if (isHard) {
                    t = FastMath.abs((float)(2.0f * t - 1.0f));
                }
                sum += t * amp;
                ++i;
                amp *= 0.5f;
                fscale *= 2.0f;
            }
            return sum *= (float)(1 << noiseDepth) / (float)((1 << noiseDepth + 1) - 1);
        }

        public static void voronoi(float x, float y, float z, float[] da, float[] pa, float distanceExponent, DistanceFunction distanceFunction) {
            int xi = (int)FastMath.floor((float)x);
            int yi = (int)FastMath.floor((float)y);
            int zi = (int)FastMath.floor((float)z);
            da[3] = Float.MAX_VALUE;
            da[2] = Float.MAX_VALUE;
            da[1] = Float.MAX_VALUE;
            da[0] = Float.MAX_VALUE;
            for (int i = xi - 1; i <= xi + 1; ++i) {
                for (int j = yi - 1; j <= yi + 1; ++j) {
                    for (int k = zi - 1; k <= zi + 1; ++k) {
                        NoiseMath.hash(i, j, k, voronoiP);
                        float xd = x - (voronoiP[0] + (float)i);
                        float yd = y - (voronoiP[1] + (float)j);
                        float zd = z - (voronoiP[2] + (float)k);
                        float d = distanceFunction.execute(xd, yd, zd, distanceExponent);
                        if (d < da[0]) {
                            da[3] = da[2];
                            da[2] = da[1];
                            da[1] = da[0];
                            da[0] = d;
                            pa[9] = pa[6];
                            pa[10] = pa[7];
                            pa[11] = pa[8];
                            pa[6] = pa[3];
                            pa[7] = pa[4];
                            pa[8] = pa[5];
                            pa[3] = pa[0];
                            pa[4] = pa[1];
                            pa[5] = pa[2];
                            pa[0] = voronoiP[0] + (float)i;
                            pa[1] = voronoiP[1] + (float)j;
                            pa[2] = voronoiP[2] + (float)k;
                            continue;
                        }
                        if (d < da[1]) {
                            da[3] = da[2];
                            da[2] = da[1];
                            da[1] = d;
                            pa[9] = pa[6];
                            pa[10] = pa[7];
                            pa[11] = pa[8];
                            pa[6] = pa[3];
                            pa[7] = pa[4];
                            pa[8] = pa[5];
                            pa[3] = voronoiP[0] + (float)i;
                            pa[4] = voronoiP[1] + (float)j;
                            pa[5] = voronoiP[2] + (float)k;
                            continue;
                        }
                        if (d < da[2]) {
                            da[3] = da[2];
                            da[2] = d;
                            pa[9] = pa[6];
                            pa[10] = pa[7];
                            pa[11] = pa[8];
                            pa[6] = voronoiP[0] + (float)i;
                            pa[7] = voronoiP[1] + (float)j;
                            pa[8] = voronoiP[2] + (float)k;
                            continue;
                        }
                        if (!(d < da[3])) continue;
                        da[3] = d;
                        pa[9] = voronoiP[0] + (float)i;
                        pa[10] = voronoiP[1] + (float)j;
                        pa[11] = voronoiP[2] + (float)k;
                    }
                }
            }
        }

        public static float newPerlin(float x, float y, float z) {
            float floorX = FastMath.floor((float)x);
            float floorY = FastMath.floor((float)y);
            float floorZ = FastMath.floor((float)z);
            int intX = (int)floorX & 0xFF;
            int intY = (int)floorY & 0xFF;
            int intZ = (int)floorZ & 0xFF;
            x -= floorX;
            y -= floorY;
            z -= floorZ;
            floorX = NoiseMath.npfade(x);
            floorY = NoiseMath.npfade(y);
            floorZ = NoiseMath.npfade(z);
            int A = hash[intX] + intY;
            int AA = hash[A] + intZ;
            int AB = hash[A + 1] + intZ;
            int B = hash[intX + 1] + intY;
            int BA = hash[B] + intZ;
            int BB = hash[B + 1] + intZ;
            return NoiseMath.lerp(floorZ, NoiseMath.lerp(floorY, NoiseMath.lerp(floorX, NoiseMath.grad(hash[AA], x, y, z), NoiseMath.grad(hash[BA], x - 1.0f, y, z)), NoiseMath.lerp(floorX, NoiseMath.grad(hash[AB], x, y - 1.0f, z), NoiseMath.grad(hash[BB], x - 1.0f, y - 1.0f, z))), NoiseMath.lerp(floorY, NoiseMath.lerp(floorX, NoiseMath.grad(hash[AA + 1], x, y, z - 1.0f), NoiseMath.grad(hash[BA + 1], x - 1.0f, y, z - 1.0f)), NoiseMath.lerp(floorX, NoiseMath.grad(hash[AB + 1], x, y - 1.0f, z - 1.0f), NoiseMath.grad(hash[BB + 1], x - 1.0f, y - 1.0f, z - 1.0f))));
        }

        public static float noise3Perlin(float x, float y, float z) {
            float t = x + 10000.0f;
            int bx0 = (int)t & 0xFF;
            int bx1 = bx0 + 1 & 0xFF;
            float rx0 = t - (float)((int)t);
            float rx1 = rx0 - 1.0f;
            t = y + 10000.0f;
            int by0 = (int)t & 0xFF;
            int by1 = by0 + 1 & 0xFF;
            float ry0 = t - (float)((int)t);
            float ry1 = ry0 - 1.0f;
            t = z + 10000.0f;
            int bz0 = (int)t & 0xFF;
            int bz1 = bz0 + 1 & 0xFF;
            float rz0 = t - (float)((int)t);
            float rz1 = rz0 - 1.0f;
            short i = p[bx0];
            short j = p[bx1];
            short b00 = p[i + by0];
            short b10 = p[j + by0];
            short b01 = p[i + by1];
            short b11 = p[j + by1];
            float sx = NoiseMath.surve(rx0);
            float sy = NoiseMath.surve(ry0);
            float sz = NoiseMath.surve(rz0);
            float[] q = g[b00 + bz0];
            float u = NoiseMath.at(rx0, ry0, rz0, q);
            q = g[b10 + bz0];
            float v = NoiseMath.at(rx1, ry0, rz0, q);
            float a = NoiseMath.lerp(sx, u, v);
            q = g[b01 + bz0];
            u = NoiseMath.at(rx0, ry1, rz0, q);
            q = g[b11 + bz0];
            v = NoiseMath.at(rx1, ry1, rz0, q);
            float b = NoiseMath.lerp(sx, u, v);
            float c = NoiseMath.lerp(sy, a, b);
            q = g[b00 + bz1];
            u = NoiseMath.at(rx0, ry0, rz1, q);
            q = g[b10 + bz1];
            v = NoiseMath.at(rx1, ry0, rz1, q);
            a = NoiseMath.lerp(sx, u, v);
            q = g[b01 + bz1];
            u = NoiseMath.at(rx0, ry1, rz1, q);
            q = g[b11 + bz1];
            v = NoiseMath.at(rx1, ry1, rz1, q);
            b = NoiseMath.lerp(sx, u, v);
            float d = NoiseMath.lerp(sy, a, b);
            return 1.5f * NoiseMath.lerp(sz, c, d);
        }

        public static float originalBlenderNoise(float x, float y, float z) {
            float n = 0.5f;
            int ix = (int)FastMath.floor((float)x);
            int iy = (int)FastMath.floor((float)y);
            int iz = (int)FastMath.floor((float)z);
            float ox = x - (float)ix;
            float oy = y - (float)iy;
            float oz = z - (float)iz;
            float jx = ox - 1.0f;
            float jy = oy - 1.0f;
            float jz = oz - 1.0f;
            float cn1 = ox * ox;
            float cn2 = oy * oy;
            float cn3 = oz * oz;
            float cn4 = jx * jx;
            float cn5 = jy * jy;
            float cn6 = jz * jz;
            cn1 = 1.0f - 3.0f * cn1 + 2.0f * cn1 * ox;
            cn2 = 1.0f - 3.0f * cn2 + 2.0f * cn2 * oy;
            cn3 = 1.0f - 3.0f * cn3 + 2.0f * cn3 * oz;
            cn4 = 1.0f - 3.0f * cn4 - 2.0f * cn4 * jx;
            cn5 = 1.0f - 3.0f * cn5 - 2.0f * cn5 * jy;
            cn6 = 1.0f - 3.0f * cn6 - 2.0f * cn6 * jz;
            NoiseFunctions.cn[0] = cn1 * cn2 * cn3;
            NoiseFunctions.cn[1] = cn1 * cn2 * cn6;
            NoiseFunctions.cn[2] = cn1 * cn5 * cn3;
            NoiseFunctions.cn[3] = cn1 * cn5 * cn6;
            NoiseFunctions.cn[4] = cn4 * cn2 * cn3;
            NoiseFunctions.cn[5] = cn4 * cn2 * cn6;
            NoiseFunctions.cn[6] = cn4 * cn5 * cn3;
            NoiseFunctions.cn[7] = cn4 * cn5 * cn6;
            NoiseFunctions.b1[0] = NoiseFunctions.b1[1] = hash[hash[ix & 0xFF] + (iy & 0xFF)];
            NoiseFunctions.b1[2] = NoiseFunctions.b1[3] = hash[hash[ix & 0xFF] + (iy + 1 & 0xFF)];
            NoiseFunctions.b1[4] = NoiseFunctions.b1[5] = hash[hash[ix + 1 & 0xFF] + (iy & 0xFF)];
            NoiseFunctions.b1[6] = NoiseFunctions.b1[7] = hash[hash[ix + 1 & 0xFF] + (iy + 1 & 0xFF)];
            NoiseFunctions.b2[0] = iz & 0xFF;
            NoiseFunctions.b2[1] = iz + 1 & 0xFF;
            NoiseFunctions.xFactor[2] = NoiseFunctions.xFactor[3] = ox;
            NoiseFunctions.xFactor[1] = NoiseFunctions.xFactor[3];
            NoiseFunctions.xFactor[0] = NoiseFunctions.xFactor[3];
            NoiseFunctions.xFactor[6] = NoiseFunctions.xFactor[7] = jx;
            NoiseFunctions.xFactor[5] = NoiseFunctions.xFactor[7];
            NoiseFunctions.xFactor[4] = NoiseFunctions.xFactor[7];
            NoiseFunctions.yFactor[4] = NoiseFunctions.yFactor[5] = oy;
            NoiseFunctions.yFactor[1] = NoiseFunctions.yFactor[5];
            NoiseFunctions.yFactor[0] = NoiseFunctions.yFactor[5];
            NoiseFunctions.yFactor[6] = NoiseFunctions.yFactor[7] = jy;
            NoiseFunctions.yFactor[3] = NoiseFunctions.yFactor[7];
            NoiseFunctions.yFactor[2] = NoiseFunctions.yFactor[7];
            NoiseFunctions.zFactor[4] = NoiseFunctions.zFactor[6] = oz;
            NoiseFunctions.zFactor[2] = NoiseFunctions.zFactor[6];
            NoiseFunctions.zFactor[0] = NoiseFunctions.zFactor[6];
            NoiseFunctions.zFactor[5] = NoiseFunctions.zFactor[7] = jz;
            NoiseFunctions.zFactor[3] = NoiseFunctions.zFactor[7];
            NoiseFunctions.zFactor[1] = NoiseFunctions.zFactor[7];
            for (int i = 0; i < cn.length; ++i) {
                int hIndex = 3 * hash[b1[i] + b2[i % 2]];
                n += cn[i] * (hashvectf[hIndex] * xFactor[i] + hashvectf[hIndex + 1] * yFactor[i] + hashvectf[hIndex + 2] * zFactor[i]);
            }
            if (n < 0.0f) {
                n = 0.0f;
            } else if (n > 1.0f) {
                n = 1.0f;
            }
            return n;
        }
    }
}

