/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.login;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.openide.util.Exceptions;

public class CheckConnPanel
extends JPanel {
    private Process process;
    private URL url;
    private JScrollPane jScrollPane2;
    private JTextPane taLog;

    public CheckConnPanel(String host) throws MalformedURLException {
        this.initComponents();
        this.url = new URL(host);
        this.taLog.enableInputMethods(false);
        this.taLog.setContentType("text/html");
        StringBuilder strBuilder = new StringBuilder();
        ExecutorService processExecutor = Executors.newSingleThreadExecutor();
        ExecutorService processTracertExecutor = Executors.newSingleThreadExecutor();
        Runnable tracertTask = () -> {
            try {
                strBuilder.append("<br>").append("<b>CHECKING WHERE IS PROBLEM IN ROUTE TO SERVER</b>").append("<br>");
                this.updateTaLog(strBuilder);
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                ArrayList<String> commands = new ArrayList<String>();
                String encodedHost = URLEncoder.encode(this.url.getHost(), "UTF-8");
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    commands.add("tracert");
                } else {
                    commands.add("traceroute");
                }
                commands.add(encodedHost);
                builder.command(commands);
                String s = null;
                this.process = builder.start();
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                strBuilder.append(builder.command().toString()).append("<br>");
                while ((s = stdInput.readLine()) != null) {
                    strBuilder.append(s).append("<br>");
                    this.updateTaLog(strBuilder);
                }
                if (this.process.waitFor() == 0) {
                    System.out.println("SHUTDOWN");
                    processTracertExecutor.shutdown();
                }
            }
            catch (IOException builder) {
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
        Runnable pingTask = () -> {
            try {
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                String encodedHost = URLEncoder.encode(this.url.getHost(), "UTF-8");
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    builder.command("ping", "-n", "3", encodedHost);
                } else {
                    builder.command("ping", "-c", "4", encodedHost);
                }
                String s = null;
                this.process = builder.start();
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                strBuilder.append(builder.command().toString()).append("<br>");
                System.out.println(stdInput.toString());
                while ((s = stdInput.readLine()) != null) {
                    strBuilder.append(s).append("<br>");
                    this.updateTaLog(strBuilder);
                }
                if (strBuilder.toString().contains("100% packet loss") || strBuilder.toString().contains("net unreachable")) {
                    strBuilder.append("<p style=\"color:red;\">SERVER IS NOT REACHABLE</p>").append("<br>");
                    processTracertExecutor.execute(tracertTask);
                } else if (strBuilder.toString().contains("0% packet loss") || strBuilder.toString().contains("(0% loss)") && !strBuilder.toString().contains("net unreachable")) {
                    strBuilder.append("<p style=\"color:green;\">SERVER IS REACHABLE</p>").append("<br>");
                } else if (strBuilder.toString().toLowerCase().contains("could not find host")) {
                    strBuilder.append("<p style=\"color:red;\">SERVER DNS DOES NOT EXISTS</p>").append("<br>");
                    processTracertExecutor.execute(tracertTask);
                }
                this.updateTaLog(strBuilder);
                if (this.process.waitFor() == 0) {
                    processExecutor.shutdown();
                }
            }
            catch (IOException | InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
        int port = 8080;
        if (this.url.getPort() != -1) {
            port = this.url.getPort();
        }
        strBuilder.append("<b>CHECKING IF SERVICE PORT IS AVAILABLE ON ").append(this.url.getHost()).append(" ").append(port).append("</b><br>");
        try {
            Socket socket = new Socket(this.url.getHost(), port);
            socket.setSoTimeout(2000);
            strBuilder.append("<p style=\"color:green;\">SERVICE PORT IS AVAILABLE<p>").append("<br>");
            this.updateTaLog(strBuilder);
        }
        catch (IOException e) {
            strBuilder.append("<p style=\"color:red;\">SERVICE PORT IS NOT AVAILABLE</p>").append("<br>");
            strBuilder.append("<br>");
            strBuilder.append("<b>CHECKING IF SERVER HOST IS REACHABLE</b>").append("<br>");
            this.updateTaLog(strBuilder);
            processExecutor.execute(pingTask);
        }
    }

    private void updateTaLog(StringBuilder strBuilder) {
        this.taLog.setText(strBuilder.toString());
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.taLog = new JTextPane();
        this.taLog.setEditable(false);
        this.jScrollPane2.setViewportView(this.taLog);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 562, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 288, Short.MAX_VALUE).addContainerGap()));
    }
}

