/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.nodes;

import java.util.Collections;
import java.util.List;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.gui.module.datamaps.DataMapName;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapNode;

public class DataMapChildFactory
extends ChildFactory<DataMapName> {
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private String regex;
    private boolean fetchSize;

    public DataMapChildFactory(String regex, boolean fetchSize) {
        this.regex = regex;
        this.fetchSize = fetchSize;
    }

    protected boolean createKeys(List toPopulate) {
        try {
            List maps = this.apiService.getDataMapNames();
            List dataMapNamesWithRegex = this.apiService.getDataMapNamesWithRegex(this.regex);
            Collections.sort(maps);
            maps.stream().map(s -> new DataMapName((String)s, this.contains(dataMapNamesWithRegex, (String)s))).forEach(n -> toPopulate.add(n));
        }
        catch (RuntimeException | ApiServiceException_Exception ex) {
            if (ex.getMessage().contains("was not recognized") && ex.getMessage().contains("WSDL")) {
                NotifyDescriptor.Message notDes = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DataMapChildFactory.class, (String)"DataMapChildFactory.FeatureNotAvailable.warningMessage"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)notDes);
            }
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    protected Node createNodeForKey(DataMapName key) {
        return new DataMapNode(key, this.regex, this.fetchSize);
    }

    private boolean contains(List<String> datamaps, String name) {
        if (datamaps == null) {
            return true;
        }
        for (String datamap : datamaps) {
            if (!datamap.equals(name)) continue;
            return true;
        }
        return false;
    }
}

