/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.model;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.gui.module.datamaps.model.DatabaseEvent;
import rs.co.ast.aspen.gui.module.datamaps.model.DatabaseEventListener;

public class InMemoryDatabase {
    private static final String DB_CONNECTION = "jdbc:h2:mem:datamaps;DATABASE_TO_UPPER=false;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE";
    private static final String DB_DRIVER = "org.h2.Driver";
    private static final String DB_PASSWORD = "";
    private static final String DB_USER = "";
    private static final String DEFAULT_VIEW_QUERY = "SELECT * FROM fields";
    private static final int FILTER_MINIMUM_CHARS = 3;
    private static final String VIEW_NAME = "fields_filter_view";
    private static final Logger logger = Logger.getLogger(InMemoryDatabase.class.getName());
    private List<String> columns = new ArrayList<String>();
    private EventListenerList listeners = new EventListenerList();

    public synchronized void addDatabaseEventListener(DatabaseEventListener listener) {
        this.listeners.add(DatabaseEventListener.class, listener);
    }

    public synchronized void removeDatabaseEventListener(DatabaseEventListener listener) {
        this.listeners.remove(DatabaseEventListener.class, listener);
    }

    public synchronized void dispose() {
        try (Connection connection = this.getDBConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute("TRUNCATE TABLE fields");
        }
        catch (SQLException ex) {
            logger.warning(ex.getMessage());
        }
    }

    public synchronized List<Map<String, String>> executeCountQuery(List<String> columnNames) {
        ArrayList rows = null;
        StringBuilder sb = new StringBuilder();
        for (String col : columnNames) {
            if (col.toLowerCase().startsWith("func.")) continue;
            sb.append("\"");
            sb.append(col);
            sb.append("\"");
            sb.append(",");
        }
        sb.append(";");
        String query = sb.toString().replace(",;", "");
        try (Connection connection = this.getDBConnection();){
            try (Statement stmt = connection.createStatement();){
                ResultSet rs = stmt.executeQuery("SELECT " + query + ", count(*) AS \"func.count\" FROM fields_filter_view GROUP BY " + query);
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                rows = new ArrayList();
                while (rs.next()) {
                    HashMap<String, String> row = new HashMap<String, String>();
                    for (int i = 1; i <= columnCount; ++i) {
                        row.put(metaData.getColumnLabel(i), rs.getString(i));
                    }
                    rows.add(row);
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireFunctionQueryExecutedEvent();
        return rows;
    }

    public synchronized void filter(String filter, boolean isNot) {
        if (filter.length() >= 3) {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM fields WHERE ");
            for (String column : this.columns) {
                query.append("\"");
                query.append(column);
                query.append("\"");
                if (isNot) {
                    query.append(" NOT");
                }
                query.append(" LIKE ");
                query.append("'%");
                query.append(filter);
                if (isNot) {
                    query.append("%' AND ");
                    continue;
                }
                query.append("%' OR ");
            }
            query.append(";");
            String q = query.toString();
            q = isNot ? q.replace(" AND ;", "") : q.replace(" OR ;", "");
            this.createView(q);
        } else {
            this.createView(DEFAULT_VIEW_QUERY);
        }
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public synchronized void setColumns(List<String> columns) {
        this.columns = new ArrayList<String>(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getRowCount() {
        int count = 0;
        try {
            try (Connection connection = this.getDBConnection();){
                try (Statement stmt = connection.createStatement();){
                    ResultSet rs = stmt.executeQuery("SELECT count(*) FROM fields_filter_view");
                    rs.next();
                    count = rs.getInt(1);
                    return count;
                }
                catch (SQLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return count;
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        finally {
            return count;
        }
    }

    public synchronized void initDB(final Map<String, HashMap<String, Object>> datamapValues) {
        if (!datamapValues.isEmpty()) {
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
                    LinkedHashSet<String> cols = new LinkedHashSet<String>();
                    cols.add("SecondKey");
                    Map.Entry next = datamapValues.entrySet().iterator().next();
                    if (next.getValue() instanceof HashMap) {
                        HashMap value = (HashMap)next.getValue();
                        Map.Entry next1 = value.entrySet().iterator().next();
                        if (next1.getValue() instanceof HashMap) {
                            return null;
                        }
                        Set keySet = value.keySet();
                        for (String string : keySet) {
                            cols.add(string);
                        }
                        for (Map.Entry entry : datamapValues.entrySet()) {
                            LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>();
                            newMap.put("SecondKey", (String)entry.getKey());
                            for (Map.Entry entry1 : ((HashMap)entry.getValue()).entrySet()) {
                                newMap.put((String)entry1.getKey(), String.valueOf(entry1.getValue()));
                            }
                            data.add(newMap);
                        }
                        InMemoryDatabase.this.columns = new ArrayList<String>(cols);
                        InMemoryDatabase.this.createTable(InMemoryDatabase.this.columns);
                        InMemoryDatabase.this.insertData(data, InMemoryDatabase.this.columns);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            worker.execute();
        }
    }

    public synchronized List<LinkedHashMap<String, String>> selectDataForExport(List<String> columnNames) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (String col : columnNames) {
            sb.append("\"");
            sb.append(col);
            sb.append("\"");
            sb.append(",");
        }
        sb.append(";");
        String kolone = sb.toString().replace(",;", "");
        ArrayList rows = null;
        try (Connection connection = this.getDBConnection();){
            try (Statement stmt = connection.createStatement();){
                ResultSet rs = stmt.executeQuery(kolone + " FROM fields_filter_view");
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                rows = new ArrayList();
                while (rs.next()) {
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    for (int i = 1; i <= columnCount; ++i) {
                        row.put(metaData.getColumnLabel(i), rs.getString(i));
                    }
                    rows.add(row);
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return rows;
    }

    public Map<String, String> selectSpecificRow(int rowIndex) {
        rowIndex = rowIndex == 0 ? 0 : rowIndex;
        HashMap<String, String> row = new HashMap<String, String>();
        try (Connection connection = this.getDBConnection();
             PreparedStatement pstmt = connection.prepareStatement("SELECT * FROM fields_filter_view LIMIT 1 OFFSET ?");){
            pstmt.setInt(1, rowIndex);
            ResultSet rs = pstmt.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                row = new HashMap();
                for (int i = 1; i <= columnCount; ++i) {
                    row.put(metaData.getColumnLabel(i), rs.getString(i));
                }
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return row;
    }

    private synchronized void createTable(List<String> columnNames) {
        this.dropView();
        this.dropDatabase();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE fields (");
        sb.append("id int auto_increment primary key,");
        for (String col : columnNames) {
            sb.append("\"");
            sb.append(col);
            sb.append("\"");
            sb.append(" text,");
        }
        sb.append(");");
        String query = sb.toString().replace(",);", ");");
        try (Connection connection = this.getDBConnection();
             PreparedStatement prepareStatement = connection.prepareStatement(query);){
            prepareStatement.executeUpdate();
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireTableCreatedEvent();
    }

    private synchronized void createView(String query) {
        this.dropView();
        String q = "CREATE VIEW fields_filter_view AS " + query;
        try (Connection connection = this.getDBConnection();){
            Statement statement = connection.createStatement();
            int ret = statement.executeUpdate(q);
            logger.info(String.format("ROWS CHANGED: %d", ret));
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireDataInsertedEvent();
    }

    private synchronized void dropDatabase() {
        try (Connection connection = this.getDBConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute("DROP TABLE IF EXISTS fields");
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private synchronized void dropView() {
        try (Connection connection = this.getDBConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute("DROP VIEW IF EXISTS fields_filter_view");
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private synchronized void fireDataInsertedEvent() {
        DatabaseEvent event = new DatabaseEvent(this);
        Object[] list = this.listeners.getListenerList();
        for (int i = 0; i < list.length; i += 2) {
            if (list[i] != DatabaseEventListener.class) continue;
            ((DatabaseEventListener)list[i + 1]).dataInserted(event);
        }
    }

    private synchronized void fireFunctionQueryExecutedEvent() {
        DatabaseEvent event = new DatabaseEvent(this);
        Object[] list = this.listeners.getListenerList();
        for (int i = 0; i < list.length; i += 2) {
            if (list[i] != DatabaseEventListener.class) continue;
            ((DatabaseEventListener)list[i + 1]).functionQueryExecuted(event);
        }
    }

    private synchronized void fireTableCreatedEvent() {
        DatabaseEvent event = new DatabaseEvent(this);
        Object[] list = this.listeners.getListenerList();
        for (int i = 0; i < list.length; i += 2) {
            if (list[i] != DatabaseEventListener.class) continue;
            ((DatabaseEventListener)list[i + 1]).tableCreated(event);
        }
    }

    private synchronized Connection getDBConnection() {
        Connection dbConnection = null;
        try {
            Class.forName(DB_DRIVER);
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        try {
            dbConnection = DriverManager.getConnection(DB_CONNECTION, "", "");
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return dbConnection;
    }

    private synchronized void insertData(List<Map<String, String>> datamaps, List<String> columns) {
        try (Connection connection = this.getDBConnection();){
            try {
                int i;
                connection.setAutoCommit(false);
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT INTO fields (");
                for (i = 0; i < columns.size(); ++i) {
                    if (i == columns.size() - 1) {
                        sb.append("\"");
                        sb.append(columns.get(i));
                        sb.append("\"");
                        continue;
                    }
                    sb.append("\"");
                    sb.append(columns.get(i));
                    sb.append("\"");
                    sb.append(",");
                }
                sb.append(") VALUES (");
                for (i = 0; i < columns.size(); ++i) {
                    if (i == columns.size() - 1) {
                        sb.append("?");
                        continue;
                    }
                    sb.append("?,");
                }
                sb.append(");");
                try (PreparedStatement pstmt = connection.prepareStatement(sb.toString(), columns.toArray(new String[columns.size() - 1]));){
                    for (int i2 = 0; i2 < datamaps.size(); ++i2) {
                        Map<String, String> datamapKey = datamaps.get(i2);
                        for (int j = 0; j < columns.size(); ++j) {
                            String column = columns.get(j);
                            String value = datamapKey.get(column);
                            value = value != null ? value : "";
                            pstmt.setString(j + 1, value);
                        }
                        pstmt.executeUpdate();
                    }
                }
                connection.commit();
                this.createView(DEFAULT_VIEW_QUERY);
            }
            catch (SQLException ex) {
                try {
                    connection.rollback();
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (SQLException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

