/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.JumpToDialog;
import rs.co.ast.aspen.gui.module.prseditor.PRSTreeExplorerManager;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RootNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RuleSetNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RulesGroupNode;

public final class CopyToGroupAction
implements ActionListener {
    private final RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final ParsingRulesGroupDTOWrapper group;

    public CopyToGroupAction(ParsingRulesGroupDTOWrapper group) {
        this.group = group;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        RulesGroupNode groupNode = (RulesGroupNode)Utilities.actionsGlobalContext().lookup(RulesGroupNode.class);
        if (groupNode != null) {
            final JumpToDialog dialog = new JumpToDialog();
            dialog.setVisible(true);
            dialog.setFocusable(true);
            dialog.setFocusableWindowState(true);
            dialog.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    dialog.setVisible(false);
                }
            });
            dialog.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                }

                @Override
                public void windowClosed(WindowEvent e) {
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    try {
                        if (dialog.isOk()) {
                            String id = this.getParentIdForNode();
                            if (id != null) {
                                CopyToGroupAction.this.model.duplicateGroup(CopyToGroupAction.this.group, id);
                                ExplorerManager explorerManager = PRSTreeExplorerManager.getMainPRSTreeExplorerManager();
                                if (explorerManager != null) {
                                    RootNode rootNode = (RootNode)explorerManager.getRootContext();
                                    rootNode.updateChildren();
                                }
                            } else {
                                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CopyToGroupAction.class, (String)"CopyToGroupError.message"), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                            }
                        }
                    }
                    catch (ApiServiceException_Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                private String getParentIdForNode() {
                    String id = null;
                    Object selectedNode = dialog.getSelectedNode();
                    if (selectedNode instanceof RuleSetNode) {
                        RuleSetNode ruleSetNode = (RuleSetNode)selectedNode;
                        id = ruleSetNode.getRuleSet().getId();
                    } else {
                        RulesGroupNode groupNode = (RulesGroupNode)selectedNode;
                        if (groupNode != null) {
                            ParsingRulesGroupDTOWrapper group = groupNode.getGroup();
                            id = group.getId();
                        }
                    }
                    return id;
                }
            });
        }
    }
}

