/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.export;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SkippedTaskDelays {
    private static final Logger logger = Logger.getLogger(SkippedTaskDelays.class.getName());
    private Map<String, SkippedFileDelayAndCount> skippedTaskDelays = new HashMap<String, SkippedFileDelayAndCount>();
    private static final long DEFAULT_DELAY = 10L;
    private static final int MAX_SKIP_COUNT = 5;

    public long getDelayForSkippedTask(String fileName) {
        long random = Math.round(Math.random() * 1000.0);
        SkippedFileDelayAndCount r = this.skippedTaskDelays.get(fileName);
        if (r == null) {
            return 10L + random;
        }
        logger.info(String.format("getDelayForSkippedFileName: %s %d %d", fileName, r.getDelay(), r.getSkipCount()));
        return r.getDelay() + random;
    }

    public void putDelayForSkippedTask(String skippedTaskName, long delay) {
        SkippedFileDelayAndCount r = this.skippedTaskDelays.get(skippedTaskName);
        int skipCount = 0;
        if (r != null) {
            skipCount = r.getSkipCount() + 1;
        }
        this.skippedTaskDelays.put(skippedTaskName, new SkippedFileDelayAndCount(this, delay, skipCount));
    }

    public boolean isSkipCountLimitExceeded(String fileName) {
        SkippedFileDelayAndCount r = this.skippedTaskDelays.get(fileName);
        if (r == null) {
            return false;
        }
        return r.getSkipCount() >= 5;
    }

    public final class SkippedFileDelayAndCount {
        private long delay;
        private int skipCount;

        public SkippedFileDelayAndCount(SkippedTaskDelays this$0, long delay, int skipCount) {
            this.delay = delay;
            this.skipCount = skipCount;
        }

        public long getDelay() {
            return this.delay;
        }

        public int getSkipCount() {
            return this.skipCount;
        }
    }
}

