/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.awt.Mnemonics;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ItemsPerTimePeriod;
import rs.co.ast.aspen.api.service.TermTimeHistogram;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventSearchQueryUpdate;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventWrapper;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventsTableRenderer;
import rs.co.ast.aspen.gui.module.alertevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.alertevents.query.QueryManager;
import rs.co.ast.aspen.gui.module.alertevents.widget.LoadingPanel;
import rs.co.ast.aspen.gui.module.alertevents.widget.QueuePanel;
import rs.co.ast.aspen.gui.module.alertevents.widget.ReloadPanel;
import rs.co.ast.aspen.gui.module.alertevents.widget.Widget;
import rs.co.ast.chart.ASTChart;
import rs.co.ast.chart.ByPriorityChart;
import rs.co.ast.chart.FiveMinute;
import rs.co.ast.chart.ThirtyMinute;
import rs.co.ast.chart.ThreeHour;
import rs.co.ast.chart.TwelveHour;
import rs.co.ast.chart.event.ASTMouseEvent;
import rs.co.ast.chart.event.ASTMouseListener;
import rs.co.ast.chart.event.ASTPlotChangeEvent;
import rs.co.ast.chart.event.ASTPlotChangeListener;

public class ByPriorityPanel
extends JPanel
implements Widget {
    private static final long MS_IN_AN_HOUR = 3600000L;
    private static final long MS_IN_AN_MINUTE = 60000L;
    private static final long MS_IN_A_DAY = 86400000L;
    private static final Logger LOGGER = Logger.getLogger(ByPriorityPanel.class.getName());
    private final Lookup.Result<AlertEventWrapper> lr = Utilities.actionsGlobalContext().lookupResult(AlertEventWrapper.class);
    private static final int NO_PRIORITIES = 5;
    private static final int GRAPH_HEIGHT = 150;
    private final transient MouseListener listener;
    private AlertEventWrapper alertEventWrapper;
    private final FileSystem fs = FileUtil.createMemoryFileSystem();
    private final FileObject root = this.fs.getRoot();
    private InstanceContent instanceContent = new InstanceContent();
    private Lookup searchQueryUpdate = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private AlertEventSearchQueryUpdate prevSearchQueryUpdate;
    private DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime();
    private UpdateParams params;
    private ByPriorityChart chart;
    private ASTPlotChangeListener plotChangeListener;
    private ASTMouseListener mouseListener;
    private LoadingPanel loadingPanel;
    private QueuePanel queuePanel;
    private JButton bP1;
    private JButton bP2;
    private JButton bP3;
    private JButton bP4;
    private JButton bP5;
    private JPanel graphPanel;
    private JLabel lP1;
    private JLabel lP2;
    private JLabel lP3;
    private JLabel lP4;
    private JLabel lP5;
    private JPanel pDataPanel;

    public ByPriorityPanel() {
        this.initComponents();
        this.setHandCursor();
        this.graphPanel.setLayout(new BorderLayout());
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result res = (Lookup.Result)ev.getSource();
                Collection instances = res.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof AlertEventWrapper)) continue;
                    ByPriorityPanel.this.alertEventWrapper = (AlertEventWrapper)o;
                }
            }
        });
        this.listener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JButton btn = (JButton)e.getSource();
                if (ByPriorityPanel.this.alertEventWrapper != null) {
                    Object query;
                    String prevQuery = ByPriorityPanel.this.alertEventWrapper.getQuery();
                    if (ByPriorityPanel.this.isCTRL_SHIFT_CLICK(e)) {
                        Object object = query = !prevQuery.isEmpty() ? prevQuery + " " : prevQuery;
                        if (!((String)query).isEmpty()) {
                            query = (String)query + "OR ";
                        }
                        query = (String)query + "what.priority:" + btn.getToolTipText();
                    } else if (e.isShiftDown()) {
                        query = !prevQuery.isEmpty() ? prevQuery + " " : prevQuery;
                        query = (String)query + "NOT what.priority:" + btn.getToolTipText();
                    } else if (e.isControlDown()) {
                        query = !prevQuery.isEmpty() ? prevQuery + " AND " : prevQuery;
                        query = (String)query + "what.priority:" + btn.getToolTipText();
                    } else {
                        query = "what.priority:" + btn.getToolTipText();
                    }
                    if (query != null && !((String)query).isEmpty()) {
                        try {
                            FileObject fileData;
                            if (ByPriorityPanel.this.root.getFileObject("AlertEventFolder") == null) {
                                testFolder = ByPriorityPanel.this.root.createFolder("AlertEventFolder");
                                fileData = testFolder.createData("AlertEventID", "alertevent");
                            } else {
                                testFolder = ByPriorityPanel.this.root.getFileObject("AlertEventFolder");
                                fileData = testFolder.getFileObject("AlertEventID", "alertevent");
                            }
                            fileData.setAttribute("query", query);
                            fileData.setAttribute("start", (Object)ByPriorityPanel.this.alertEventWrapper.getOptions().getTimeStart());
                            fileData.setAttribute("finish", (Object)ByPriorityPanel.this.alertEventWrapper.getOptions().getTimeFinish());
                            fileData.setAttribute("lastNHours", (Object)ByPriorityPanel.this.alertEventWrapper.getOptions().isLastNHours());
                            fileData.setAttribute("now", (Object)ByPriorityPanel.this.alertEventWrapper.getOptions().isNow());
                            fileData.setAttribute("ASC", (Object)false);
                            fileData.setAttribute("lastNHoursSelectedIndex", (Object)ByPriorityPanel.this.alertEventWrapper.getOptions().getLastNHoursSelectedIndex());
                            DataObject sedo = DataObject.find((FileObject)fileData);
                            ((OpenCookie)sedo.getLookup().lookup(OpenCookie.class)).open();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.plotChangeListener = new ASTPlotChangeListener(){

            public void plotChanged(ASTPlotChangeEvent event) {
                String query = QueryManager.makeGraphZoomQuery(ByPriorityPanel.this.alertEventWrapper, ByPriorityPanel.this.isoTimeFormat, (PlotChangeEvent)event);
                double tmp = event.getFinishTime() - event.getStartTime();
                ByPriorityPanel.this.params.getDisplayOptions().toggleFireEvents();
                if (tmp <= 1.44E7) {
                    ByPriorityPanel.this.params.getDisplayOptions().setIntervalObj(ByPriorityPanel.this.params.getDisplayOptions().getIntervals()[0]);
                } else if (tmp > 1.44E7 && tmp < 4.32E7) {
                    ByPriorityPanel.this.params.getDisplayOptions().setIntervalObj(ByPriorityPanel.this.params.getDisplayOptions().getIntervals()[1]);
                } else if (tmp >= 4.32E7 && tmp <= 8.64E7) {
                    ByPriorityPanel.this.params.getDisplayOptions().setIntervalObj(ByPriorityPanel.this.params.getDisplayOptions().getIntervals()[2]);
                } else if (tmp > 8.64E7 && tmp <= 1.728E8) {
                    ByPriorityPanel.this.params.getDisplayOptions().setIntervalObj(ByPriorityPanel.this.params.getDisplayOptions().getIntervals()[3]);
                } else if (tmp > 1.728E8 && tmp <= 6.048E8) {
                    ByPriorityPanel.this.params.getDisplayOptions().setIntervalObj(ByPriorityPanel.this.params.getDisplayOptions().getIntervals()[4]);
                } else if (tmp > 6.048E8 && tmp <= 3.888E9) {
                    ByPriorityPanel.this.params.getDisplayOptions().setIntervalObj(ByPriorityPanel.this.params.getDisplayOptions().getIntervals()[3]);
                } else {
                    ByPriorityPanel.this.params.getDisplayOptions().setIntervalObj(ByPriorityPanel.this.params.getDisplayOptions().getIntervals()[4]);
                }
                ByPriorityPanel.this.params.getDisplayOptions().toggleFireEvents();
                if (query.length() > 0) {
                    AlertEventSearchQueryUpdate squ = new AlertEventSearchQueryUpdate(query, true, ByPriorityPanel.this.alertEventWrapper.getTag());
                    ByPriorityPanel.this.instanceContent.add((Object)squ);
                    ByPriorityPanel.this.prevSearchQueryUpdate = squ;
                }
                if (ByPriorityPanel.this.prevSearchQueryUpdate != null) {
                    ByPriorityPanel.this.instanceContent.remove((Object)ByPriorityPanel.this.prevSearchQueryUpdate);
                }
            }
        };
        this.mouseListener = new ASTMouseListener(){

            public void mousePressed(ASTMouseEvent e) {
                if (e.isShiftDown()) {
                    ByPriorityPanel.this.chart.addPlotChangeListener(ByPriorityPanel.this.plotChangeListener);
                }
            }

            public void mouseReleased(ASTMouseEvent e) {
                if (e.isShiftDown()) {
                    ByPriorityPanel.this.chart.removeAllListeners();
                    ByPriorityPanel.this.chart.addChartPanelMouseListener(ByPriorityPanel.this.mouseListener);
                }
            }
        };
        this.bP1.addMouseListener(this.listener);
        this.bP1.setToolTipText("1");
        this.bP2.addMouseListener(this.listener);
        this.bP2.setToolTipText("2");
        this.bP3.addMouseListener(this.listener);
        this.bP3.setToolTipText("3");
        this.bP4.addMouseListener(this.listener);
        this.bP4.setToolTipText("4");
        this.bP5.addMouseListener(this.listener);
        this.bP5.setToolTipText("5");
    }

    private boolean isCTRL_SHIFT_CLICK(MouseEvent e) {
        int onmask = 1216;
        return (e.getModifiersEx() & onmask) == onmask;
    }

    private void setHandCursor() {
        Cursor cur = new Cursor(12);
        this.bP1.setCursor(cur);
        this.bP2.setCursor(cur);
        this.bP3.setCursor(cur);
        this.bP4.setCursor(cur);
        this.bP5.setCursor(cur);
    }

    public Lookup getSecurityEventQueryUpdateLookup() {
        return this.searchQueryUpdate;
    }

    @Override
    public void setLoadingPanel() {
        if (this.loadingPanel == null) {
            this.loadingPanel = new LoadingPanel();
        }
        this.removeAll();
        this.add(this.loadingPanel);
    }

    @Override
    public void setReloadPanel(ReloadPanel panel) {
        this.removeAll();
        this.add(panel);
    }

    @Override
    public void setQueuePanel() {
        if (this.queuePanel == null) {
            this.queuePanel = new QueuePanel();
        }
        this.removeAll();
        this.add(this.queuePanel);
    }

    @Override
    public void update(List<TermTimeHistogram> list, Class<?> clazz) {
        long[] m = this.getTotalEventsByPriority(list);
        this.lP1.setText(NumberFormat.getNumberInstance(Locale.getDefault()).format(m[0]));
        this.lP1.setForeground(ASTChart.COLORS[0]);
        this.lP2.setText(NumberFormat.getNumberInstance(Locale.getDefault()).format(m[1]));
        this.lP2.setForeground(ASTChart.COLORS[1]);
        this.lP3.setText(NumberFormat.getNumberInstance(Locale.getDefault()).format(m[2]));
        this.lP3.setForeground(ASTChart.COLORS[2]);
        this.lP4.setText(NumberFormat.getNumberInstance(Locale.getDefault()).format(m[3]));
        this.lP4.setForeground(ASTChart.COLORS[3]);
        this.lP5.setText(NumberFormat.getNumberInstance(Locale.getDefault()).format(m[4]));
        this.lP5.setForeground(ASTChart.COLORS[4]);
        this.bP1.setForeground(ASTChart.COLORS[5]);
        this.bP2.setForeground(ASTChart.COLORS[5]);
        this.bP3.setForeground(ASTChart.COLORS[5]);
        this.bP4.setForeground(ASTChart.COLORS[5]);
        this.bP5.setForeground(ASTChart.COLORS[5]);
        this.bP1.setBackground(AlertEventsTableRenderer.PRIORITY_COLORS[0]);
        this.bP2.setBackground(AlertEventsTableRenderer.PRIORITY_COLORS[1]);
        this.bP3.setBackground(AlertEventsTableRenderer.PRIORITY_COLORS[2]);
        this.bP4.setBackground(AlertEventsTableRenderer.PRIORITY_COLORS[3]);
        this.bP5.setBackground(AlertEventsTableRenderer.PRIORITY_COLORS[4]);
        ChartPanel cpComponent = null;
        if (this.chart == null) {
            this.chart = new ByPriorityChart(this.createDataSet(list, clazz));
            cpComponent = this.chart.getChartPanel();
        } else {
            this.chart.removeAllListeners();
            this.chart.updateChart(this.createDataSet(list, clazz));
            cpComponent = this.chart.getChartPanel();
        }
        this.graphPanel.removeAll();
        this.chart.addChartPanelMouseListener(this.mouseListener);
        if (cpComponent != null) {
            Dimension d = this.getParent().getParent().getParent().getSize();
            d.setSize(d.getWidth() - 35.0, 150.0);
            cpComponent.setPreferredSize(new Dimension(0, 150));
            cpComponent.setMaximumSize(d);
            this.graphPanel.add((Component)cpComponent);
        }
        this.graphPanel.invalidate();
        this.graphPanel.validate();
        this.graphPanel.repaint();
        this.removeAll();
        this.add(this.pDataPanel);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<TermTimeHistogram> getTimeHistogram(Object data) throws ApiServiceException_Exception {
        this.params = (UpdateParams)data;
        ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
        return apiService.getALTermTimeHistogram(this.params.getQuery(), "what.priority", this.params.getTimeStart(), this.params.getTimeFinish(), 5, this.params.getInterval(), true);
    }

    private TimeTableXYDataset createDataSet(List<TermTimeHistogram> items, Class clazz) {
        TimeTableXYDataset dataset = new TimeTableXYDataset(TimeZone.getDefault());
        dataset.setDomainIsPointsInTime(true);
        HashSet<Long> times = new HashSet<Long>();
        for (int i = items.size() - 1; i >= 0; --i) {
            TermTimeHistogram tth = items.get(i);
            int priority = this.clamp(Integer.valueOf(tth.getTerm()), 1, 5);
            times.clear();
            for (ItemsPerTimePeriod iptp : tth.getHistogram()) {
                if (iptp.getTime() < this.params.getTimeStart() || iptp.getTime() > this.params.getTimeFinish() || times.contains(iptp.getTime())) continue;
                times.add(iptp.getTime());
                long tp = 300000L;
                if (clazz.getName().equals(Minute.class.getName())) {
                    tp = 60000L;
                } else if (clazz.getName().equals(FiveMinute.class.getName())) {
                    tp = 300000L;
                } else if (clazz.getName().equals(ThirtyMinute.class.getName())) {
                    tp = 1800000L;
                } else if (clazz.getName().equals(Hour.class.getName())) {
                    tp = 3600000L;
                } else if (clazz.getName().equals(ThreeHour.class.getName())) {
                    tp = 10800000L;
                } else if (clazz.getName().equals(TwelveHour.class.getName())) {
                    tp = 43200000L;
                } else if (clazz.getName().equals(Day.class.getName())) {
                    tp = 86400000L;
                }
                SimpleTimePeriod period = new SimpleTimePeriod(iptp.getTime(), iptp.getTime() + tp);
                long c = iptp.getCount();
                dataset.add((TimePeriod)period, (double)c, (Comparable)((Object)(NbBundle.getMessage(ByPriorityPanel.class, (String)"Char.tooltip.Priority") + priority)));
            }
        }
        return dataset;
    }

    private void initComponents() {
        this.pDataPanel = new JPanel();
        this.graphPanel = new JPanel();
        this.bP1 = new JButton();
        this.lP1 = new JLabel();
        this.lP2 = new JLabel();
        this.bP2 = new JButton();
        this.bP3 = new JButton();
        this.lP3 = new JLabel();
        this.lP4 = new JLabel();
        this.bP4 = new JButton();
        this.lP5 = new JLabel();
        this.bP5 = new JButton();
        this.pDataPanel.setBackground(new Color(255, 255, 255));
        this.graphPanel.setBackground(new Color(255, 255, 255));
        this.graphPanel.setPreferredSize(new Dimension(0, 130));
        GroupLayout graphPanelLayout = new GroupLayout(this.graphPanel);
        this.graphPanel.setLayout(graphPanelLayout);
        graphPanelLayout.setHorizontalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        graphPanelLayout.setVerticalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 130, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.bP1, (String)NbBundle.getMessage(ByPriorityPanel.class, (String)"ByPriorityPanel.bP1.text"));
        this.bP1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.bP1.setContentAreaFilled(false);
        this.bP1.setFocusPainted(false);
        this.bP1.setMargin(new Insets(0, 0, 0, 0));
        this.bP1.setOpaque(true);
        this.lP1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lP1, (String)NbBundle.getMessage(ByPriorityPanel.class, (String)"ByPriorityPanel.lP1.text"));
        this.lP2.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lP2, (String)NbBundle.getMessage(ByPriorityPanel.class, (String)"ByPriorityPanel.lP2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bP2, (String)NbBundle.getMessage(ByPriorityPanel.class, (String)"ByPriorityPanel.bP2.text"));
        this.bP2.setBorder(null);
        this.bP2.setContentAreaFilled(false);
        this.bP2.setFocusPainted(false);
        this.bP2.setMargin(new Insets(0, 0, 0, 0));
        this.bP2.setOpaque(true);
        Mnemonics.setLocalizedText((AbstractButton)this.bP3, (String)NbBundle.getMessage(ByPriorityPanel.class, (String)"ByPriorityPanel.bP3.text"));
        this.bP3.setBorder(null);
        this.bP3.setContentAreaFilled(false);
        this.bP3.setFocusPainted(false);
        this.bP3.setMargin(new Insets(0, 0, 0, 0));
        this.bP3.setOpaque(true);
        this.lP3.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lP3, (String)NbBundle.getMessage(ByPriorityPanel.class, (String)"ByPriorityPanel.lP3.text"));
        this.lP4.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lP4, (String)NbBundle.getMessage(ByPriorityPanel.class, (String)"ByPriorityPanel.lP4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bP4, (String)NbBundle.getMessage(ByPriorityPanel.class, (String)"ByPriorityPanel.bP4.text"));
        this.bP4.setBorder(null);
        this.bP4.setContentAreaFilled(false);
        this.bP4.setFocusPainted(false);
        this.bP4.setMargin(new Insets(0, 0, 0, 0));
        this.bP4.setOpaque(true);
        this.lP5.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lP5, (String)NbBundle.getMessage(ByPriorityPanel.class, (String)"ByPriorityPanel.lP5.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bP5, (String)NbBundle.getMessage(ByPriorityPanel.class, (String)"ByPriorityPanel.bP5.text"));
        this.bP5.setBorder(null);
        this.bP5.setContentAreaFilled(false);
        this.bP5.setFocusPainted(false);
        this.bP5.setMargin(new Insets(0, 0, 0, 0));
        this.bP5.setOpaque(true);
        GroupLayout pDataPanelLayout = new GroupLayout(this.pDataPanel);
        this.pDataPanel.setLayout(pDataPanelLayout);
        pDataPanelLayout.setHorizontalGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.graphPanel, -1, -1, Short.MAX_VALUE).addGroup(pDataPanelLayout.createSequentialGroup().addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.bP1, -1, -1, Short.MAX_VALUE).addComponent(this.lP1, -2, 66, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.bP2, -1, -1, Short.MAX_VALUE).addComponent(this.lP2, -2, 64, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lP3, -1, -1, Short.MAX_VALUE).addComponent(this.bP3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.bP4, -1, -1, Short.MAX_VALUE).addComponent(this.lP4, -2, 64, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.bP5, -1, -1, Short.MAX_VALUE).addComponent(this.lP5, -2, 64, -2)).addGap(0, 0, Short.MAX_VALUE))).addGap(0, 0, 0)));
        pDataPanelLayout.setVerticalGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataPanelLayout.createSequentialGroup().addContainerGap().addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lP1).addComponent(this.lP2).addComponent(this.lP3).addComponent(this.lP4).addComponent(this.lP5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bP1).addComponent(this.bP2).addComponent(this.bP3).addComponent(this.bP4).addComponent(this.bP5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.graphPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
    }

    private long[] getTotalEventsByPriority(List<TermTimeHistogram> data) {
        long[] m = new long[5];
        for (TermTimeHistogram tth : data) {
            try {
                Integer val = Integer.valueOf(tth.getTerm());
                Integer priority = this.clamp(val, 1, 5);
                for (ItemsPerTimePeriod iptp : tth.getHistogram()) {
                    int n = priority - 1;
                    m[n] = m[n] + iptp.getCount();
                }
            }
            catch (NumberFormatException ex) {
            }
        }
        return m;
    }

    private Integer clamp(Integer priority, int min, int max) {
        Integer i = priority;
        if (i != null && i < min) {
            i = min;
        } else if (i != null && i > max) {
            i = max;
        }
        return i;
    }

    public static class UpdateParams {
        private String query;
        private long timeStart;
        private long timeFinish;
        private String interval;
        private DisplayOptions displayOptions;

        public UpdateParams(String query, long timeStart, long timeFinish, String interval) {
            this.query = query;
            this.query = query;
            if (!query.contains("what.priority")) {
                StringBuilder sb = new StringBuilder();
                sb.append(query);
                sb.append(" AND what.priority:(\"1\", \"2\", \"3\", \"4\", \"5\")");
                this.query = sb.toString();
            }
            this.timeStart = timeStart;
            this.timeFinish = timeFinish;
            this.interval = interval;
        }

        public UpdateParams(String query, DisplayOptions displayOptions) {
            this.query = query;
            this.query = query;
            if (!query.contains("what.priority")) {
                StringBuilder sb = new StringBuilder();
                sb.append(query);
                sb.append(" AND what.priority:(\"1\", \"2\", \"3\", \"4\", \"5\")");
                this.query = sb.toString();
            }
            this.timeStart = displayOptions.getTimeStart();
            this.timeFinish = displayOptions.getTimeFinish();
            this.interval = displayOptions.getIntervalObj().getValue();
            this.displayOptions = displayOptions;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public long getTimeStart() {
            return this.timeStart;
        }

        public void setTimeStart(long timeStart) {
            this.timeStart = timeStart;
        }

        public long getTimeFinish() {
            return this.timeFinish;
        }

        public void setTimeFinish(long timeFinish) {
            this.timeFinish = timeFinish;
        }

        public String getInterval() {
            return this.interval;
        }

        public void setInterval(String interval) {
            this.interval = interval;
        }

        public DisplayOptions getDisplayOptions() {
            return this.displayOptions;
        }

        public void setDisplayOptions(DisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
        }
    }
}

