/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.gui.rawlogs.DisplayOptions;
import rs.co.ast.aspen.gui.rawlogs.widget.ByFieldPanel;
import rs.co.ast.aspen.gui.rawlogs.widget.Widget;
import rs.co.ast.aspen.gui.rawlogs.widget.WidgetButtonsPanel;
import rs.co.ast.aspen.gui.rawlogs.widget.WidgetSettingsPanel;

public class OverviewPanel
extends JPanel {
    public static final String RL_FILTER_OUT_QUERY = "RL_FILTER_OUT_QUERY";
    private List<Widget> widgets = new ArrayList<Widget>();
    private ByFieldPanel byFieldPanel;
    private WidgetSettingsPanel widgetSettingsPanel;
    private String search;
    private String searchForNext;
    private DisplayOptions displayOptions;
    private WidgetButtonsPanel widgetButtonsPanel = new WidgetButtonsPanel();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JScrollPane jScrollPane1;
    private JPanel pContents;

    public OverviewPanel() {
        this.initComponents();
        this.byFieldPanel = new ByFieldPanel();
        this.widgetSettingsPanel = new WidgetSettingsPanel();
        this.widgetSettingsPanel.getCbFields().addItem("source");
        this.widgets.add(this.byFieldPanel);
        this.pContents.setLayout(new BorderLayout());
        this.pContents.add((Component)this.widgetSettingsPanel, "North");
        this.pContents.add((Component)this.byFieldPanel, "Center");
        this.pContents.add((Component)this.widgetButtonsPanel, "South");
        this.pContents.validate();
        this.pContents.repaint();
        this.validate();
        this.repaint();
        this.widgetSettingsPanel.getbUpdate().addActionListener(e -> {
            this.byFieldPanel.setByFieldPanelTitle(this.widgetSettingsPanel.getSelectedField(), this.widgetSettingsPanel.getSortText(), this.widgetSettingsPanel.getNoSources());
            if (this.displayOptions != null) {
                this.searchForNext = this.search;
                this.byFieldPanel.update(new ByFieldPanel.UpdateParams(this.search, this.displayOptions, this.widgetSettingsPanel.getSelectedField(), this.widgetSettingsPanel.getSort(), this.widgetSettingsPanel.getNoSources()), this.displayOptions.getIntervalObj().getClazz());
            }
        });
        this.widgetButtonsPanel.getbFilterOut().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterOutParameters parameters = new FilterOutParameters(OverviewPanel.this, OverviewPanel.this.byFieldPanel.getRawLogValues(), OverviewPanel.this.widgetSettingsPanel.getSelectedField());
                if (!OverviewPanel.this.byFieldPanel.getRawLogValues().isEmpty()) {
                    OverviewPanel.this.propertyChangeSupport.firePropertyChange(OverviewPanel.RL_FILTER_OUT_QUERY, null, parameters);
                }
            }
        });
        this.widgetButtonsPanel.getbNext().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> rawLogValues = OverviewPanel.this.byFieldPanel.getRawLogValues();
                String selectedField = OverviewPanel.this.widgetSettingsPanel.getSelectedField();
                if (OverviewPanel.this.displayOptions != null && !rawLogValues.isEmpty()) {
                    StringBuilder query = new StringBuilder();
                    query.append(OverviewPanel.this.appendFilterOutQuery(OverviewPanel.this.searchForNext, rawLogValues, selectedField));
                    OverviewPanel.this.searchForNext = query.toString();
                    OverviewPanel.this.byFieldPanel.update(new ByFieldPanel.UpdateParams(OverviewPanel.this.searchForNext, OverviewPanel.this.displayOptions, OverviewPanel.this.widgetSettingsPanel.getSelectedField(), OverviewPanel.this.widgetSettingsPanel.getSort(), OverviewPanel.this.widgetSettingsPanel.getNoSources()), OverviewPanel.this.displayOptions.getIntervalObj().getClazz());
                }
            }
        });
        this.widgetButtonsPanel.getbExportExcel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkedHashMap<String, Long> countedRawLogsListByField = OverviewPanel.this.byFieldPanel.getCountedRawLogsListByField();
                OverviewPanel.this.exportToExcel(OverviewPanel.this.widgetSettingsPanel, countedRawLogsListByField);
            }
        });
        this.widgetButtonsPanel.getbExportCSV().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkedHashMap<String, Long> countedRawLogsListByField = OverviewPanel.this.byFieldPanel.getCountedRawLogsListByField();
                OverviewPanel.this.exportToCSV(countedRawLogsListByField);
            }
        });
    }

    public void setMappingsInWidgetSettigsPanels(Set<String> fields) {
        if (!fields.isEmpty()) {
            String sfLeft = this.widgetSettingsPanel.getSelectedField();
            this.widgetSettingsPanel.getCbFields().removeAllItems();
            fields.forEach(f -> this.widgetSettingsPanel.getCbFields().addItem((String)f));
            this.widgetSettingsPanel.getCbFields().setSelectedItem(sfLeft);
        }
    }

    public void update(String search, DisplayOptions displayOptions) {
        this.search = search;
        this.searchForNext = search;
        this.displayOptions = displayOptions;
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ByFieldPanel)) continue;
            widget.update(new ByFieldPanel.UpdateParams(search, displayOptions, this.widgetSettingsPanel.getSelectedField(), this.widgetSettingsPanel.getSort(), this.widgetSettingsPanel.getNoSources()), displayOptions.getIntervalObj().getClazz());
            this.byFieldPanel.setByFieldPanelTitle(this.widgetSettingsPanel.getSelectedField(), this.widgetSettingsPanel.getSortText(), this.widgetSettingsPanel.getNoSources());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToExcel(WidgetSettingsPanel widgetSettingsPanel, LinkedHashMap<String, Long> rawLogs) {
        if (!rawLogs.isEmpty()) {
            JFileChooser saveDialog = new JFileChooser();
            saveDialog.setDialogTitle("Export fields");
            saveDialog.setDialogType(1);
            saveDialog.setFileSelectionMode(1);
            int actionDialog = saveDialog.showSaveDialog(this);
            if (actionDialog == 0) {
                File file = new File(saveDialog.getSelectedFile().getAbsolutePath(), this.generateFileName("xlsx"));
                XSSFWorkbook workbook = this.makeWorkbook(rawLogs);
                if (workbook != null) {
                    try {
                        FileOutputStream fileWriter = new FileOutputStream(file);
                        workbook.write((OutputStream)fileWriter);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OverviewPanel.class, (String)"Overview.successfulExport.message"), 1));
                    }
                }
            }
        }
    }

    private XSSFWorkbook makeWorkbook(LinkedHashMap<String, Long> events) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(this.widgetSettingsPanel.getSelectedField());
        XSSFRow headerRow = sheet.createRow(0);
        Cell headerCell = headerRow.createCell(0);
        headerCell.setCellValue(this.widgetSettingsPanel.getSelectedField());
        headerCell = headerRow.createCell(1);
        headerCell.setCellValue("Count");
        Set<Map.Entry<String, Long>> entrySet = events.entrySet();
        Iterator<Map.Entry<String, Long>> it = entrySet.iterator();
        int rowCount = 1;
        while (it.hasNext()) {
            Map.Entry<String, Long> next = it.next();
            int columnCount = 0;
            XSSFRow row = sheet.createRow(rowCount++);
            Cell cell = row.createCell(columnCount++);
            cell.setCellValue(next.getKey());
            cell = row.createCell(columnCount);
            cell.setCellValue(next.getValue() != null ? String.format("%,d", next.getValue()) : "");
        }
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToCSV(LinkedHashMap<String, Long> events) {
        if (!events.isEmpty()) {
            JFileChooser saveDialog = new JFileChooser();
            saveDialog.setDialogTitle("Export fields");
            saveDialog.setDialogType(1);
            saveDialog.setFileSelectionMode(1);
            int actionDialog = saveDialog.showSaveDialog(this);
            if (actionDialog == 0) {
                File file = new File(saveDialog.getSelectedFile().getAbsolutePath(), this.generateFileName("csv"));
                StringBuilder sb = this.buildStringForCSVFile(this.widgetSettingsPanel, events);
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    writer.write(sb.toString());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OverviewPanel.class, (String)"Overview.successfulExport.message"), 1));
                }
            }
        }
    }

    private StringBuilder buildStringForCSVFile(WidgetSettingsPanel widgetSettingsPanel, LinkedHashMap<String, Long> rawLogs) {
        String separator = ";";
        StringBuilder sb = new StringBuilder();
        sb.append(widgetSettingsPanel.getSelectedField());
        sb.append(separator);
        sb.append("Count");
        sb.append(System.getProperty("line.separator"));
        Set<Map.Entry<String, Long>> entrySet = rawLogs.entrySet();
        for (Map.Entry<String, Long> next : entrySet) {
            sb.append((Object)next.getKey());
            sb.append(separator);
            sb.append(next.getValue() != null ? String.format("%,d", next.getValue()) : "");
            sb.append(System.getProperty("line.separator"));
        }
        return sb;
    }

    private String generateFileName(String fileExtension) {
        DateTime startDate = new DateTime(this.displayOptions.getTimeStart());
        DateTime finishDate = new DateTime(this.displayOptions.getTimeFinish());
        DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
        String title = String.format("%s %d events by %s", this.widgetSettingsPanel.getSortText(), this.widgetSettingsPanel.getNoSources(), this.widgetSettingsPanel.getSelectedField());
        title = title.replaceAll("\\s+", "").toLowerCase();
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append("_").append(startDate.toString(dtf));
        sb.append(finishDate.toString(dtf));
        sb.append(String.valueOf(System.currentTimeMillis()));
        sb.append(".").append(fileExtension);
        return sb.toString();
    }

    private String appendFilterOutQuery(String actualQuery, List<String> values, String field) {
        int i;
        StringBuilder sb = new StringBuilder();
        int startIndex = -1;
        int endIndex = -1;
        String[] split = field.split("\\.");
        Pattern pattern = null;
        pattern = field.contains(".") ? Pattern.compile(split[0] + "\\." + split[1] + ":\\(") : Pattern.compile(field + ":\\(");
        Matcher matcher = pattern.matcher(actualQuery);
        while (matcher.find()) {
            startIndex = matcher.end();
        }
        if (startIndex != -1) {
            for (i = startIndex; i < actualQuery.length(); ++i) {
                if (actualQuery.charAt(i) != ')') continue;
                endIndex = i;
                break;
            }
        }
        if (endIndex != -1) {
            sb.append(actualQuery.substring(0, endIndex));
            sb.append(", ");
            for (i = 0; i < values.size(); ++i) {
                sb.append("\"");
                if (values.get(i).contains("\\")) {
                    val = values.get(i).replace("\\", "\\\\");
                    sb.append(val);
                } else if (values.get(i).contains("\"")) {
                    val = values.get(i).replace("\"", "\\\"");
                    sb.append(val);
                } else {
                    sb.append(values.get(i));
                }
                sb.append("\"");
                if (i == values.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(actualQuery.substring(endIndex));
        } else {
            sb.append(actualQuery);
            sb.append(" AND ");
            sb.append(this.makeFilterOutQuery(values, field));
        }
        return sb.toString();
    }

    private String makeFilterOutQuery(List<String> values, String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("NOT ");
        sb.append(field);
        sb.append(":(");
        for (int i = 0; i < values.size(); ++i) {
            sb.append("\"");
            if (values.get(i).contains("\\")) {
                val = values.get(i).replace("\\", "\\\\");
                sb.append(val);
            } else if (values.get(i).contains("\"")) {
                val = values.get(i).replace("\"", "\\\"");
                sb.append(val);
            } else {
                sb.append(values.get(i));
            }
            sb.append("\"");
            if (i == values.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public ByFieldPanel getByFieldPanel() {
        return this.byFieldPanel;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pContents = new JPanel();
        GroupLayout pContentsLayout = new GroupLayout(this.pContents);
        this.pContents.setLayout(pContentsLayout);
        pContentsLayout.setHorizontalGroup(pContentsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 707, Short.MAX_VALUE));
        pContentsLayout.setVerticalGroup(pContentsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 441, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.pContents);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addContainerGap()));
    }

    class FilterOutParameters {
        private List<String> events;
        private String field;

        public FilterOutParameters(OverviewPanel this$0, List<String> events, String field) {
            this.events = events;
            this.field = field;
        }

        public List<String> getEvents() {
            return this.events;
        }

        public String getField() {
            return this.field;
        }
    }
}

