/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.actions;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.RuleSetBackupContainerDTO;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.gui.module.prseditor.JSONFileFilter;
import rs.co.ast.aspen.gui.module.prseditor.actions.DuplicateRulePanel;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RootNode;

public final class AddRuleSet
implements ActionListener {
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final RootNode node;
    private Dialog dialog;

    public AddRuleSet(RootNode node) {
        this.node = node;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        JFileChooser openFileDialog = new JFileChooser();
        openFileDialog.setFileFilter(new JSONFileFilter());
        openFileDialog.setAcceptAllFileFilterUsed(false);
        boolean isRightFile = false;
        while (!isRightFile) {
            int result = openFileDialog.showOpenDialog(WindowManager.getDefault().getMainWindow());
            if (result == 0) {
                try (FileInputStream is = new FileInputStream(openFileDialog.getSelectedFile());){
                    final RuleSetBackupContainerDTO rsbc = (RuleSetBackupContainerDTO)this.mapper.readValue((InputStream)is, RuleSetBackupContainerDTO.class);
                    if (rsbc.getRulesets().size() == 1) {
                        isRightFile = true;
                        boolean isDuplicate = this.model.checkDuplicate(rsbc);
                        if (isDuplicate) {
                            final JButton ok = new JButton("OK");
                            final DuplicateRulePanel panel = new DuplicateRulePanel();
                            DialogDescriptor des = new DialogDescriptor((Object)panel, NbBundle.getMessage(AddRuleSet.class, (String)"AddRuleSet.DuplicateRulePanel.title"), false, new Object[]{ok, DialogDescriptor.CANCEL_OPTION}, (Object)ok, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (e.getSource().equals(ok)) {
                                        if (panel.getRbReplaceRuleSet().isSelected()) {
                                            AddRuleSet.this.model.replaceRuleSet(rsbc);
                                            AddRuleSet.this.dialog.setVisible(false);
                                            AddRuleSet.this.dialog.dispose();
                                        } else {
                                            String tfNewRuleSetNameText = panel.getTfNewRuleSetNameText();
                                            if (!tfNewRuleSetNameText.isEmpty()) {
                                                AddRuleSet.this.model.addRuleSet(rsbc, tfNewRuleSetNameText);
                                                AddRuleSet.this.dialog.setVisible(false);
                                                AddRuleSet.this.dialog.dispose();
                                            } else {
                                                JOptionPane.showMessageDialog(panel, NbBundle.getMessage(AddRuleSet.class, (String)"AddRuleSet.emptyRuleSetName.message"));
                                            }
                                        }
                                    }
                                }
                            });
                            this.dialog = DialogDisplayer.getDefault().createDialog(des);
                            this.dialog.setVisible(true);
                            continue;
                        }
                        this.model.addRuleSet(rsbc);
                        continue;
                    }
                    JOptionPane.showMessageDialog(null, NbBundle.getMessage(AddRuleSet.class, (String)"AddRuleSet.choosedWrongFile.message"), "Error", 0);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                continue;
            }
            isRightFile = true;
        }
    }
}

