/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.jsoneditor;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.JsonTransformPattern;
import rs.co.ast.aspen.gui.module.jsoneditor.JsonFileFilter;

@TopComponent.Description(preferredID="JsonParserEditorTopComponent", iconBase="json-rule.png", persistenceType=1)
public final class JsonParserEditorTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(JsonParserEditorTopComponent.class.getName());
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true).configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
    private final RSyntaxTextArea taScriptText;
    private JButton bBeautify;
    private JButton bExport;
    private JButton bImport;
    private JButton bReset;
    private JButton bSave;
    private JButton bValidate;
    private JPanel cp;
    private JLabel jLabel1;
    private JTextField tfSearch;

    public JsonParserEditorTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"CTL_JsonParserEditorTopComponent"));
        this.setToolTipText(NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"HINT_JsonParserEditorTopComponent"));
        this.taScriptText = new RSyntaxTextArea(20, 60);
        this.taScriptText.setTabSize(4);
        this.taScriptText.setCodeFoldingEnabled(true);
        this.taScriptText.setSyntaxEditingStyle("text/json");
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.taScriptText);
        this.cp.add((Component)sp);
    }

    private void initComponents() {
        this.cp = new JPanel();
        this.bSave = new JButton();
        this.bReset = new JButton();
        this.bExport = new JButton();
        this.bImport = new JButton();
        this.bValidate = new JButton();
        this.bBeautify = new JButton();
        this.tfSearch = new JTextField();
        this.jLabel1 = new JLabel();
        this.cp.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.bSave, (String)NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"JsonParserEditorTopComponent.bSave.text"));
        this.bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JsonParserEditorTopComponent.this.bSaveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bReset, (String)NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"JsonParserEditorTopComponent.bReset.text"));
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JsonParserEditorTopComponent.this.bResetActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"JsonParserEditorTopComponent.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JsonParserEditorTopComponent.this.bExportActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bImport, (String)NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"JsonParserEditorTopComponent.bImport.text"));
        this.bImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JsonParserEditorTopComponent.this.bImportActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bValidate, (String)NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"JsonParserEditorTopComponent.bValidate.text"));
        this.bValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JsonParserEditorTopComponent.this.bValidateActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bBeautify, (String)NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"JsonParserEditorTopComponent.bBeautify.text"));
        this.bBeautify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JsonParserEditorTopComponent.this.bBeautifyActionPerformed(evt);
            }
        });
        this.tfSearch.setText(NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"JsonParserEditorTopComponent.tfSearch.text", (Object[])new Object[0]));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JsonParserEditorTopComponent.this.tfSearchActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"JsonParserEditorTopComponent.jLabel1.text", (Object[])new Object[0]));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cp, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.bExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bImport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bValidate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bBeautify).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 517, Short.MAX_VALUE).addComponent(this.bSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bReset)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSearch, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cp, -1, 666, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bSave).addComponent(this.bReset).addComponent(this.bExport).addComponent(this.bImport).addComponent(this.bValidate).addComponent(this.bBeautify)).addContainerGap()));
    }

    private void bExportActionPerformed(ActionEvent evt) {
        if (!this.taScriptText.getText().isEmpty()) {
            JFileChooser saveFileDialog = new JFileChooser();
            saveFileDialog.setFileFilter(new JsonFileFilter());
            saveFileDialog.setAcceptAllFileFilterUsed(false);
            int result = saveFileDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
            if (result == 0) {
                try (FileOutputStream st = new FileOutputStream(String.valueOf(saveFileDialog.getSelectedFile()) + "." + JsonFileFilter.getExtension());){
                    ((OutputStream)st).write(this.taScriptText.getText().getBytes());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void bImportActionPerformed(ActionEvent evt) {
        JFileChooser openFileDialog = new JFileChooser();
        openFileDialog.setFileFilter(new JsonFileFilter());
        openFileDialog.setAcceptAllFileFilterUsed(false);
        int result = openFileDialog.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (result == 0) {
            try (BufferedReader reader = new BufferedReader(new FileReader(openFileDialog.getSelectedFile()));){
                String text;
                StringBuilder sb = new StringBuilder();
                while ((text = reader.readLine()) != null) {
                    sb.append(text).append("\n");
                }
                this.apiService.updateJsonParserRules(sb.toString());
                this.taScriptText.setText(this.apiService.getJsonParserRules().getJson());
            }
            catch (IOException | ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void bValidateActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Message nd;
        try {
            this.mapper.readTree(this.taScriptText.getText());
            nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"JsonParserEditorTopComponent.validation.valid_message"), 1);
        }
        catch (IOException ex) {
            nd = new NotifyDescriptor.Message((Object)String.format(NbBundle.getMessage(JsonParserEditorTopComponent.class, (String)"JsonParserEditorTopComponent.validation.invalid_message"), ex.getMessage()), 0);
            Exceptions.printStackTrace((Throwable)ex);
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private void bBeautifyActionPerformed(ActionEvent evt) {
        try {
            Object json = this.mapper.readValue(this.taScriptText.getText(), Object.class);
            String preatyJson = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
            this.taScriptText.setText(preatyJson);
            this.taScriptText.setCaretPosition(0);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bResetActionPerformed(ActionEvent evt) {
        try {
            JsonTransformPattern jsonParserRules = this.apiService.getJsonParserRules();
            this.taScriptText.setText(jsonParserRules.getJson());
            this.taScriptText.setCaretPosition(0);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bSaveActionPerformed(ActionEvent evt) {
        try {
            this.apiService.updateJsonParserRules(this.taScriptText.getText());
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void search() {
        if (this.tfSearch.getText().isEmpty()) {
            this.taScriptText.setCaretPosition(0);
        }
        SearchContext context = new SearchContext();
        context.setSearchFor(this.tfSearch.getText());
        context.setMatchCase(false);
        context.setRegularExpression(true);
        context.setSearchForward(true);
        context.setWholeWord(false);
        context.setMarkAll(true);
        SearchEngine.find((JTextArea)this.taScriptText, (SearchContext)context);
    }

    public void componentOpened() {
        try {
            JsonTransformPattern jsonParserRules = this.apiService.getJsonParserRules();
            this.taScriptText.setText(jsonParserRules.getJson());
            this.taScriptText.setCaretPosition(0);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

