/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.joda.time.DateTime;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.LogFile;
import rs.co.ast.aspen.api.service.PrometheusProcessStatus;

@TopComponent.Description(preferredID="PingTopComponent", iconBase="debugging.png", persistenceType=0)
public final class PingTopComponent
extends TopComponent {
    private static final long TIMEOUT = 60000L;
    private static final Logger logger = Logger.getLogger(PingTopComponent.class.getName());
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private CountDownLatch latch;
    private ScheduledExecutorService executor;
    private RSyntaxTextArea taLog;
    private JButton bElasticStatus;
    private JButton bPing;
    private JButton bScriptsLog;
    private JButton bServerLog;
    private JButton bServerStatus;
    private JButton bTomcatLog;
    private JPanel cp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lLastModified;
    private JLabel lLogCreationTime;
    private JPanel pLogs;
    private JPanel pPing;
    private JSpinner sDelay;
    private JSpinner sNumberOfLines;
    private JSpinner sRepeat;
    private JSpinner sSize;
    private JSpinner sThreads;
    private JTextArea tLog;
    private JTextArea taResults;
    private JTabbedPane tabbedPane;
    private JTextField tfSearch;

    public PingTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(PingTopComponent.class, (String)"CTL_PingTopComponent"));
        this.setToolTipText(NbBundle.getMessage(PingTopComponent.class, (String)"HINT_PingTopComponent"));
        this.taLog = new RSyntaxTextArea(20, 60);
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.taLog);
        this.cp.add((Component)sp);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.tLog = new JTextArea();
        this.tabbedPane = new JTabbedPane();
        this.pLogs = new JPanel();
        this.bTomcatLog = new JButton();
        this.bServerLog = new JButton();
        this.bScriptsLog = new JButton();
        this.sNumberOfLines = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.lLastModified = new JLabel();
        this.lLogCreationTime = new JLabel();
        this.cp = new JPanel();
        this.jLabel8 = new JLabel();
        this.tfSearch = new JTextField();
        this.bElasticStatus = new JButton();
        this.bServerStatus = new JButton();
        this.pPing = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.sSize = new JSpinner();
        this.jLabel2 = new JLabel();
        this.sDelay = new JSpinner();
        this.jLabel3 = new JLabel();
        this.sRepeat = new JSpinner();
        this.bPing = new JButton();
        this.jLabel5 = new JLabel();
        this.sThreads = new JSpinner();
        this.jScrollPane1 = new JScrollPane();
        this.taResults = new JTextArea();
        this.jLabel4 = new JLabel();
        this.tLog.setEditable(false);
        this.tLog.setColumns(20);
        this.tLog.setRows(5);
        this.tLog.setTabSize(4);
        this.jScrollPane2.setViewportView(this.tLog);
        Mnemonics.setLocalizedText((AbstractButton)this.bTomcatLog, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.bTomcatLog.text"));
        this.bTomcatLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PingTopComponent.this.bTomcatLogActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bServerLog, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.bServerLog.text"));
        this.bServerLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PingTopComponent.this.bServerLogActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bScriptsLog, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.bScriptsLog.text"));
        this.bScriptsLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PingTopComponent.this.bScriptsLogActionPerformed(evt);
            }
        });
        this.sNumberOfLines.setModel(new SpinnerNumberModel(100, 100, 100000, 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.jLabel6.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.jLabel7.text"));
        Mnemonics.setLocalizedText((JLabel)this.lLastModified, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.lLastModified.text"));
        Mnemonics.setLocalizedText((JLabel)this.lLogCreationTime, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.lLogCreationTime.text"));
        this.cp.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.jLabel8.text"));
        this.tfSearch.setText(NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.tfSearch.text"));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PingTopComponent.this.tfSearchActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bElasticStatus, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.bElasticStatus.text"));
        this.bElasticStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PingTopComponent.this.bElasticStatusActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bServerStatus, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.bServerStatus.text"));
        this.bServerStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PingTopComponent.this.bServerStatusActionPerformed(evt);
            }
        });
        GroupLayout pLogsLayout = new GroupLayout(this.pLogs);
        this.pLogs.setLayout(pLogsLayout);
        pLogsLayout.setHorizontalGroup(pLogsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLogsLayout.createSequentialGroup().addContainerGap().addGroup(pLogsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cp, -1, -1, Short.MAX_VALUE).addGroup(pLogsLayout.createSequentialGroup().addComponent(this.sNumberOfLines, -2, -1, -2).addGap(18, 18, 18).addComponent(this.bServerLog).addGap(18, 18, 18).addComponent(this.bTomcatLog).addGap(18, 18, 18).addComponent(this.bScriptsLog).addGap(18, 18, 18).addComponent(this.bElasticStatus).addGap(18, 18, 18).addComponent(this.bServerStatus).addGap(0, 94, Short.MAX_VALUE)).addGroup(pLogsLayout.createSequentialGroup().addGroup(pLogsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pLogsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lLastModified, -1, 241, Short.MAX_VALUE).addComponent(this.lLogCreationTime, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfSearch))).addContainerGap()));
        pLogsLayout.setVerticalGroup(pLogsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pLogsLayout.createSequentialGroup().addContainerGap().addGroup(pLogsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sNumberOfLines, -2, -1, -2).addComponent(this.bServerLog).addComponent(this.bTomcatLog).addComponent(this.bScriptsLog).addComponent(this.bElasticStatus).addComponent(this.bServerStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLogsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lLastModified, -2, 16, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLogsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLogsLayout.createSequentialGroup().addGroup(pLogsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.lLogCreationTime, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cp, -1, 487, Short.MAX_VALUE)).addGroup(pLogsLayout.createSequentialGroup().addGroup(pLogsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.tfSearch, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.tabbedPane.addTab(NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.pLogs.TabConstraints.tabTitle"), this.pLogs);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.jPanel1.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.jLabel1.text"));
        this.sSize.setModel(new SpinnerNumberModel(10, 0, 100000, 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.jLabel2.text"));
        this.sDelay.setModel(new SpinnerNumberModel((Number)1L, Long.valueOf(1L), Long.valueOf(100000L), (Number)1L));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.jLabel3.text"));
        this.sRepeat.setModel(new SpinnerNumberModel(1, 1, 100000, 1));
        Mnemonics.setLocalizedText((AbstractButton)this.bPing, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.bPing.text"));
        this.bPing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PingTopComponent.this.bPingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.jLabel5.text"));
        this.sThreads.setModel(new SpinnerNumberModel(6, 1, 50, 1));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addGap(6, 6, 6).addComponent(this.sThreads).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sDelay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sRepeat).addGap(18, 18, 18).addComponent(this.bPing, -2, 101, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.sSize, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.sDelay, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.sRepeat, -2, -1, -2).addComponent(this.bPing).addComponent(this.jLabel5).addComponent(this.sThreads, -2, -1, -2)).addContainerGap(26, Short.MAX_VALUE)));
        this.taResults.setEditable(false);
        this.taResults.setColumns(20);
        this.taResults.setRows(5);
        this.taResults.setTabSize(4);
        this.taResults.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.taResults);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.jLabel4.text"));
        GroupLayout pPingLayout = new GroupLayout(this.pPing);
        this.pPing.setLayout(pPingLayout);
        pPingLayout.setHorizontalGroup(pPingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pPingLayout.createSequentialGroup().addContainerGap().addGroup(pPingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addContainerGap()).addGroup(pPingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pPingLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel4).addGap(0, 0, Short.MAX_VALUE))));
        pPingLayout.setVerticalGroup(pPingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pPingLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 470, Short.MAX_VALUE).addContainerGap()).addGroup(pPingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pPingLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel4).addGap(0, 0, Short.MAX_VALUE))));
        this.tabbedPane.addTab(NbBundle.getMessage(PingTopComponent.class, (String)"PingTopComponent.pPing.TabConstraints.tabTitle"), this.pPing);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane));
    }

    private void bPingActionPerformed(ActionEvent evt) {
        this.bPing.setEnabled(false);
        this.taResults.setText("");
        int repeat = (Integer)this.sRepeat.getValue();
        long delay = (Long)this.sDelay.getValue();
        long oldDelay = 0L;
        int threads = (Integer)this.sThreads.getValue();
        this.latch = new CountDownLatch(repeat);
        this.executor = Executors.newScheduledThreadPool(threads);
        for (int i = 0; i <= repeat; ++i) {
            logger.info(String.format("%d scheduled task", repeat));
            this.executor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        long start = System.currentTimeMillis();
                        final List bytes = PingTopComponent.this.apiService.ping(((Integer)PingTopComponent.this.sSize.getModel().getValue()).intValue());
                        long finish = System.currentTimeMillis();
                        final long time = finish - start;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String text = PingTopComponent.this.taResults.getText() + System.lineSeparator() + String.format("%d. size: %s, time: %d ms", PingTopComponent.this.latch.getCount(), String.valueOf(bytes.size()), time);
                                PingTopComponent.this.taResults.setText(text);
                            }
                        });
                    }
                    catch (ApiServiceException_Exception ex) {
                        PingTopComponent.this.taResults.setText("error!" + ex.getMessage());
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        PingTopComponent.this.latch.countDown();
                    }
                }
            }, oldDelay, TimeUnit.MILLISECONDS);
            oldDelay = (long)(i / threads) * delay;
        }
        this.executor.shutdown();
        Thread twait = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PingTopComponent.this.latch.await();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PingTopComponent.this.bPing.setEnabled(true);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        twait.start();
    }

    private void bServerLogActionPerformed(ActionEvent evt) {
        try {
            LogFile serverLog = this.apiService.getServerLog(((Integer)this.sNumberOfLines.getValue()).intValue());
            if (serverLog.getFile() != null) {
                this.taLog.setText(new String(serverLog.getFile(), "UTF-8"));
                this.lLastModified.setText(new DateTime(serverLog.getLastModified()).toString());
                this.lLogCreationTime.setText(new DateTime(serverLog.getCreationTime()).toString());
            }
        }
        catch (UnsupportedEncodingException | ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bTomcatLogActionPerformed(ActionEvent evt) {
        try {
            LogFile tomcatLog = this.apiService.getTomcatLog(((Integer)this.sNumberOfLines.getValue()).intValue());
            if (tomcatLog.getFile() != null) {
                this.taLog.setText(new String(tomcatLog.getFile(), "UTF-8"));
                this.lLastModified.setText(new DateTime(tomcatLog.getLastModified()).toString());
                this.lLogCreationTime.setText(new DateTime(tomcatLog.getCreationTime()).toString());
            }
        }
        catch (UnsupportedEncodingException | ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bScriptsLogActionPerformed(ActionEvent evt) {
        try {
            LogFile scriptsLog = this.apiService.getScriptsLog(((Integer)this.sNumberOfLines.getValue()).intValue());
            if (scriptsLog.getFile() != null) {
                this.taLog.setText(new String(scriptsLog.getFile(), "UTF-8"));
                this.lLastModified.setText(new DateTime(scriptsLog.getLastModified()).toString());
                this.lLogCreationTime.setText(new DateTime(scriptsLog.getCreationTime()).toString());
            }
        }
        catch (UnsupportedEncodingException | ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        if (this.tfSearch.getText().isEmpty()) {
            this.taLog.setCaretPosition(0);
        }
        SearchContext context = new SearchContext();
        context.setSearchFor(this.tfSearch.getText());
        context.setMatchCase(false);
        context.setRegularExpression(true);
        context.setSearchForward(true);
        context.setWholeWord(false);
        context.setMarkAll(true);
        SearchResult find = SearchEngine.find((JTextArea)this.taLog, (SearchContext)context);
        if (find.getMatchRange() == null) {
            this.taLog.setCaretPosition(0);
            SearchEngine.find((JTextArea)this.taLog, (SearchContext)context);
        }
    }

    private void bElasticStatusActionPerformed(ActionEvent evt) {
        try {
            String esStatus = this.apiService.getSearchClusterHealthStats();
            this.taLog.setText(esStatus);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bServerStatusActionPerformed(ActionEvent evt) {
        try {
            List monitorStats = this.apiService.getMonitorStats();
            Collections.sort(monitorStats, (o1, o2) -> o1.getProcessName().compareTo(o2.getProcessName()));
            if (!monitorStats.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (PrometheusProcessStatus pps : monitorStats) {
                    if (!pps.getProcessName().toLowerCase().contains("status")) continue;
                    sb.append(pps.getProcessName()).append(" ");
                    sb.append(String.valueOf(pps.getValue())).append("\n");
                }
                this.taLog.setText(sb.toString());
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

