/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.search.ClientSpecificQuery;
import rs.co.ast.aspen.gui.module.securityevents.widget.ByFieldPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.ByPriorityPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.Widget;
import rs.co.ast.aspen.gui.module.securityevents.widget.WidgetButtonsPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.WidgetSettingsPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.WidgetUpdateWorker;

public class OverviewPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(OverviewPanel.class.getName());
    public static final String FILTER_OUT_QUERY = "FILTER_OUT_QUERY";
    private ExecutorService executor;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private ByPriorityPanel byPriorityPanel;
    private ByFieldPanel byFieldPanelBottom;
    private ByFieldPanel byFieldPanelTop;
    private final String byPriority = NbBundle.getMessage(OverviewPanel.class, (String)"widget.eventsByPriority.title");
    private final String drawingWidget = NbBundle.getMessage(ByPriorityPanel.class, (String)"Widgets.progress.title");
    private WidgetSettingsPanel widgetSettingsPanelTop = new WidgetSettingsPanel();
    private WidgetSettingsPanel widgetSettingsPanelBottom = new WidgetSettingsPanel();
    private WidgetButtonsPanel widgetButtonsPanelTop = new WidgetButtonsPanel();
    private WidgetButtonsPanel widgetButtonsPanelBottom = new WidgetButtonsPanel();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String search;
    private Set<String> fieldsForNextT = new HashSet<String>();
    private Set<String> fieldsForNextB = new HashSet<String>();
    private Set<String> fieldsForEnforcePrecision = new HashSet<String>();
    private DisplayOptions displayOptions;
    private DisplayOptions displayOptionsExtendedTop;
    private DisplayOptions displayOptionsTop;
    private DisplayOptions displayOptionsExtendedBottom;
    private DisplayOptions displayOptionsBottom;
    private JXTaskPane tp1;
    private JXTaskPane tpTop;
    private JXTaskPane tpBottom;
    private final List<String> listOfCharactersToEscape = Arrays.asList("\\", "+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":");
    private String user;
    private JScrollPane jScrollPane1;
    private JPanel pContents;

    public OverviewPanel() {
        this.initComponents();
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.widgetSettingsPanelBottom.getCbFields().addItem("where.hostname");
        this.widgetSettingsPanelTop.getCbFields().addItem("what.text");
        this.widgetSettingsPanelBottom.getCbFields().setSelectedItem("where.hostname");
        this.widgetSettingsPanelTop.getCbFields().setSelectedItem("what.text");
        this.byPriorityPanel = new ByPriorityPanel();
        this.byFieldPanelTop = new ByFieldPanel();
        this.byFieldPanelBottom = new ByFieldPanel();
        this.widgets.add(this.byPriorityPanel);
        this.widgets.add(this.byFieldPanelTop);
        this.widgets.add(this.byFieldPanelBottom);
        JXTaskPaneContainer tpcTop = new JXTaskPaneContainer();
        JXTaskPaneContainer tpcBottom = new JXTaskPaneContainer();
        JPanel panelTop = new JPanel();
        panelTop.setLayout(new BorderLayout());
        panelTop.add((Component)tpcTop, "North");
        JPanel panelOther = new JPanel();
        panelOther.setLayout(new BorderLayout());
        panelOther.add((Component)tpcTop, "North");
        panelOther.add((Component)tpcBottom, "Center");
        this.pContents.setLayout(new BorderLayout());
        this.pContents.add((Component)panelTop, "North");
        this.pContents.add((Component)panelOther, "Center");
        this.tp1 = new JXTaskPane();
        this.tp1.setTitle(this.byPriority);
        this.tp1.add((Component)this.byPriorityPanel);
        tpcTop.add((Component)this.tp1);
        this.tp1.setCollapsed(true);
        this.tpTop = new JXTaskPane();
        this.setTopTaskPaneTitle();
        this.tpTop.add((Component)this.widgetSettingsPanelTop);
        this.tpTop.add((Component)this.byFieldPanelTop);
        this.tpTop.add((Component)this.widgetButtonsPanelTop);
        tpcTop.add((Component)this.tpTop);
        this.tpBottom = new JXTaskPane();
        this.setBottomTaskPaneTitle();
        this.tpBottom.add((Component)this.widgetSettingsPanelBottom);
        this.tpBottom.add((Component)this.byFieldPanelBottom);
        this.tpBottom.add((Component)this.widgetButtonsPanelBottom);
        tpcBottom.add((Component)this.tpBottom);
        this.tpBottom.setCollapsed(true);
        this.widgetSettingsPanelTop.getbUpdate().addActionListener(e -> {
            if (this.displayOptions != null) {
                this.fieldsForNextT.clear();
                ExecutorService buttonExecutor = Executors.newSingleThreadExecutor();
                this.setTopTaskPaneTitle();
                buttonExecutor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(this.search, this.displayOptions).setField(this.widgetSettingsPanelTop.getSelectedField()).setSort(this.widgetSettingsPanelTop.getSort()).setNoSources(this.widgetSettingsPanelTop.getNoSources()).setIsClickedNext(false), String.format("%s ( %s )", this.drawingWidget, this.tpTop.getTitle()), this.byFieldPanelTop, this.displayOptions));
                buttonExecutor.shutdown();
                this.setDefaultNoSourcesWhenItsNotPredefinedNo(this.widgetSettingsPanelTop);
                this.displayOptionsExtendedTop = this.deepCopyOfDisplayOptions(this.displayOptions);
                this.displayOptionsTop = this.deepCopyOfDisplayOptions(this.displayOptions);
            }
        });
        this.widgetSettingsPanelBottom.getbUpdate().addActionListener(e -> {
            if (this.displayOptions != null) {
                this.fieldsForNextB.clear();
                ExecutorService buttonExecutor = Executors.newSingleThreadExecutor();
                this.setBottomTaskPaneTitle();
                buttonExecutor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(this.search, this.displayOptions).setField(this.widgetSettingsPanelBottom.getSelectedField()).setSort(this.widgetSettingsPanelBottom.getSort()).setNoSources(this.widgetSettingsPanelBottom.getNoSources()).setIsClickedNext(false), String.format(" %s ( %s )", this.drawingWidget, this.tpBottom.getTitle()), this.byFieldPanelBottom, this.displayOptions));
                buttonExecutor.shutdown();
                this.setDefaultNoSourcesWhenItsNotPredefinedNo(this.widgetSettingsPanelBottom);
                this.displayOptionsExtendedBottom = this.deepCopyOfDisplayOptions(this.displayOptions);
                this.displayOptionsBottom = this.deepCopyOfDisplayOptions(this.displayOptions);
            }
        });
        this.widgetSettingsPanelTop.getbPreviousTimeFrame().addActionListener(al -> this.extendWidgetSearchData(this.byFieldPanelTop, this.widgetSettingsPanelTop, this.displayOptionsExtendedTop, this.displayOptionsTop, this.tpTop, false, Orientation.T));
        this.widgetSettingsPanelTop.getbNextTimeFrame().addActionListener(al -> this.extendWidgetSearchData(this.byFieldPanelTop, this.widgetSettingsPanelTop, this.displayOptionsExtendedTop, this.displayOptionsTop, this.tpTop, true, Orientation.T));
        this.widgetSettingsPanelBottom.getbPreviousTimeFrame().addActionListener(al -> this.extendWidgetSearchData(this.byFieldPanelBottom, this.widgetSettingsPanelBottom, this.displayOptionsExtendedBottom, this.displayOptionsBottom, this.tpBottom, false, Orientation.B));
        this.widgetSettingsPanelBottom.getbNextTimeFrame().addActionListener(al -> this.extendWidgetSearchData(this.byFieldPanelBottom, this.widgetSettingsPanelBottom, this.displayOptionsExtendedBottom, this.displayOptionsBottom, this.tpBottom, true, Orientation.B));
        this.widgetButtonsPanelTop.getbFilterOut().addActionListener(e -> {
            FilterParameters parameters = new FilterParameters(this, this.byFieldPanelTop.getEventsListByField(), this.widgetSettingsPanelTop.getSelectedField());
            if (!this.byFieldPanelTop.getEventsListByField().isEmpty()) {
                this.propertyChangeSupport.firePropertyChange(FILTER_OUT_QUERY, null, parameters);
            }
        });
        this.widgetButtonsPanelBottom.getbFilterOut().addActionListener(e -> {
            FilterParameters parameters = new FilterParameters(this, this.byFieldPanelBottom.getEventsListByField(), this.widgetSettingsPanelBottom.getSelectedField());
            if (!this.byFieldPanelBottom.getEventsListByField().isEmpty()) {
                this.propertyChangeSupport.firePropertyChange(FILTER_OUT_QUERY, null, parameters);
            }
        });
        this.widgetButtonsPanelTop.getbExportExcel().addActionListener(e -> {
            LinkedHashMap<String, Long> countedEventListByField = this.byFieldPanelTop.getCountedEventListByField();
            this.exportToExcel(this.widgetSettingsPanelTop, countedEventListByField, Orientation.T);
        });
        this.widgetButtonsPanelBottom.getbExportExcel().addActionListener(e -> {
            LinkedHashMap<String, Long> countedEventListByField = this.byFieldPanelBottom.getCountedEventListByField();
            this.exportToExcel(this.widgetSettingsPanelBottom, countedEventListByField, Orientation.B);
        });
        this.widgetButtonsPanelTop.getbExportCSV().addActionListener(e -> {
            LinkedHashMap<String, Long> countedEventListByField = this.byFieldPanelTop.getCountedEventListByField();
            this.exportToCSV(this.widgetSettingsPanelTop, countedEventListByField, Orientation.T);
        });
        this.widgetButtonsPanelBottom.getbExportCSV().addActionListener(e -> {
            LinkedHashMap<String, Long> countedEventListByField = this.byFieldPanelBottom.getCountedEventListByField();
            this.exportToCSV(this.widgetSettingsPanelBottom, countedEventListByField, Orientation.B);
        });
        this.widgetButtonsPanelTop.getbNext().addActionListener(al -> this.filter(this.byFieldPanelTop, this.widgetSettingsPanelTop, this.fieldsForNextT, this.tpTop, true, false, Orientation.T));
        this.widgetButtonsPanelBottom.getbNext().addActionListener(al -> this.filter(this.byFieldPanelBottom, this.widgetSettingsPanelBottom, this.fieldsForNextB, this.tpBottom, true, false, Orientation.B));
        this.widgetButtonsPanelTop.getbEnforcePrecision().addActionListener(al -> {
            this.filter(this.byFieldPanelTop, this.widgetSettingsPanelTop, this.fieldsForEnforcePrecision, this.tpTop, false, true, Orientation.T);
            this.fieldsForEnforcePrecision.clear();
        });
        this.widgetButtonsPanelBottom.getbEnforcePrecision().addActionListener(al -> {
            this.filter(this.byFieldPanelBottom, this.widgetSettingsPanelBottom, this.fieldsForEnforcePrecision, this.tpBottom, false, true, Orientation.B);
            this.fieldsForEnforcePrecision.clear();
        });
    }

    public void extendWidgetSearchData(ByFieldPanel byFieldPanel, WidgetSettingsPanel widgetSettingsPanel, DisplayOptions displayOptions, DisplayOptions secondDisplayOptions, JXTaskPane taskPane, boolean forward, Orientation orientation) {
        if (orientation == Orientation.T) {
            this.setTopTaskPaneTitle();
        } else {
            this.setBottomTaskPaneTitle();
        }
        if (displayOptions.isFireEvents()) {
            displayOptions.toggleFireEvents();
        }
        if (secondDisplayOptions.isFireEvents()) {
            secondDisplayOptions.toggleFireEvents();
        }
        ExecutorService buttonExecutor = Executors.newSingleThreadExecutor();
        if (orientation == Orientation.T) {
            this.setTopTaskPaneTitle();
        } else {
            this.setBottomTaskPaneTitle();
        }
        if (forward) {
            ZonedDateTime zdtFinish = ZonedDateTime.ofInstant(Instant.ofEpochMilli(secondDisplayOptions.getTimeFinish()), ZoneId.systemDefault()).plusHours(((Integer)widgetSettingsPanel.getSpTimeFrameShifter().getValue()).intValue());
            displayOptions.setTimeStart(secondDisplayOptions.getTimeFinish());
            displayOptions.setTimeFinish(zdtFinish.toInstant().toEpochMilli());
            secondDisplayOptions.setTimeFinish(displayOptions.getTimeFinish());
        } else {
            ZonedDateTime zdtStart = ZonedDateTime.ofInstant(Instant.ofEpochMilli(secondDisplayOptions.getTimeStart()), ZoneId.systemDefault()).minusHours(((Integer)widgetSettingsPanel.getSpTimeFrameShifter().getValue()).intValue());
            displayOptions.setTimeFinish(secondDisplayOptions.getTimeStart());
            displayOptions.setTimeStart(zdtStart.toInstant().toEpochMilli());
            secondDisplayOptions.setTimeStart(displayOptions.getTimeStart());
        }
        LOGGER.info(String.format("CUMULATIVE WIDGET SEARCH TIME: s: %s f: %s", new DateTime(displayOptions.getTimeStart()).toString(), new DateTime(displayOptions.getTimeFinish()).toString()));
        LOGGER.info(String.format("CUMULATIVE WIDGET DISPLAY TIME: s: %s f: %s", new DateTime(secondDisplayOptions.getTimeStart()).toString(), new DateTime(secondDisplayOptions.getTimeFinish()).toString()));
        displayOptions.setLastNHours(false);
        displayOptions.setNow(false);
        buttonExecutor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(this.search, displayOptions, secondDisplayOptions).setField(widgetSettingsPanel.getSelectedField()).setSort(widgetSettingsPanel.getSort()).setNoSources(widgetSettingsPanel.getNoSources()).setCumulativeGraph(true), String.format(" %s ( %s )", this.drawingWidget, taskPane.getTitle()), byFieldPanel, displayOptions));
        buttonExecutor.shutdown();
    }

    public DisplayOptions deepCopyOfDisplayOptions(DisplayOptions displayOptions1) {
        DisplayOptions dp = new DisplayOptions();
        dp.setIsDescToggleButtonVisible(false);
        dp.setAutoRefresh(displayOptions1.getAutoRefresh());
        dp.setChartManuallyOpened(displayOptions1.isChartManuallyOpened());
        dp.setDescOrder(displayOptions1.isDescOrder());
        dp.setIndexSplit(displayOptions1.getIndexSplit());
        dp.setIntervalObj(displayOptions1.getIntervalObj());
        dp.setIntervals(displayOptions1.getIntervals());
        dp.setLastNHours(displayOptions1.isLastNHours());
        dp.setLastNHoursSelectedIndex(displayOptions1.getLastNHoursSelectedIndex());
        dp.setManualIntervalObj(displayOptions1.isManualIntervalObj());
        dp.setNow(displayOptions1.isNow());
        dp.setPageSize(displayOptions1.getPageSize());
        dp.setQuery(displayOptions1.getQuery());
        dp.setShowOverview(displayOptions1.isShowOverview());
        dp.setTimeStart(displayOptions1.getTimeStart());
        dp.setTimeFinish(displayOptions1.getTimeFinish());
        dp.setWidgetThreads(displayOptions1.getWidgetThreads());
        return dp;
    }

    private void filter(ByFieldPanel byFieldPanel, WidgetSettingsPanel widgetSettingsPanel, Set<String> fields, JXTaskPane taskPane, boolean filterOut, boolean IsClickedEnforcePrecision, Orientation orientation) {
        List<String> eventsListByField = byFieldPanel.getEventsListByField();
        fields.addAll(eventsListByField);
        String selectedField = widgetSettingsPanel.getSelectedField();
        if (this.displayOptions != null && !eventsListByField.isEmpty()) {
            StringBuilder query = new StringBuilder();
            query.append(this.appendFilterQuery(this.search, fields.stream().collect(Collectors.toList()), selectedField, filterOut));
            ExecutorService buttonExecutor = Executors.newSingleThreadExecutor();
            if (orientation == Orientation.T) {
                if (IsClickedEnforcePrecision) {
                    this.setTopTaskPaneTitleEnforcedPrecision();
                } else {
                    this.setTopTaskPaneTitle();
                }
                this.displayOptionsExtendedTop = this.deepCopyOfDisplayOptions(this.displayOptions);
                this.displayOptionsTop = this.deepCopyOfDisplayOptions(this.displayOptions);
            } else {
                if (IsClickedEnforcePrecision) {
                    this.setBottomTaskPaneTitleEnforcedPrecision();
                } else {
                    this.setBottomTaskPaneTitle();
                }
                this.displayOptionsExtendedBottom = this.deepCopyOfDisplayOptions(this.displayOptions);
                this.displayOptionsBottom = this.deepCopyOfDisplayOptions(this.displayOptions);
            }
            buttonExecutor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(query.toString(), this.displayOptions).setField(widgetSettingsPanel.getSelectedField()).setSort(widgetSettingsPanel.getSort()).setNoSources(widgetSettingsPanel.getNoSources()).setIsClickedNext(true).setIsClickedEnforcePrecision(IsClickedEnforcePrecision), String.format(" %s ( %s )", this.drawingWidget, taskPane.getTitle()), byFieldPanel, this.displayOptions));
            buttonExecutor.shutdown();
        }
    }

    public void setMappingsInWidgetSettigsPanels(Set<String> fields) {
        if (!fields.isEmpty()) {
            String sfLeft = this.widgetSettingsPanelTop.getSelectedField();
            String sfRight = this.widgetSettingsPanelBottom.getSelectedField();
            this.widgetSettingsPanelTop.getCbFields().removeAllItems();
            this.widgetSettingsPanelBottom.getCbFields().removeAllItems();
            fields.forEach(f -> {
                this.widgetSettingsPanelTop.getCbFields().addItem((String)f);
                this.widgetSettingsPanelBottom.getCbFields().addItem((String)f);
            });
            this.widgetSettingsPanelTop.getCbFields().setSelectedItem(sfLeft);
            this.widgetSettingsPanelBottom.getCbFields().setSelectedItem(sfRight);
        }
    }

    private void setBottomTaskPaneTitle() {
        this.tpBottom.setTitle(String.format("%s %d events by %s", this.widgetSettingsPanelBottom.getSortText(), this.widgetSettingsPanelBottom.getNoSources(), this.widgetSettingsPanelBottom.getSelectedField()));
    }

    private void setBottomTaskPaneTitleEnforcedPrecision() {
        this.tpBottom.setTitle(String.format("%s %d events by %s  - enforced precision: on", this.widgetSettingsPanelBottom.getSortText(), this.widgetSettingsPanelBottom.getNoSources(), this.widgetSettingsPanelBottom.getSelectedField()));
    }

    private void setTopTaskPaneTitle() {
        this.tpTop.setTitle(String.format("%s %d events by %s", this.widgetSettingsPanelTop.getSortText(), this.widgetSettingsPanelTop.getNoSources(), this.widgetSettingsPanelTop.getSelectedField()));
    }

    private void setTopTaskPaneTitleEnforcedPrecision() {
        this.tpTop.setTitle(String.format("%s %d events by %s - enforced precision: on", this.widgetSettingsPanelTop.getSortText(), this.widgetSettingsPanelTop.getNoSources(), this.widgetSettingsPanelTop.getSelectedField()));
    }

    public ByPriorityPanel getByPriorityPanel() {
        return this.byPriorityPanel;
    }

    private String escapeSpecialCharacters(String text) {
        for (String escape : this.listOfCharactersToEscape) {
            text = text.replace(escape, "\\" + escape);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(text).append("\"");
        text = sb.toString();
        return text;
    }

    private String appendFilterQuery(String actualQuery, List<String> values, String field, boolean filterOut) {
        int i;
        StringBuilder sb = new StringBuilder();
        int startIndex = -1;
        int endIndex = -1;
        String[] split = field.split("\\.");
        Pattern pattern = Pattern.compile(split[0] + "\\." + split[1] + ":\\(");
        Matcher matcher = pattern.matcher(actualQuery);
        while (matcher.find()) {
            startIndex = matcher.end();
        }
        if (startIndex != -1) {
            for (i = startIndex; i < actualQuery.length(); ++i) {
                if (actualQuery.charAt(i) != ')') continue;
                endIndex = i;
            }
        }
        if (endIndex != -1) {
            sb.append(actualQuery.substring(0, endIndex));
            sb.append(", ");
            for (i = 0; i < values.size(); ++i) {
                String value = this.escapeSpecialCharacters(values.get(i));
                sb.append(value);
                if (i == values.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(actualQuery.substring(endIndex));
        } else {
            sb.append(actualQuery);
            sb.append(" AND ");
            sb.append(this.makeFilterQuery(values, field, filterOut));
        }
        return sb.toString();
    }

    private String makeFilterQuery(List<String> values, String field, boolean filterOut) {
        StringBuilder sb = new StringBuilder();
        if (filterOut) {
            sb.append("NOT ");
        }
        sb.append(field);
        sb.append(":(");
        for (int i = 0; i < values.size(); ++i) {
            String value = this.escapeSpecialCharacters(values.get(i));
            sb.append(value);
            if (i == values.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public void update(String search, DisplayOptions displayOptions, String user) {
        this.search = search = ClientSpecificQuery.setClientSpecificQuery(search, user);
        this.user = user;
        this.fieldsForNextT.clear();
        this.fieldsForNextB.clear();
        this.displayOptions = displayOptions;
        this.displayOptionsExtendedTop = this.deepCopyOfDisplayOptions(displayOptions);
        this.displayOptionsExtendedBottom = this.deepCopyOfDisplayOptions(displayOptions);
        this.displayOptionsTop = this.deepCopyOfDisplayOptions(displayOptions);
        this.displayOptionsBottom = this.deepCopyOfDisplayOptions(displayOptions);
        String progresText = "%s ( %s )";
        this.executor = Executors.newFixedThreadPool(displayOptions.getWidgetThreads());
        if (this.executor.isShutdown()) {
            this.executor = Executors.newFixedThreadPool(displayOptions.getWidgetThreads());
        } else {
            this.executor.shutdownNow();
            this.executor = Executors.newFixedThreadPool(displayOptions.getWidgetThreads());
        }
        for (Widget widget : this.widgets) {
            widget.setQueuePanel();
            if (widget instanceof ByPriorityPanel) {
                if (this.tp1.isCollapsed()) continue;
                this.executor.execute(new WidgetUpdateWorker(new ByPriorityPanel.UpdateParams(search, displayOptions), String.format(progresText, this.drawingWidget, this.byPriority), widget, displayOptions));
                continue;
            }
            if (!(widget instanceof ByFieldPanel)) continue;
            if (widget.equals(this.byFieldPanelTop)) {
                if (this.tpTop.isCollapsed()) continue;
                this.setDefaultNoSourcesWhenItsNotPredefinedNo(this.widgetSettingsPanelTop);
                this.setTopTaskPaneTitle();
                this.executor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(search, displayOptions).setField(this.widgetSettingsPanelTop.getSelectedField()).setSort(this.widgetSettingsPanelTop.getSort()).setNoSources(this.widgetSettingsPanelTop.getNoSources()), String.format(progresText, this.drawingWidget, this.tpTop.getTitle()), widget, displayOptions));
                continue;
            }
            if (!widget.equals(this.byFieldPanelBottom) || this.tpBottom.isCollapsed()) continue;
            this.setDefaultNoSourcesWhenItsNotPredefinedNo(this.widgetSettingsPanelBottom);
            this.setBottomTaskPaneTitle();
            this.executor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(search, displayOptions).setField(this.widgetSettingsPanelBottom.getSelectedField()).setSort(this.widgetSettingsPanelBottom.getSort()).setNoSources(this.widgetSettingsPanelBottom.getNoSources()), String.format(progresText, this.drawingWidget, this.tpBottom.getTitle()), widget, displayOptions));
        }
        this.executor.shutdown();
    }

    public void setDefaultNoSourcesWhenItsNotPredefinedNo(WidgetSettingsPanel widgetSettingsPanel) {
        if (widgetSettingsPanel.getNoSources() > 20) {
            widgetSettingsPanel.setNoSources(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToExcel(WidgetSettingsPanel widgetSettingsPanel, LinkedHashMap<String, Long> events, Orientation orientation) {
        if (!events.isEmpty()) {
            JFileChooser saveDialog = new JFileChooser();
            saveDialog.setDialogTitle("Export fields");
            saveDialog.setDialogType(1);
            saveDialog.setFileSelectionMode(1);
            int actionDialog = saveDialog.showSaveDialog(this);
            if (actionDialog == 0) {
                File file = new File(saveDialog.getSelectedFile().getAbsolutePath(), this.generateFileName(orientation, "xlsx"));
                XSSFWorkbook workbook = this.makeWorkbook(widgetSettingsPanel, events);
                if (workbook != null) {
                    try {
                        FileOutputStream fileWriter = new FileOutputStream(file);
                        workbook.write((OutputStream)fileWriter);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OverviewPanel.class, (String)"Widget.successfulExport.message"), 1));
                    }
                }
            }
        }
    }

    private XSSFWorkbook makeWorkbook(WidgetSettingsPanel widgetSettingsPanel, LinkedHashMap<String, Long> events) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(widgetSettingsPanel.getSelectedField());
        XSSFRow headerRow = sheet.createRow(0);
        Cell headerCell = headerRow.createCell(0);
        headerCell.setCellValue(widgetSettingsPanel.getSelectedField());
        headerCell = headerRow.createCell(1);
        headerCell.setCellValue("Count");
        Set<Map.Entry<String, Long>> entrySet = events.entrySet();
        Iterator<Map.Entry<String, Long>> it = entrySet.iterator();
        int rowCount = 1;
        while (it.hasNext()) {
            Map.Entry<String, Long> next = it.next();
            int columnCount = 0;
            XSSFRow row = sheet.createRow(rowCount++);
            Cell cell = row.createCell(columnCount++);
            cell.setCellValue(next.getKey());
            cell = row.createCell(columnCount);
            cell.setCellValue(next.getValue() != null ? String.format("%,d", next.getValue()) : "");
        }
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToCSV(WidgetSettingsPanel widgetSettingsPanel, LinkedHashMap<String, Long> events, Orientation orientation) {
        if (!events.isEmpty()) {
            JFileChooser saveDialog = new JFileChooser();
            saveDialog.setDialogTitle("Export fields");
            saveDialog.setDialogType(1);
            saveDialog.setFileSelectionMode(1);
            int actionDialog = saveDialog.showSaveDialog(this);
            if (actionDialog == 0) {
                File file = new File(saveDialog.getSelectedFile().getAbsolutePath(), this.generateFileName(orientation, "csv"));
                StringBuilder sb = this.buildStringForCSVFile(widgetSettingsPanel, events);
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    writer.write(sb.toString());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OverviewPanel.class, (String)"Widget.successfulExport.message"), 1));
                }
            }
        }
    }

    private StringBuilder buildStringForCSVFile(WidgetSettingsPanel widgetSettingsPanel, LinkedHashMap<String, Long> events) {
        String separator = ";";
        StringBuilder sb = new StringBuilder();
        sb.append(widgetSettingsPanel.getSelectedField());
        sb.append(separator);
        sb.append("Count");
        sb.append(System.getProperty("line.separator"));
        Set<Map.Entry<String, Long>> entrySet = events.entrySet();
        for (Map.Entry<String, Long> next : entrySet) {
            sb.append((Object)next.getKey());
            sb.append(separator);
            sb.append(next.getValue() != null ? String.format("%,d", next.getValue()) : "");
            sb.append(System.getProperty("line.separator"));
        }
        return sb;
    }

    private String generateFileName(Orientation orientation, String fileExtension) {
        DateTime startDate = new DateTime(this.displayOptions.getTimeStart());
        DateTime finishDate = new DateTime(this.displayOptions.getTimeFinish());
        DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
        String title = orientation == Orientation.T ? this.tpTop.getTitle() : this.tpBottom.getTitle();
        title = title.replaceAll("\\s+", "").toLowerCase();
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append("_").append(startDate.toString(dtf));
        sb.append(finishDate.toString(dtf));
        sb.append(String.valueOf(System.currentTimeMillis()));
        sb.append(".").append(fileExtension);
        return sb.toString();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pContents = new JPanel();
        this.pContents.setLayout(new GridLayout(1, 2));
        this.jScrollPane1.setViewportView(this.pContents);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 711, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 441, Short.MAX_VALUE).addContainerGap()));
    }

    static enum Orientation {
        B,
        T;

    }

    class FilterParameters {
        private List<String> events;
        private String field;

        public FilterParameters(OverviewPanel this$0, List<String> events, String field) {
            this.events = events;
            this.field = field;
        }

        public List<String> getEvents() {
            return this.events;
        }

        public String getField() {
            return this.field;
        }
    }
}

