/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.compiling.UnexpectedTokenException;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.Greater;
import com.github.zafarkhaja.semver.expr.GreaterOrEqual;
import com.github.zafarkhaja.semver.expr.Less;
import com.github.zafarkhaja.semver.expr.LessOrEqual;
import com.github.zafarkhaja.semver.expr.MvnLexer;
import com.github.zafarkhaja.semver.util.Stream;
import java.util.function.Predicate;

public class MavenParser
implements Parser<Predicate<Version>> {
    @Override
    public Predicate<Version> parse(String input) {
        Stream<MvnLexer.MvnToken> stream = new MvnLexer().tokenize(input);
        Predicate<Version> rule = version -> false;
        while (!stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.EOI})) {
            rule = rule.or(MavenParser.nextRule(stream));
            if (((MvnLexer.MvnToken)stream.consume((Stream.ElementType[])new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.COMMA, MvnLexer.MvnToken.Type.EOI})).type == MvnLexer.MvnToken.Type.EOI) break;
            if (stream.lookahead().type != MvnLexer.MvnToken.Type.EOI) continue;
            throw new UnexpectedTokenException(stream.lookahead(), MvnLexer.MvnToken.Type.LEFT_PAREN, MvnLexer.MvnToken.Type.LEFT_SQBR, MvnLexer.MvnToken.Type.NUMERIC);
        }
        return rule;
    }

    private static Predicate<Version> nextRule(Stream<MvnLexer.MvnToken> stream) throws UnexpectedTokenException {
        GreaterOrEqual part1;
        Version v1;
        if (stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.NUMERIC})) {
            return new GreaterOrEqual(MavenParser.parseVersion(stream));
        }
        MvnLexer.MvnToken l = (MvnLexer.MvnToken)stream.consume(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.LEFT_SQBR, MvnLexer.MvnToken.Type.LEFT_PAREN});
        Version version2 = v1 = stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.NUMERIC}) ? MavenParser.parseVersion(stream) : null;
        Expression expression = v1 == null ? v -> true : (part1 = l.lexeme.equals("[") ? new GreaterOrEqual(v1) : new Greater(v1));
        if (l.type == MvnLexer.MvnToken.Type.LEFT_SQBR && v1 != null && stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.RIGHT_SQBR})) {
            stream.consume();
            return version -> v1.compareTo((Version)version) == 0;
        }
        stream.consume(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.COMMA});
        Version v2 = stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.NUMERIC}) ? MavenParser.parseVersion(stream) : null;
        MvnLexer.MvnToken r = (MvnLexer.MvnToken)stream.consume(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.RIGHT_SQBR, MvnLexer.MvnToken.Type.RIGHT_PAREN});
        LessOrEqual part2 = v2 == null ? v -> true : (r.lexeme.equals("]") ? new LessOrEqual(v2) : new Less(v2));
        return part1.and(part2);
    }

    private static Version parseVersion(Stream<MvnLexer.MvnToken> stream) throws UnexpectedTokenException {
        int major = Integer.parseInt(((MvnLexer.MvnToken)stream.consume((Stream.ElementType[])new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.NUMERIC})).lexeme);
        int minor = 0;
        if (stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.DOT})) {
            stream.consume();
            minor = Integer.parseInt(((MvnLexer.MvnToken)stream.consume((Stream.ElementType[])new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.NUMERIC})).lexeme);
        }
        int patch = 0;
        if (stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.DOT})) {
            stream.consume();
            patch = Integer.parseInt(((MvnLexer.MvnToken)stream.consume((Stream.ElementType[])new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.NUMERIC})).lexeme);
        }
        StringBuilder pre = new StringBuilder();
        if (stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.HYPHEN})) {
            stream.consume();
            while (stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.ALPHA_NUMERIC, MvnLexer.MvnToken.Type.NUMERIC, MvnLexer.MvnToken.Type.DOT})) {
                pre.append(((MvnLexer.MvnToken)stream.consume((Stream.ElementType[])new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.ALPHA_NUMERIC, MvnLexer.MvnToken.Type.NUMERIC, MvnLexer.MvnToken.Type.DOT})).lexeme);
            }
        }
        StringBuilder build = new StringBuilder();
        if (stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.PLUS})) {
            stream.consume();
            while (stream.positiveLookahead(new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.ALPHA_NUMERIC, MvnLexer.MvnToken.Type.NUMERIC, MvnLexer.MvnToken.Type.DOT})) {
                build.append(((MvnLexer.MvnToken)stream.consume((Stream.ElementType[])new MvnLexer.MvnToken.Type[]{MvnLexer.MvnToken.Type.ALPHA_NUMERIC, MvnLexer.MvnToken.Type.NUMERIC, MvnLexer.MvnToken.Type.DOT})).lexeme);
            }
        }
        Version vtemp = Version.forIntegers(major, minor, patch);
        if (pre.length() != 0) {
            vtemp = vtemp.setPreReleaseVersion(pre.toString());
        }
        if (build.length() != 0) {
            vtemp = vtemp.setBuildMetadata(build.toString());
        }
        return vtemp;
    }
}

