/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver;

import com.github.zafarkhaja.semver.MetadataVersion;
import com.github.zafarkhaja.semver.NormalVersion;
import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.VersionParser;
import com.github.zafarkhaja.semver.expr.ExpressionParser;
import com.github.zafarkhaja.semver.expr.MavenParser;
import java.io.Serializable;
import java.util.Comparator;
import java.util.function.Predicate;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = -2008891377046871654L;
    private final NormalVersion normal;
    private final MetadataVersion preRelease;
    private final MetadataVersion build;
    private static final String PRE_RELEASE_PREFIX = "-";
    private static final String BUILD_PREFIX = "+";
    public static final Comparator<Version> BUILD_AWARE_ORDER = new BuildAwareOrder();

    Version(NormalVersion normal) {
        this(normal, MetadataVersion.NULL, MetadataVersion.NULL);
    }

    Version(NormalVersion normal, MetadataVersion preRelease) {
        this(normal, preRelease, MetadataVersion.NULL);
    }

    Version(NormalVersion normal, MetadataVersion preRelease, MetadataVersion build) {
        this.normal = normal;
        this.preRelease = preRelease;
        this.build = build;
    }

    public static Version valueOf(String version) {
        return VersionParser.parseValidSemVer(version);
    }

    public static Version forIntegers(int major) {
        return new Version(new NormalVersion(major, 0, 0));
    }

    public static Version forIntegers(int major, int minor) {
        return new Version(new NormalVersion(major, minor, 0));
    }

    public static Version forIntegers(int major, int minor, int patch) {
        return new Version(new NormalVersion(major, minor, patch));
    }

    public boolean satisfies(String expr) {
        Object res;
        try {
            res = ExpressionParser.newInstance().parse(expr);
        }
        catch (ParseException e) {
            try {
                res = new MavenParser().parse(expr);
            }
            catch (ParseException e2) {
                res = version -> false;
            }
        }
        return this.satisfies((Predicate<Version>)res);
    }

    public boolean satisfiesJSemVerExpression(String expr) {
        return this.satisfies(ExpressionParser.newInstance().parse(expr));
    }

    public boolean satisfiesMavenRange(String expr) {
        return this.satisfies((Predicate<Version>)new MavenParser().parse(expr));
    }

    public boolean satisfies(Predicate<Version> expr) {
        return expr.test(this);
    }

    public Version withMajor(int major, boolean preserveMeta) {
        if (preserveMeta) {
            return new Version(this.normal.withMajor(major), this.preRelease, this.build);
        }
        return new Version(this.normal.withMajor(major));
    }

    public Version withMinor(int minor, boolean preserveMeta) {
        if (preserveMeta) {
            return new Version(this.normal.withMinor(minor), this.preRelease, this.build);
        }
        return new Version(this.normal.withMinor(minor));
    }

    public Version withPatch(int patch, boolean preserveMeta) {
        if (preserveMeta) {
            return new Version(this.normal.withPatch(patch), this.preRelease, this.build);
        }
        return new Version(this.normal.withPatch(patch));
    }

    public static boolean isValid(String toCheck) {
        try {
            new VersionParser(toCheck).parse(null);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public Version incrementMajorVersion() {
        if (this.preRelease == MetadataVersion.NULL || this.normal.getPatch() != 0 || this.normal.getMinor() != 0) {
            return new Version(this.normal.incrementMajor());
        }
        return new Version(this.normal);
    }

    public Version incrementPreMajorVersion() {
        return this.incrementMajorVersion("0");
    }

    public Version incrementMajorVersion(String preRelease) {
        return new Version(this.normal.incrementMajor(), VersionParser.parsePreRelease(preRelease));
    }

    public Version incrementMinorVersion() {
        if (this.preRelease == MetadataVersion.NULL || this.normal.getPatch() != 0) {
            return new Version(this.normal.incrementMinor());
        }
        return new Version(this.normal);
    }

    public Version incrementPreMinorVersion() {
        return this.incrementMinorVersion("0");
    }

    public Version incrementMinorVersion(String preRelease) {
        return new Version(this.normal.incrementMinor(), VersionParser.parsePreRelease(preRelease));
    }

    public Version incrementPatchVersion() {
        if (this.preRelease == MetadataVersion.NULL) {
            return new Version(this.normal.incrementPatch());
        }
        return new Version(this.normal);
    }

    public Version incrementPrePatchVersion() {
        return this.incrementPatchVersion("0");
    }

    public Version incrementPatchVersion(String preRelease) {
        return new Version(this.normal.incrementPatch(), VersionParser.parsePreRelease(preRelease));
    }

    public Version incrementPreReleaseVersion() {
        return new Version(this.normal, this.preRelease.increment());
    }

    public Version incrementBuildMetadata() {
        return new Version(this.normal, this.preRelease, this.build.increment());
    }

    public Version setPreReleaseVersion(String preRelease) {
        return new Version(this.normal, VersionParser.parsePreRelease(preRelease));
    }

    public Version setBuildMetadata(String build) {
        return new Version(this.normal, this.preRelease, VersionParser.parseBuild(build));
    }

    public int getMajorVersion() {
        return this.normal.getMajor();
    }

    public int getMinorVersion() {
        return this.normal.getMinor();
    }

    public int getPatchVersion() {
        return this.normal.getPatch();
    }

    public String getNormalVersion() {
        return this.normal.toString();
    }

    public String getPreReleaseVersion() {
        return this.preRelease.toString();
    }

    public String getBuildMetadata() {
        return this.build.toString();
    }

    public boolean greaterThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean greaterThanOrEqualTo(Version other) {
        return this.compareTo(other) >= 0;
    }

    public boolean lessThan(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean lessThanOrEqualTo(Version other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isMajorVersionCompatible(Version other) {
        return this.getMajorVersion() == other.getMajorVersion();
    }

    public boolean isMinorVersionCompatible(Version other) {
        return this.getMajorVersion() == other.getMajorVersion() && this.getMinorVersion() == other.getMinorVersion();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.normal.hashCode();
        hash = 97 * hash + this.preRelease.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getNormalVersion());
        if (!this.getPreReleaseVersion().isEmpty()) {
            sb.append(PRE_RELEASE_PREFIX).append(this.getPreReleaseVersion());
        }
        if (!this.getBuildMetadata().isEmpty()) {
            sb.append(BUILD_PREFIX).append(this.getBuildMetadata());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Version other) {
        int result = this.normal.compareTo(other.normal);
        if (result == 0) {
            result = this.preRelease.compareTo(other.preRelease);
        }
        return result;
    }

    public int compareWithBuildsTo(Version other) {
        return BUILD_AWARE_ORDER.compare(this, other);
    }

    private static class BuildAwareOrder
    implements Comparator<Version> {
        private BuildAwareOrder() {
        }

        @Override
        public int compare(Version v1, Version v2) {
            int result = v1.compareTo(v2);
            if (result == 0) {
                result = v1.build.compareTo(v2.build);
                if (v1.build == MetadataVersion.NULL || v2.build == MetadataVersion.NULL) {
                    result = -1 * result;
                }
            }
            return result;
        }
    }

    public static class Builder {
        private String normal;
        private String preRelease;
        private String build;

        public Builder() {
        }

        public Builder(String normal) {
            this.normal = normal;
        }

        public Builder setNormalVersion(String normal) {
            this.normal = normal;
            return this;
        }

        public Builder setPreReleaseVersion(String preRelease) {
            this.preRelease = preRelease;
            return this;
        }

        public Builder setBuildMetadata(String build) {
            this.build = build;
            return this;
        }

        public Version build() {
            StringBuilder sb = new StringBuilder();
            if (this.isFilled(this.normal)) {
                sb.append(this.normal);
            }
            if (this.isFilled(this.preRelease)) {
                sb.append(Version.PRE_RELEASE_PREFIX).append(this.preRelease);
            }
            if (this.isFilled(this.build)) {
                sb.append(Version.BUILD_PREFIX).append(this.build);
            }
            return VersionParser.parseValidSemVer(sb.toString());
        }

        private boolean isFilled(String str) {
            return str != null && !str.isEmpty();
        }
    }
}

