/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.beanutils.PropertyUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.SecurityEvent;

public class AlertEventsTableRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color[] PRIORITY_COLORS = new Color[]{new Color(228, 240, 224), new Color(252, 249, 251), new Color(251, 235, 215), new Color(250, 212, 192), new Color(255, 176, 179), new Color(211, 211, 211)};
    public static final String[] PRI_COLOR_HI = new String[]{"#008000", "#408000", "#808000", "#f08000", "#f00000"};
    public static final String[] PRI_COLOR_LO = new String[]{"#004000", "#204000", "#404000", "#804000", "#800000"};
    private static final DateTimeFormatter DTF = ISODateTimeFormat.dateTime();

    public AlertEventsTableRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        if (object == null) {
            return this;
        }
        SecurityEvent event = (SecurityEvent)object;
        String category = this.mapColumnIndexToCategoryName(column);
        Map<String, String> values = this.getMap(event, category);
        String priStr = this.getMap(event, "what").get("priority");
        int pri = priStr != null ? Integer.valueOf(priStr) : 6;
        pri = pri > 5 ? 6 : pri;
        int n = pri = pri < 1 ? 1 : pri;
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(PRIORITY_COLORS[pri - 1]);
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        values = this.TextFirstSort(values);
        boolean first = true;
        block18: for (String key : values.keySet()) {
            String v = values.get(key);
            if (v != null) {
                Object value = v.replace("<", "&lt;");
                switch (category) {
                    case "what": {
                        switch (key) {
                            case "priority": {
                                continue block18;
                            }
                            case "text": {
                                key = "";
                                value = "<b>" + (String)value + "</b>";
                            }
                        }
                        break;
                    }
                    case "when": {
                        try {
                            value = DTF.print(Long.valueOf((String)value).longValue());
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if (!key.isEmpty()) {
                    sb.append(String.format("%s%s:%s<br/>", first ? "" : "", key, value));
                } else {
                    sb.append(String.format("%s%s<br/>", first ? "" : ":", value));
                }
            }
            first = false;
        }
        this.setText(sb.append("</html>").toString());
        int prefHeight = this.getPreferredSize().height;
        if (prefHeight > table.getRowHeight(row)) {
            table.setRowHeight(row, prefHeight);
        }
        this.setVerticalAlignment(1);
        return this;
    }

    private Map<String, String> TextFirstSort(Map<String, String> values) {
        LinkedHashMap<String, String> smap = new LinkedHashMap<String, String>();
        if (values.containsKey("text")) {
            smap.put("text", null);
        }
        for (String key : values.keySet()) {
            smap.put(key, values.get(key));
        }
        return smap;
    }

    private Map<String, String> getMap(SecurityEvent event, String category) {
        try {
            Object obj = PropertyUtils.getProperty((Object)event, (String)category);
            List l = (List)PropertyUtils.getProperty((Object)obj, (String)"entry");
            HashMap<String, String> r = new HashMap<String, String>();
            for (Object entry : l) {
                String key = (String)PropertyUtils.getProperty(entry, (String)"key");
                String value = (String)PropertyUtils.getProperty(entry, (String)"value");
                r.put(key, value);
            }
            return r;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private String mapColumnIndexToCategoryName(int column) {
        switch (column) {
            case 0: {
                return "what";
            }
            case 1: {
                return "who";
            }
            case 2: {
                return "where";
            }
            case 3: {
                return "when";
            }
        }
        throw new IllegalArgumentException("Unsupported column index");
    }
}

