/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;

public class RegExpDebuggerPanel
extends JPanel {
    private static final double MAX_REGEXP_MATCH_TIME = 0.9;
    private String originalText;
    private String originalRegExp;
    private DefaultTableModel tableModel = new DefaultTableModel();
    private String[] columnIdentifiers = new String[]{NbBundle.getMessage(RegExpDebuggerPanel.class, (String)"regexp_debugger.table.col.0"), NbBundle.getMessage(RegExpDebuggerPanel.class, (String)"regexp_debugger.table.col.1")};
    private Font font = new Font(this.getFont().getName(), 0, this.getFont().getSize());
    private JTextPane guiText;
    private JTextPane guiRegExp;
    private ParsingRuleDTOWrapper rule;
    private JTable guiGroups;
    private JButton guiParse;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JLabel lblAvgRegexpTime;

    public RegExpDebuggerPanel(ParsingRuleDTOWrapper rule) {
        this.initComponents();
        this.rule = rule;
        this.guiText = new JTextPane();
        this.guiText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.guiText.setFont(this.font);
        this.guiText.setEditorKit(new WrapEditorKit());
        this.guiText.setPreferredSize(new Dimension(100, 100));
        this.jScrollPane4.setViewportView(this.guiText);
        this.jScrollPane4.setVerticalScrollBarPolicy(20);
        this.guiRegExp = new JTextPane();
        this.guiRegExp.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.guiRegExp.setFont(this.font);
        this.guiRegExp.setEditorKit(new WrapEditorKit());
        this.guiRegExp.setPreferredSize(new Dimension(100, 100));
        this.jScrollPane5.setViewportView(this.guiRegExp);
        this.jScrollPane5.setVerticalScrollBarPolicy(20);
        this.guiRegExp.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                RegExpDebuggerPanel.this.toPlainText(RegExpDebuggerPanel.this.guiRegExp);
                if (RegExpDebuggerPanel.this.originalRegExp != null) {
                    RegExpDebuggerPanel.this.guiRegExp.setText(RegExpDebuggerPanel.this.originalRegExp);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                RegExpDebuggerPanel.this.originalRegExp = RegExpDebuggerPanel.this.guiRegExp.getText();
            }
        });
        this.guiText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                RegExpDebuggerPanel.this.toPlainText(RegExpDebuggerPanel.this.guiText);
                if (RegExpDebuggerPanel.this.originalText != null) {
                    RegExpDebuggerPanel.this.guiText.setText(RegExpDebuggerPanel.this.originalText);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                RegExpDebuggerPanel.this.originalText = RegExpDebuggerPanel.this.guiText.getText();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.guiParse = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.guiGroups = new JTable();
        this.jScrollPane4 = new JScrollPane();
        this.jScrollPane5 = new JScrollPane();
        this.lblAvgRegexpTime = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RegExpDebuggerPanel.class, (String)"RegExpDebuggerPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RegExpDebuggerPanel.class, (String)"RegExpDebuggerPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.guiParse, (String)NbBundle.getMessage(RegExpDebuggerPanel.class, (String)"RegExpDebuggerPanel.guiParse.text"));
        this.guiParse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegExpDebuggerPanel.this.guiParseActionPerformed(evt);
            }
        });
        this.guiGroups.setModel(this.tableModel);
        this.jScrollPane3.setViewportView(this.guiGroups);
        Mnemonics.setLocalizedText((JLabel)this.lblAvgRegexpTime, (String)NbBundle.getMessage(RegExpDebuggerPanel.class, (String)"RegExpDebuggerPanel.lblAvgRegexpTime.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane4).addGroup(layout.createSequentialGroup().addComponent(this.guiParse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblAvgRegexpTime)).addComponent(this.jScrollPane3).addComponent(this.jScrollPane5)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 100, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -1, 100, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.guiParse).addComponent(this.lblAvgRegexpTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 124, Short.MAX_VALUE).addContainerGap()));
    }

    private void guiParseActionPerformed(ActionEvent evt) {
        this.guiParse.setEnabled(false);
        if (this.originalText == null) {
            this.originalText = this.guiText.getText();
        }
        if (this.originalRegExp == null) {
            this.originalRegExp = this.guiRegExp.getText();
        }
        if (!this.originalText.isEmpty()) {
            long ns;
            double nsms;
            long start = System.nanoTime();
            for (int i = this.originalRegExp.length(); i > 0; --i) {
                String subRegExp = this.originalRegExp.substring(0, i);
                MatchResult mr = this.attemptMatch(subRegExp, this.originalText);
                if (!mr.found) continue;
                this.toHtml(this.guiText);
                this.toHtml(this.guiRegExp);
                this.guiRegExp.setText(this.highlightMatched(subRegExp, this.originalRegExp));
                this.guiText.setText(this.highlightMatched(mr.groups.get(0), this.originalText));
                Object[][] dataVector = new String[mr.groups.size() - 1][2];
                for (int j = 1; j <= mr.groups.size() - 1; ++j) {
                    dataVector[j - 1][0] = String.valueOf(j);
                    dataVector[j - 1][1] = mr.groups.get(j);
                }
                this.tableModel.setDataVector(dataVector, this.columnIdentifiers);
                break;
            }
            if (Double.compare(nsms = (double)(ns = System.nanoTime() - start) / 1.0E9, 0.9) >= 1) {
                JOptionPane.showMessageDialog(this, String.format(NbBundle.getMessage(RegExpDebuggerPanel.class, (String)"regexp_debugger.rule_to_slow.message"), this.rule.getDescription(), nsms), NbBundle.getMessage(RegExpDebuggerPanel.class, (String)"regexp_debugger.rule_to_slow.title"), 2);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){
            long start = System.currentTimeMillis();
            int count = 0;

            @Override
            public void run() {
                while (System.currentTimeMillis() - this.start <= 1000L) {
                    RegExpDebuggerPanel.this.attemptMatch(RegExpDebuggerPanel.this.guiRegExp.getText(), RegExpDebuggerPanel.this.guiText.getText());
                    ++this.count;
                }
                float duration = 1000.0f / (float)this.count;
                String unit = "ms";
                if ((double)duration < 0.1) {
                    duration *= 1000.0f;
                    unit = "\u00b5s";
                }
                RegExpDebuggerPanel.this.lblAvgRegexpTime.setText(String.format("~%.2f%s (%d iter/s)", Float.valueOf(duration), unit, this.count));
                RegExpDebuggerPanel.this.guiParse.setEnabled(true);
            }
        });
    }

    public void setText(String text) {
        this.toPlainText(this.guiText);
        this.guiText.setText(text);
    }

    public void setRegExp(String regexp) {
        this.toPlainText(this.guiRegExp);
        this.guiRegExp.setText(regexp);
    }

    public String getRegExp() {
        return this.originalRegExp;
    }

    private void toHtml(JTextPane p) {
        p.setContentType("text/html");
        p.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        p.setFont(this.font);
    }

    private void toPlainText(JTextPane p) {
        p.setContentType("text/plain");
        p.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        p.setFont(this.font);
    }

    private String highlightMatched(String matched, String full) {
        String remainder = full.replace(matched, "");
        return String.format("<font color='green'>%s</font><font color='red'>%s</font>", matched, remainder);
    }

    private MatchResult attemptMatch(String regexp, String text) {
        MatchResult res = new MatchResult();
        try {
            Pattern p = Pattern.compile(regexp);
            Matcher m = p.matcher(text);
            if (m.find(0)) {
                res.found = true;
                for (int i = 0; i <= m.groupCount(); ++i) {
                    res.groups.add(m.group(i));
                }
            }
        }
        catch (PatternSyntaxException ex) {
            res.found = false;
        }
        return res;
    }

    class WrapEditorKit
    extends StyledEditorKit {
        ViewFactory defaultFactory;

        WrapEditorKit() {
            this.defaultFactory = new WrapColumnFactory();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }

    private static class MatchResult {
        public boolean found;
        public List<String> groups = new ArrayList<String>();

        private MatchResult() {
        }
    }

    class WrapLabelView
    extends LabelView {
        public WrapLabelView(RegExpDebuggerPanel this$0, Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }

    class WrapColumnFactory
    implements ViewFactory {
        WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                switch (kind) {
                    case "content": {
                        return new WrapLabelView(RegExpDebuggerPanel.this, elem);
                    }
                    case "paragraph": {
                        return new ParagraphView(elem);
                    }
                    case "section": {
                        return new BoxView(elem, 1);
                    }
                    case "component": {
                        return new ComponentView(elem);
                    }
                    case "icon": {
                        return new IconView(elem);
                    }
                }
            }
            return new LabelView(elem);
        }
    }
}

