/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.compiling.Lexer;
import com.github.zafarkhaja.semver.compiling.LexerException;
import com.github.zafarkhaja.semver.compiling.Token;
import com.github.zafarkhaja.semver.util.Stream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ExprLexer
extends Lexer<ExprToken> {
    ExprLexer() {
    }

    @Override
    protected Stream<ExprToken> tokenize(String input) {
        ArrayList<ExprToken> tokens = new ArrayList<ExprToken>();
        int tokenPos = 0;
        while (!input.isEmpty()) {
            boolean matched = false;
            for (ExprToken.Type tokenType : ExprToken.Type.values()) {
                Matcher matcher = tokenType.pattern.matcher(input);
                if (!matcher.find()) continue;
                matched = true;
                input = matcher.replaceFirst("");
                if (tokenType != ExprToken.Type.WHITESPACE) {
                    tokens.add(new ExprToken(tokenType, matcher.group(), tokenPos));
                }
                tokenPos += matcher.end();
                break;
            }
            if (matched) continue;
            throw new LexerException(input);
        }
        tokens.add(new ExprToken(ExprToken.Type.EOI, null, tokenPos));
        return new Stream<ExprToken>(tokens.toArray(new ExprToken[tokens.size()]));
    }

    static class ExprToken
    extends Token<ExprToken> {
        ExprToken(Type type, String lexeme, int position) {
            super(type, lexeme, position);
        }

        static enum Type implements Token.Type<ExprToken>
        {
            NUMERIC("0|[1-9][0-9]*"),
            WILDCARD("[\\*xX]"),
            ALPHA_NUMERIC("(\\d*\\p{L}(\\p{L}|\\d)*)|0\\d+"),
            DOT("\\."),
            HYPHEN("-"),
            PLUS("\\+"),
            EQUAL("="),
            NOT_EQUAL("!="),
            GREATER(">(?!=)"),
            GREATER_EQUAL(">="),
            LESS("<(?!=)"),
            LESS_EQUAL("<="),
            TILDE("~"),
            CARET("\\^"),
            AND("&"),
            OR("\\|"),
            NOT("!(?!=)"),
            LEFT_PAREN("\\("),
            RIGHT_PAREN("\\)"),
            WHITESPACE("\\s+"),
            EOI("?!");

            final Pattern pattern;

            private Type(String regexp) {
                this.pattern = Pattern.compile("^(" + regexp + ")");
            }

            public String toString() {
                return this.name() + "(" + this.pattern + ")";
            }

            @Override
            public boolean isMatchedBy(ExprToken token) {
                return token != null && this == token.type;
            }
        }
    }
}

