/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.securityevents.NeighborEventsOptionsPanel;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventActionListener;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventDetailsPanel;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventDetailsTableModel;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventSearchQueryUpdate;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventWrapper;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventsTopComponent;
import rs.co.ast.aspen.gui.module.securityevents.query.QueryManager;
import rs.co.ast.aspen.gui.module.securityevents.simplecorrelator.SimpleCorrelatorPanel;

@TopComponent.Description(preferredID="SecurityEventDetailsTopComponent", iconBase="se_details.png", persistenceType=0)
public final class SecurityEventDetailsTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(SecurityEventDetailsTopComponent.class.getName());
    private final String NEIGHBOR_EVENTS = "neighborEvents";
    private final String NEW_FIELD_QUERY = "newFieldQuery";
    private final String INCLUDE_AND_IN_QUERY = "includeAndInQuery";
    private final String INCLUDE_OR_IN_QUERY = "includeOrInQuery";
    private final String EXCLUDE_FROM_QUERY = "excludeFromQuery";
    private Lookup.Result<SecurityEventWrapper> lr = Utilities.actionsGlobalContext().lookupResult(SecurityEventWrapper.class);
    private Lookup.Result<SecurityEvent> lrSE = Utilities.actionsGlobalContext().lookupResult(SecurityEvent.class);
    private SecurityEventDetailsPanel sedp = new SecurityEventDetailsPanel();
    private SecurityEventWrapper securityEventWrapper;
    private SecurityEventActionListener l;
    private InstanceContent instanceContent = new InstanceContent();
    private Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private Dialog dialog;
    private JTable sedpTable;
    private JButton bNeighborEvent;
    private JButton bReferences;
    private JButton bShowRawLog;
    private JButton bSimpleCorrelator;
    private JScrollPane spContainer;

    public SecurityEventDetailsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"CTL_SecurityEventDetailsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"HINT_SecurityEventDetailsTopComponent"));
        this.sedpTable = this.sedp.getTable();
        this.associateLookup(this.lookup);
        this.spContainer.setViewportView(this.sedp);
        this.sedpTable.addMouseListener(new MouseListener(this){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                Collection instances = lr.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof SecurityEventWrapper)) continue;
                    SecurityEventDetailsTopComponent.this.securityEventWrapper = (SecurityEventWrapper)o;
                    SecurityEventDetailsTopComponent.this.setSecurityEvent(SecurityEventDetailsTopComponent.this.securityEventWrapper);
                }
            }
        });
        this.lrSE.allInstances();
        this.lrSE.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                Collection instances = lr.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof SecurityEvent)) continue;
                    SecurityEvent se = (SecurityEvent)o;
                    SecurityEventDetailsTopComponent.this.securityEventWrapper = SecurityEventDetailsTopComponent.this.securityEventWrapper != null ? new SecurityEventWrapper(se, null, SecurityEventDetailsTopComponent.this.securityEventWrapper.getTag()) : new SecurityEventWrapper(se, null, "");
                    SecurityEventDetailsTopComponent.this.setSecurityEvent(SecurityEventDetailsTopComponent.this.securityEventWrapper);
                }
            }
        });
        this.sedp.addPropertyChangeListener(evt -> {
            SecurityEventSearchQueryUpdate prevSearchQueryUpdate = null;
            if (evt.getPropertyName().equals("neighborEvents")) {
                String query = (String)evt.getNewValue();
                this.openNeighborEventsDialog(this.securityEventWrapper, query);
            } else if (evt.getPropertyName().equals("newFieldQuery")) {
                String query = (String)evt.getNewValue();
                SecurityEventActionListener sealNewFieldQuery = new SecurityEventActionListener(query, this.securityEventWrapper);
                sealNewFieldQuery.actionPerformed(new ActionEvent((Object)this, 1001, null));
            } else if (evt.getPropertyName().equals("includeAndInQuery")) {
                this.addAdditionalParametersInQuery(prevSearchQueryUpdate, false, false);
            } else if (evt.getPropertyName().equals("includeOrInQuery")) {
                this.addAdditionalParametersInQuery(prevSearchQueryUpdate, false, true);
            } else if (evt.getPropertyName().equals("excludeFromQuery")) {
                this.addAdditionalParametersInQuery(prevSearchQueryUpdate, true, false);
            }
        });
    }

    public void addAdditionalParametersInQuery(SecurityEventSearchQueryUpdate prevSearchQueryUpdate, boolean isNot, boolean isOr) {
        SecurityEventDetailsTableModel.Item item = (SecurityEventDetailsTableModel.Item)this.sedp.getTableModel().getValueAt(this.sedpTable.getSelectedRow(), 0);
        if (item != null && this.securityEventWrapper != null && item.getKey() != null && item.getValue() != null) {
            String query = QueryManager.makeSEDetailsQuery(item, this.securityEventWrapper, isNot, isOr, this.sedpTable.getSelectedColumn());
            SecurityEventSearchQueryUpdate squ = new SecurityEventSearchQueryUpdate(query, false, this.securityEventWrapper.getTag());
            this.instanceContent.add((Object)squ);
            prevSearchQueryUpdate = squ;
            this.securityEventWrapper.setQuery(query);
            this.instanceContent.remove((Object)squ);
        }
    }

    public synchronized void setSecurityEvent(final SecurityEventWrapper event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (event != null) {
                    SecurityEventDetailsTopComponent.this.sedp.getTableModel().setEvent(event.getEvent());
                    SecurityEventDetailsTopComponent.this.updateReferences(event);
                    SecurityEventDetailsTopComponent.this.securityEventWrapper = event;
                }
            }
        });
    }

    private void updateReferences(SecurityEventWrapper event) {
        this.bShowRawLog.setEnabled(true);
        this.bReferences.setEnabled(false);
        this.bSimpleCorrelator.setEnabled(true);
        if (event != null) {
            if (event.getEvent().getExtra() != null) {
                List entries = event.getEvent().getExtra().getEntry();
                for (SecurityEvent.Extra.Entry e : entries) {
                    if (!e.getKey().equals("references")) continue;
                    String query = QueryManager.makeCorrelationIdsQuery(e.getValue());
                    if (this.l != null) {
                        this.bReferences.removeActionListener(this.l);
                    }
                    this.l = new SecurityEventActionListener(query, this.securityEventWrapper);
                    this.bReferences.addActionListener(this.l);
                    this.bReferences.setEnabled(true);
                    this.bShowRawLog.setEnabled(false);
                    break;
                }
            }
            if (event.getEvent().getWhat() == null && event.getEvent().getWhen() == null) {
                this.bShowRawLog.setEnabled(false);
                this.bReferences.setEnabled(false);
                this.bSimpleCorrelator.setEnabled(false);
            }
            if (event.getOptions() == null) {
                this.bShowRawLog.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.spContainer = new JScrollPane();
        this.bReferences = new JButton();
        this.bShowRawLog = new JButton();
        this.bSimpleCorrelator = new JButton();
        this.bNeighborEvent = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.bReferences, (String)NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"SecurityEventDetailsTopComponent.bReferences.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bShowRawLog, (String)NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"SecurityEventDetailsTopComponent.bShowRawLog.text"));
        this.bShowRawLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventDetailsTopComponent.this.bShowRawLogActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bSimpleCorrelator, (String)NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"SecurityEventDetailsTopComponent.bSimpleCorrelator.text"));
        this.bSimpleCorrelator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventDetailsTopComponent.this.bSimpleCorrelatorActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bNeighborEvent, (String)NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"SecurityEventDetailsTopComponent.bNeighborEvent.text"));
        this.bNeighborEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventDetailsTopComponent.this.bNeighborEventActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bReferences).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bSimpleCorrelator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bNeighborEvent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bShowRawLog)).addComponent(this.spContainer)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.spContainer, -1, 445, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bReferences).addComponent(this.bShowRawLog).addComponent(this.bSimpleCorrelator).addComponent(this.bNeighborEvent)).addContainerGap()));
    }

    private void bShowRawLogActionPerformed(ActionEvent evt) {
        if (this.securityEventWrapper != null) {
            TopComponent details = WindowManager.getDefault().findTopComponent("RawLogDetailsTopComponent");
            details.open();
            details.requestActive();
        }
    }

    private void bSimpleCorrelatorActionPerformed(ActionEvent evt) {
        if (this.securityEventWrapper != null) {
            final SimpleCorrelatorPanel scp = new SimpleCorrelatorPanel(this.securityEventWrapper);
            final JButton save = new JButton("Save Script");
            DialogDescriptor des = new DialogDescriptor((Object)scp, NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"SimpleCorrelatorPanel.title"), false, new Object[]{save, DialogDescriptor.CANCEL_OPTION}, (Object)save, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource().equals(save)) {
                        if (scp.isScriptValid() && !scp.getScriptText().isEmpty()) {
                            boolean success = false;
                            try {
                                SecurityEventDetailsTopComponent.this.apiService.createScriptWithText(scp.getScriptName(), scp.getScriptText(), "javascript", "Script created with SimpleCorrelator", ScriptType.CORRELATION);
                                String scriptType = NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)("scrypt.type." + String.valueOf(ScriptType.CORRELATION)));
                                String savedText = NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"SecurityEventsTopComponent.simpleCorrelator.scriptSaved");
                                JOptionPane.showMessageDialog(scp, String.format(savedText, scp.getScriptName(), scriptType));
                                success = true;
                            }
                            catch (ApiServiceException_Exception ex) {
                                LOGGER.log(Level.INFO, "{0}", ex.getFaultInfo().getData());
                                JOptionPane.showMessageDialog(scp, ex.getFaultInfo().getData().get(0), "Save failed", 2);
                            }
                            if (success) {
                                SecurityEventDetailsTopComponent.this.dialog.setVisible(false);
                                SecurityEventDetailsTopComponent.this.dialog.dispose();
                            }
                        } else {
                            JOptionPane.showMessageDialog(scp, NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"SecurityEventsTopComponent.simpleCorrelator.scriptNotValid"));
                        }
                    }
                }
            });
            this.dialog = DialogDisplayer.getDefault().createDialog(des);
            this.dialog.setVisible(true);
        }
    }

    private void bNeighborEventActionPerformed(ActionEvent evt) {
        this.openNeighborEventsDialog(this.securityEventWrapper, null);
    }

    public void openNeighborEventsDialog(final SecurityEventWrapper securityEventWrapper, String additionalQuery) throws MissingResourceException {
        if (securityEventWrapper != null) {
            StringBuilder sbQuery = new StringBuilder();
            sbQuery.append(securityEventWrapper.getQuery());
            if (additionalQuery != null) {
                sbQuery.append(" ");
                sbQuery.append("AND");
                sbQuery.append(" ");
                sbQuery.append(additionalQuery);
            }
            final NeighborEventsOptionsPanel neighborPanel = new NeighborEventsOptionsPanel(sbQuery.toString());
            final JButton ok = new JButton("OK");
            DialogDescriptor d = new DialogDescriptor((Object)neighborPanel, NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"NeighborEventsOptionPanel.title"), false, new Object[]{ok, DialogDescriptor.CANCEL_OPTION}, (Object)ok, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource().equals(ok)) {
                        int seconds = neighborPanel.getSeconds();
                        SecurityEventsTopComponent setc = new SecurityEventsTopComponent();
                        setc.open();
                        setc.requestActive();
                        Long timestamp = securityEventWrapper.getEvent().getTimestamp();
                        ZonedDateTime zdtStart = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).minusSeconds(seconds);
                        ZonedDateTime zdtFinish = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).plusSeconds(seconds);
                        long start = zdtStart.toInstant().toEpochMilli();
                        long finish = zdtFinish.toInstant().toEpochMilli();
                        int lastNHoursSelectedIndex = securityEventWrapper.getOptions().getLastNHoursSelectedIndex();
                        boolean asc = !securityEventWrapper.getOptions().isDescOrder();
                        setc.getDisplayOptions().toggleFireEvents();
                        setc.getDisplayOptions().setNow(false);
                        setc.getDisplayOptions().setLastNHours(false);
                        setc.getDisplayOptions().setLastNHoursSelectedIndex(lastNHoursSelectedIndex);
                        setc.getDisplayOptions().setTimeStart(start);
                        setc.getDisplayOptions().setTimeFinish(finish);
                        setc.getDisplayOptions().toggleFireEvents();
                        if (asc) {
                            setc.setAsc();
                        }
                        LOGGER.info(String.format("Query: %s", neighborPanel.getQuery()));
                        setc.doSearch(neighborPanel.getQuery(), start, finish);
                        SecurityEventDetailsTopComponent.this.dialog.setVisible(false);
                        SecurityEventDetailsTopComponent.this.dialog.dispose();
                    }
                }
            });
            this.dialog = DialogDisplayer.getDefault().createDialog(d);
            this.dialog.setVisible(true);
        }
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("ted_col_count", String.valueOf(this.sedpTable.getColumnModel().getColumnCount()));
        for (int i = 0; i < this.sedpTable.getColumnModel().getColumnCount(); ++i) {
            TableColumn tc = this.sedpTable.getColumnModel().getColumn(i);
            p.setProperty(String.format("ted_col%d_width", i), String.valueOf(tc.getWidth()));
        }
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        String colCountString = p.getProperty("ted_col_count");
        LOGGER.fine(String.format("Version: %s, colCount: %s", version, colCountString));
        try {
            int colCount = colCountString != null ? Integer.valueOf(colCountString) : 0;
            for (int i = 0; i < colCount; ++i) {
                String s = p.getProperty("ted_col" + i + "_width");
                LOGGER.fine(String.format("ted_col_%d_width: %s", i, s));
                if (s == null) continue;
                this.sedpTable.getColumnModel().getColumn(i).setPreferredWidth(Integer.valueOf(s));
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.warning(String.format("Error converting to number: %s", ex.getMessage()));
        }
    }
}

